/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.town.TownBoundingArea;
import net.shadowmage.ancientwarfare.structure.town.TownTemplate;

public class TownTemplateManager {
    public static final TownTemplateManager INSTANCE = new TownTemplateManager();
    private final HashMap<String, TownTemplate> templates = new HashMap();
    private final List<TownTemplate> searchCache = new ArrayList<TownTemplate>();

    private TownTemplateManager() {
    }

    public void loadTemplate(TownTemplate template) {
        this.templates.put(template.getTownTypeName(), template);
    }

    public TownTemplate getTemplate(String name) {
        return this.templates.get(name);
    }

    public TownTemplate selectTemplateForGeneration(World world, int x, int z, TownBoundingArea area) {
        TownTemplate selection = null;
        int width = area.getChunkWidth();
        int length = area.getChunkLength();
        int min = Math.min(width, length);
        String biomeName = AWStructureStatics.getBiomeName(world.func_72807_a(x, z));
        int totalWeight = 0;
        for (TownTemplate t : this.templates.values()) {
            int templateMinimumSize = t.getMinSize();
            if (min < templateMinimumSize || !this.isBiomeValid(biomeName, t)) continue;
            this.searchCache.add(t);
            totalWeight += t.getSelectionWeight();
        }
        if (!this.searchCache.isEmpty() && totalWeight > 0) {
            totalWeight = world.field_73012_v.nextInt(totalWeight);
            for (TownTemplate t : this.searchCache) {
                if ((totalWeight -= t.getSelectionWeight()) >= 0) continue;
                selection = t;
                break;
            }
        }
        this.searchCache.clear();
        return selection;
    }

    private boolean isBiomeValid(String biome, TownTemplate t) {
        boolean contains = t.getBiomeList().contains(biome);
        boolean wl = t.isBiomeWhiteList();
        return wl && contains || !wl && !contains;
    }
}

