/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.town.Direction;
import net.shadowmage.ancientwarfare.structure.town.TownBoundingArea;
import net.shadowmage.ancientwarfare.structure.town.TownGeneratorBorders;
import net.shadowmage.ancientwarfare.structure.town.TownGeneratorStructures;
import net.shadowmage.ancientwarfare.structure.town.TownGeneratorWalls;
import net.shadowmage.ancientwarfare.structure.town.TownPartBlock;
import net.shadowmage.ancientwarfare.structure.town.TownPartQuadrant;
import net.shadowmage.ancientwarfare.structure.town.TownTemplate;
import net.shadowmage.ancientwarfare.structure.world_gen.WorldGenTickHandler;

public class TownGenerator {
    public final TownTemplate template;
    public final World world;
    public final Random rng;
    public final int blockSize;
    public final int plotSize;
    public final StructureBB maximalBounds;
    public final StructureBB exteriorBounds;
    public final StructureBB wallsBounds;
    public final StructureBB townBounds;
    public final TownPartQuadrant[] quadrants = new TownPartQuadrant[4];
    public final TownPartQuadrant[] externalQuadrants = new TownPartQuadrant[8];
    public final List<StructureTemplate> uniqueTemplatesToGenerate = new ArrayList<StructureTemplate>();
    public final List<StructureTemplate> mainTemplatesToGenerate = new ArrayList<StructureTemplate>();
    public final List<StructureTemplate> houseTemplatesToGenerate = new ArrayList<StructureTemplate>();
    public final List<StructureTemplate> cosmeticTemplatesToGenerate = new ArrayList<StructureTemplate>();
    public final List<StructureTemplate> exteriorTemplatesToGenerate = new ArrayList<StructureTemplate>();
    public final List<BlockPosition> structureDoors = new ArrayList<BlockPosition>();

    public TownGenerator(World world, TownBoundingArea area, TownTemplate template) {
        this.world = world;
        this.template = template;
        long seed = area.townCenterX << 32 | area.townCenterZ;
        this.rng = new Random(seed);
        int y1 = area.getSurfaceY() + 1;
        int y2 = y1 + 20;
        area.wallSize = template.getWallSize();
        area.exteriorSize = template.getExteriorSize();
        this.maximalBounds = new StructureBB(area.getBlockMinX(), y1, area.getBlockMinZ(), area.getBlockMaxX(), y2, area.getBlockMaxZ());
        this.exteriorBounds = new StructureBB(area.getExteriorMinX(), y1, area.getExteriorMinZ(), area.getExteriorMaxX(), y2, area.getExteriorMaxZ());
        this.wallsBounds = new StructureBB(area.getWallMinX(), y1, area.getWallMinZ(), area.getWallMaxX(), y2, area.getWallMaxZ());
        this.townBounds = new StructureBB(area.getTownMinX(), y1, area.getTownMinZ(), area.getTownMaxX(), y2, area.getTownMaxZ());
        this.blockSize = template.getTownBlockSize();
        this.plotSize = template.getTownPlotSize();
    }

    public void generate() {
        AWLog.logDebug("Generating town at: " + this.townBounds.getCenterX() + " : " + this.townBounds.getCenterZ());
        this.determineStructuresToGenerate();
        TownGeneratorBorders.generateBorders(this.world, this.exteriorBounds, this.wallsBounds, this.maximalBounds);
        TownGeneratorBorders.levelTownArea(this.world, this.wallsBounds);
        this.generateGrid();
        TownGeneratorWalls.generateWalls(this.world, this, this.template, this.rng);
        WorldGenTickHandler.INSTANCE.addStructureGenCallback(new WorldGenTickHandler.StructureGenerationCallbackTicket(){

            @Override
            public void call() {
                TownGenerator.this.generateRoads();
                TownGeneratorStructures.generateStructures(TownGenerator.this);
            }
        });
    }

    public void generateVillagers() {
        float villagers = this.template.getRandomVillagersPerChunk();
        if (villagers > 0.0f) {
            int wholeVillagersPerChunk = 0;
            while (villagers > 1.0f) {
                ++wholeVillagersPerChunk;
                villagers -= 1.0f;
            }
            int x = this.townBounds.min.x;
            int y = this.townBounds.min.y;
            int z = this.townBounds.min.z;
            for (int bx = x; bx < x + this.townBounds.getXSize(); bx += 16) {
                for (int bz = z; bz < z + this.townBounds.getZSize(); bz += 16) {
                    for (int i = 0; i < wholeVillagersPerChunk; ++i) {
                        this.spawnVillager(bx, y, bz);
                    }
                    if (!(this.rng.nextFloat() < villagers)) continue;
                    this.spawnVillager(bx, y, bz);
                }
            }
        }
    }

    private void spawnVillager(int minX, int y, int minZ) {
        EntityVillager villager = new EntityVillager(this.world);
        villager.func_110161_a(null);
        for (int i = 0; i < 10; ++i) {
            int z;
            int x = minX + this.rng.nextInt(16);
            if (!this.world.func_147437_c(x, y, z = minZ + this.rng.nextInt(16)) || !this.world.func_147437_c(x, y + 1, z) || !this.world.isSideSolid(x, y - 1, z, ForgeDirection.UP)) continue;
            villager.func_70107_b((double)x + 0.5, (double)y, (double)z + 0.5);
            this.world.func_72838_d((Entity)villager);
            return;
        }
    }

    private void determineStructuresToGenerate() {
        int i;
        int gen;
        StructureTemplate t;
        for (TownTemplate.TownStructureEntry e : this.template.getUniqueStructureEntries()) {
            t = StructureTemplateManager.INSTANCE.getTemplate(e.templateName);
            if (t == null) continue;
            this.uniqueTemplatesToGenerate.add(t);
        }
        for (TownTemplate.TownStructureEntry e : this.template.getMainStructureEntries()) {
            t = StructureTemplateManager.INSTANCE.getTemplate(e.templateName);
            if (t == null) continue;
            this.mainTemplatesToGenerate.add(t);
        }
        for (TownTemplate.TownStructureEntry e : this.template.getHouseStructureEntries()) {
            t = StructureTemplateManager.INSTANCE.getTemplate(e.templateName);
            if (t == null) continue;
            gen = e.min;
            for (i = 0; i < gen; ++i) {
                this.houseTemplatesToGenerate.add(t);
            }
        }
        for (TownTemplate.TownStructureEntry e : this.template.getCosmeticEntries()) {
            t = StructureTemplateManager.INSTANCE.getTemplate(e.templateName);
            if (t == null) continue;
            gen = e.min;
            for (i = 0; i < gen; ++i) {
                this.cosmeticTemplatesToGenerate.add(t);
            }
        }
        for (TownTemplate.TownStructureEntry e : this.template.getExteriorStructureEntries()) {
            t = StructureTemplateManager.INSTANCE.getTemplate(e.templateName);
            if (t == null) continue;
            gen = e.min;
            for (i = 0; i < gen; ++i) {
                this.exteriorTemplatesToGenerate.add(t);
            }
        }
    }

    private void generateGrid() {
        int centerX = this.maximalBounds.getCenterX();
        int centerZ = this.maximalBounds.getCenterZ();
        int y1 = this.townBounds.min.y;
        int y2 = this.townBounds.max.y;
        boolean[] roadBorders = new boolean[]{true, false, false, true};
        StructureBB bb = new StructureBB(new BlockPosition(this.townBounds.min.x, y1, this.townBounds.min.z), new BlockPosition(centerX - 2, y2, centerZ - 2));
        TownPartQuadrant tq = new TownPartQuadrant(Direction.WEST, Direction.NORTH, bb, roadBorders, this);
        tq.subdivide(this.template.getTownBlockSize(), this.template.getTownPlotSize(), true);
        this.quadrants[0] = tq;
        roadBorders = new boolean[]{true, true, false, false};
        bb = new StructureBB(new BlockPosition(centerX + 1, y1, this.townBounds.min.z), new BlockPosition(this.townBounds.max.x, y2, centerZ - 2));
        tq = new TownPartQuadrant(Direction.EAST, Direction.NORTH, bb, roadBorders, this);
        tq.subdivide(this.template.getTownBlockSize(), this.template.getTownPlotSize(), true);
        this.quadrants[1] = tq;
        roadBorders = new boolean[]{false, true, true, false};
        bb = new StructureBB(new BlockPosition(centerX + 1, y1, centerZ + 1), new BlockPosition(this.townBounds.max.x, y2, this.townBounds.max.z));
        tq = new TownPartQuadrant(Direction.EAST, Direction.SOUTH, bb, roadBorders, this);
        tq.subdivide(this.template.getTownBlockSize(), this.template.getTownPlotSize(), true);
        this.quadrants[2] = tq;
        roadBorders = new boolean[]{false, false, true, true};
        bb = new StructureBB(new BlockPosition(this.townBounds.min.x, y1, centerZ + 1), new BlockPosition(centerX - 2, y2, this.townBounds.max.z));
        tq = new TownPartQuadrant(Direction.WEST, Direction.SOUTH, bb, roadBorders, this);
        tq.subdivide(this.template.getTownBlockSize(), this.template.getTownPlotSize(), true);
        this.quadrants[3] = tq;
        if (this.template.getExteriorSize() > 0) {
            this.generateExteriorGrid();
        }
    }

    private void generateExteriorGrid() {
        int centerX = this.maximalBounds.getCenterX();
        int centerZ = this.maximalBounds.getCenterZ();
        int eSize = this.template.getExteriorSize() * 16;
        int pSize = this.template.getTownPlotSize();
        int minY = this.maximalBounds.min.y;
        int maxY = this.maximalBounds.max.y;
        int minX = this.exteriorBounds.min.x;
        int minZ = this.exteriorBounds.min.z;
        int maxX = centerX - 3;
        int maxZ = this.wallsBounds.min.z - 1;
        boolean[] roadBorders = new boolean[]{false, false, false, false};
        StructureBB bb = new StructureBB(new BlockPosition(minX, minY, minZ), new BlockPosition(maxX, maxY, maxZ));
        this.externalQuadrants[0] = new TownPartQuadrant(Direction.WEST, Direction.NORTH, bb, roadBorders, this);
        minX = centerX + 2;
        minZ = this.exteriorBounds.min.z;
        maxX = this.exteriorBounds.max.x;
        maxZ = this.wallsBounds.min.z - 1;
        bb = new StructureBB(new BlockPosition(minX, minY, minZ), new BlockPosition(maxX, maxY, maxZ));
        this.externalQuadrants[1] = new TownPartQuadrant(Direction.EAST, Direction.NORTH, bb, roadBorders, this);
        minX = this.exteriorBounds.min.x;
        minZ = this.wallsBounds.min.z;
        maxX = this.wallsBounds.min.x - 1;
        maxZ = centerZ - 3;
        bb = new StructureBB(new BlockPosition(minX, minY, minZ), new BlockPosition(maxX, maxY, maxZ));
        this.externalQuadrants[2] = new TownPartQuadrant(Direction.WEST, Direction.NORTH, bb, roadBorders, this);
        minX = this.wallsBounds.max.x + 1;
        minZ = this.wallsBounds.min.z;
        maxX = this.exteriorBounds.max.x;
        maxZ = centerZ - 3;
        bb = new StructureBB(new BlockPosition(minX, minY, minZ), new BlockPosition(maxX, maxY, maxZ));
        this.externalQuadrants[3] = new TownPartQuadrant(Direction.EAST, Direction.NORTH, bb, roadBorders, this);
        minX = this.exteriorBounds.min.x;
        minZ = centerZ + 2;
        maxX = this.wallsBounds.min.x - 1;
        maxZ = this.wallsBounds.max.z;
        bb = new StructureBB(new BlockPosition(minX, minY, minZ), new BlockPosition(maxX, maxY, maxZ));
        this.externalQuadrants[4] = new TownPartQuadrant(Direction.WEST, Direction.NORTH, bb, roadBorders, this);
        minX = this.wallsBounds.max.x + 1;
        minZ = centerZ + 2;
        maxX = this.exteriorBounds.max.x;
        maxZ = this.wallsBounds.max.z;
        bb = new StructureBB(new BlockPosition(minX, minY, minZ), new BlockPosition(maxX, maxY, maxZ));
        this.externalQuadrants[5] = new TownPartQuadrant(Direction.EAST, Direction.NORTH, bb, roadBorders, this);
        minX = this.exteriorBounds.min.x;
        minZ = this.wallsBounds.max.z + 1;
        maxX = centerX - 3;
        maxZ = this.exteriorBounds.max.z;
        bb = new StructureBB(new BlockPosition(minX, minY, minZ), new BlockPosition(maxX, maxY, maxZ));
        this.externalQuadrants[6] = new TownPartQuadrant(Direction.WEST, Direction.SOUTH, bb, roadBorders, this);
        minX = centerX + 2;
        minZ = this.wallsBounds.max.z + 1;
        maxX = this.exteriorBounds.max.x;
        maxZ = this.exteriorBounds.max.z;
        bb = new StructureBB(new BlockPosition(minX, minY, minZ), new BlockPosition(maxX, maxY, maxZ));
        this.externalQuadrants[7] = new TownPartQuadrant(Direction.EAST, Direction.SOUTH, bb, roadBorders, this);
        for (TownPartQuadrant tq1 : this.externalQuadrants) {
            tq1.subdivide(eSize, pSize, false);
        }
    }

    private void generateRoads() {
        for (TownPartQuadrant tq : this.quadrants) {
            this.generateRoads(tq);
        }
        this.generateAdditionalRoads();
    }

    private void generateRoads(TownPartQuadrant tq) {
        int minX = tq.bb.min.x;
        int maxX = tq.bb.max.x;
        if (tq.hasRoadBorder(Direction.WEST)) {
            --minX;
        }
        if (tq.hasRoadBorder(Direction.EAST)) {
            ++maxX;
        }
        for (int x = minX; x <= maxX; ++x) {
            if (tq.hasRoadBorder(Direction.NORTH)) {
                this.genRoadBlock(x, tq.bb.min.y - 1, tq.bb.min.z - 1);
            }
            if (!tq.hasRoadBorder(Direction.SOUTH)) continue;
            this.genRoadBlock(x, tq.bb.min.y - 1, tq.bb.max.z + 1);
        }
        int minZ = tq.bb.min.z;
        int maxZ = tq.bb.max.z;
        if (tq.hasRoadBorder(Direction.NORTH)) {
            --minZ;
        }
        if (tq.hasRoadBorder(Direction.SOUTH)) {
            ++maxZ;
        }
        for (int z = minZ; z <= maxZ; ++z) {
            if (tq.hasRoadBorder(Direction.WEST)) {
                this.genRoadBlock(tq.bb.min.x - 1, tq.bb.min.y - 1, z);
            }
            if (!tq.hasRoadBorder(Direction.EAST)) continue;
            this.genRoadBlock(tq.bb.max.x + 1, tq.bb.min.y - 1, z);
        }
        for (TownPartBlock tb : tq.blocks) {
            this.generateRoads(tb);
        }
    }

    private void generateRoads(TownPartBlock tb) {
        int minX = tb.bb.min.x;
        int maxX = tb.bb.max.x;
        if (tb.hasRoadBorder(Direction.WEST)) {
            --minX;
        }
        if (tb.hasRoadBorder(Direction.EAST)) {
            ++maxX;
        }
        for (int x = minX; x <= maxX; ++x) {
            if (tb.hasRoadBorder(Direction.NORTH)) {
                this.genRoadBlock(x, tb.bb.min.y - 1, tb.bb.min.z - 1);
            }
            if (!tb.hasRoadBorder(Direction.SOUTH)) continue;
            this.genRoadBlock(x, tb.bb.min.y - 1, tb.bb.max.z + 1);
        }
        int minZ = tb.bb.min.z;
        int maxZ = tb.bb.max.z;
        if (tb.hasRoadBorder(Direction.NORTH)) {
            --minZ;
        }
        if (tb.hasRoadBorder(Direction.SOUTH)) {
            ++maxZ;
        }
        for (int z = minZ; z <= maxZ; ++z) {
            if (tb.hasRoadBorder(Direction.WEST)) {
                this.genRoadBlock(tb.bb.min.x - 1, tb.bb.min.y - 1, z);
            }
            if (!tb.hasRoadBorder(Direction.EAST)) continue;
            this.genRoadBlock(tb.bb.max.x + 1, tb.bb.min.y - 1, z);
        }
    }

    private void generateAdditionalRoads() {
        int z;
        int x;
        int y = this.maximalBounds.min.y - 1;
        int minX = this.maximalBounds.getCenterX() - 2;
        int maxX = minX + 3;
        int minZ = this.exteriorBounds.min.z;
        int maxZ = this.townBounds.min.z - 1;
        for (x = minX; x <= maxX; ++x) {
            for (z = minZ; z <= maxZ; ++z) {
                this.genRoadBlock(x, y, z);
            }
        }
        minX = this.townBounds.max.x + 1;
        minZ = this.maximalBounds.getCenterZ() - 2;
        maxX = this.exteriorBounds.max.x;
        maxZ = minZ + 3;
        for (x = minX; x <= maxX; ++x) {
            for (z = minZ; z <= maxZ; ++z) {
                this.genRoadBlock(x, y, z);
            }
        }
        minX = this.maximalBounds.getCenterX() - 2;
        minZ = this.townBounds.max.z + 1;
        maxX = minX + 3;
        maxZ = this.exteriorBounds.max.z;
        for (x = minX; x <= maxX; ++x) {
            for (z = minZ; z <= maxZ; ++z) {
                this.genRoadBlock(x, y, z);
            }
        }
        minX = this.exteriorBounds.min.x;
        minZ = this.maximalBounds.getCenterZ() - 2;
        maxX = this.townBounds.min.x - 1;
        maxZ = minZ + 3;
        for (x = minX; x <= maxX; ++x) {
            for (z = minZ; z <= maxZ; ++z) {
                this.genRoadBlock(x, y, z);
            }
        }
    }

    private void genRoadBlock(int x, int y, int z) {
        Block block = this.template.getRoadFillBlock();
        int meta = this.template.getRoadFillMeta();
        this.world.func_147465_d(x, y, z, block, meta, 3);
        this.world.func_147465_d(x, y - 1, z, Blocks.field_150347_e, 0, 3);
    }
}

