/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;

public class TEGateProxy
extends TileEntity {
    private EntityGate owner = null;
    private UUID entityID = null;
    private int noParentTicks = 0;

    public void setOwner(EntityGate gate) {
        this.owner = gate;
        this.entityID = this.owner.getPersistentID();
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("msb") && tag.func_74764_b("lsb")) {
            long msb = tag.func_74763_f("msb");
            long lsb = tag.func_74763_f("lsb");
            this.entityID = new UUID(msb, lsb);
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.entityID != null) {
            tag.func_74772_a("msb", this.entityID.getMostSignificantBits());
            tag.func_74772_a("lsb", this.entityID.getLeastSignificantBits());
        }
    }

    public boolean onBlockClicked(EntityPlayer player) {
        return this.owner == null || this.owner.func_130002_c(player);
    }

    public void onBlockAttacked(EntityPlayer player) {
        if (this.owner != null) {
            DamageSource source = player != null ? DamageSource.func_76365_a((EntityPlayer)player) : DamageSource.field_76377_j;
            this.owner.func_70097_a(source, 1.0f);
        }
    }

    public ItemStack onBlockPicked(MovingObjectPosition target) {
        if (this.owner != null) {
            return this.owner.getPickedResult(target);
        }
        return null;
    }

    public void func_145845_h() {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.entityID == null) {
            ++this.noParentTicks;
        } else if (this.owner == null) {
            ++this.noParentTicks;
            List entities = this.field_145850_b.field_72996_f;
            for (Entity ent : entities) {
                if (!(ent instanceof EntityGate) || ent.getPersistentID() == null || !ent.getPersistentID().equals(this.entityID)) continue;
                this.owner = (EntityGate)ent;
                this.noParentTicks = 0;
                break;
            }
        }
        if (this.noParentTicks >= 100 || this.owner != null && this.owner.field_70128_L) {
            this.owner = null;
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public boolean isGateClosed() {
        return this.owner != null && this.owner.isClosed();
    }
}

