/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.structure.network.PacketStructure;
import net.shadowmage.ancientwarfare.structure.network.PacketStructureRemove;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateClient;
import net.shadowmage.ancientwarfare.structure.template.WorldGenStructureManager;

public class StructureTemplateManager {
    private HashMap<String, StructureTemplateClient> clientTemplates = new HashMap();
    private HashMap<String, BufferedImage> templateImages = new HashMap();
    private HashMap<String, StructureTemplate> loadedTemplates = new HashMap();
    public static final StructureTemplateManager INSTANCE = new StructureTemplateManager();

    private StructureTemplateManager() {
    }

    public void addTemplate(StructureTemplate template) {
        if (template.getValidationSettings() == null) {
            return;
        }
        if (template.getValidationSettings().isWorldGenEnabled()) {
            WorldGenStructureManager.INSTANCE.registerWorldGenStructure(template);
        }
        this.loadedTemplates.put(template.name, template);
        StructureTemplateClient cl = new StructureTemplateClient(template);
        this.clientTemplates.put(template.name, cl);
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server != null && server.func_71278_l() && server.func_71203_ab() != null) {
            NBTTagCompound tag = new NBTTagCompound();
            cl.writeToNBT(tag);
            PacketStructure pkt = new PacketStructure();
            pkt.packetData.func_74782_a("singleStructure", (NBTBase)tag);
            NetworkHandler.sendToAllPlayers(pkt);
        }
    }

    public void onPlayerConnect(EntityPlayerMP player) {
        NBTTagList list = new NBTTagList();
        for (StructureTemplateClient cl : this.clientTemplates.values()) {
            NBTTagCompound tag = new NBTTagCompound();
            cl.writeToNBT(tag);
            list.func_74742_a((NBTBase)tag);
        }
        PacketStructure pkt = new PacketStructure();
        pkt.packetData.func_74782_a("structureList", (NBTBase)list);
        NetworkHandler.sendToPlayer(player, pkt);
    }

    public boolean removeTemplate(String name) {
        if (this.loadedTemplates.containsKey(name)) {
            this.loadedTemplates.remove(name);
            this.clientTemplates.remove(name);
            this.templateImages.remove(name);
            NetworkHandler.sendToAllPlayers(new PacketStructureRemove(name));
            return true;
        }
        return false;
    }

    public StructureTemplate getTemplate(String name) {
        return this.loadedTemplates.get(name);
    }

    public void addTemplateImage(String imageName, BufferedImage image) {
        this.templateImages.put(imageName, image);
    }

    public BufferedImage getTemplateImage(String imageName) {
        return this.templateImages.get(imageName);
    }
}

