/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.input.InputHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;
import net.shadowmage.ancientwarfare.structure.event.IBoxRenderer;
import net.shadowmage.ancientwarfare.structure.gates.types.Gate;
import net.shadowmage.ancientwarfare.structure.item.AWStructuresItemLoader;

public class ItemGateSpawner
extends Item
implements IItemKeyInterface,
IBoxRenderer {
    public ItemGateSpawner(String name) {
        this.func_77655_b(name);
        this.func_77637_a(AWStructuresItemLoader.structureTab);
        this.func_77625_d(1);
    }

    public IIcon func_77617_a(int par1) {
        return Gate.getGateByID(par1).getIconTexture();
    }

    public void func_94581_a(IIconRegister par1IconRegister) {
        Gate.registerIconsForGates(par1IconRegister);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        NBTTagCompound tag = stack.func_77942_o() && stack.func_77978_p().func_74764_b("AWGateInfo") ? stack.func_77978_p().func_74775_l("AWGateInfo") : new NBTTagCompound();
        if (tag.func_74764_b("pos1") && tag.func_74764_b("pos2")) {
            list.add(StatCollector.func_74838_a((String)"guistrings.gate.construct"));
        } else {
            String key = InputHandler.instance.getKeybindBinding("keybind.alt_item_use_1");
            list.add(StatCollector.func_74837_a((String)"guistrings.gate.use_primary_item_key", (Object[])new Object[]{key}));
        }
        list.add(StatCollector.func_74838_a((String)"guistrings.gate.clear_item"));
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 16; ++i) {
            Gate g = Gate.getGateByID(i);
            if (g == null) continue;
            list.add(g.getDisplayStack());
        }
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        return "item." + Gate.getGateByID(par1ItemStack.func_77960_j()).getDisplayName();
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return stack;
        }
        NBTTagCompound tag = stack.func_77942_o() && stack.func_77978_p().func_74764_b("AWGateInfo") ? stack.func_77978_p().func_74775_l("AWGateInfo") : new NBTTagCompound();
        if (player.func_70093_af()) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        } else if (tag.func_74764_b("pos1") && tag.func_74764_b("pos2")) {
            BlockPosition pos1 = new BlockPosition(tag.func_74775_l("pos1"));
            BlockPosition pos2 = new BlockPosition(tag.func_74775_l("pos2"));
            BlockPosition avg = BlockTools.getAverageOf(pos1, pos2);
            int max = 10;
            if (pos1.x - pos2.x > max) {
                max = pos1.x - pos2.x;
            } else if (pos2.x - pos1.x > max) {
                max = pos2.x - pos1.x;
            }
            if (pos1.z - pos2.z > max) {
                max = pos1.z - pos2.z;
            } else if (pos2.z - pos1.z > max) {
                max = pos2.z - pos1.z;
            }
            if (player.func_70011_f((double)avg.x + 0.5, (double)pos1.y + 0.5, (double)avg.z + 0.5) > (double)max && player.func_70011_f((double)avg.x + 0.5, (double)pos2.y + 0.5, (double)avg.z + 0.5) > (double)max) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("guistrings.gate.too_far", new Object[0]));
                return stack;
            }
            if (!this.canSpawnGate(world, pos1, pos2)) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("guistrings.gate.exists", new Object[0]));
                return stack;
            }
            byte facing = (byte)BlockTools.getPlayerFacingFromYaw(player.field_70177_z);
            EntityGate entity = Gate.constructGate(world, pos1, pos2, Gate.getGateByID(stack.func_77960_j()), facing);
            if (entity != null) {
                entity.setOwnerName(player.func_70005_c_());
                world.func_72838_d((Entity)entity);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                tag.func_82580_o("pos1");
                tag.func_82580_o("pos2");
                stack.func_77982_d(tag);
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("guistrings.gate.need_to_clear", new Object[0]));
            }
        }
        return stack;
    }

    protected boolean canSpawnGate(World world, BlockPosition pos1, BlockPosition pos2) {
        BlockPosition min = BlockTools.getMin(pos1, pos2);
        BlockPosition max = BlockTools.getMax(pos1, pos2);
        AxisAlignedBB newGateBB = AxisAlignedBB.func_72330_a((double)min.x, (double)min.y, (double)min.z, (double)(max.x + 1), (double)(max.y + 1), (double)(max.z + 1));
        List gates = world.func_72872_a(EntityGate.class, newGateBB);
        for (EntityGate gate : gates) {
            min = BlockTools.getMin(gate.pos1, gate.pos2);
            max = BlockTools.getMax(gate.pos1, gate.pos2);
            AxisAlignedBB oldGateBB = AxisAlignedBB.func_72330_a((double)min.x, (double)min.y, (double)min.z, (double)(max.x + 1), (double)(max.y + 1), (double)(max.z + 1));
            if (!oldGateBB.func_72326_a(newGateBB)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemKey key) {
        return key == IItemKeyInterface.ItemKey.KEY_0;
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemKey key) {
        BlockPosition hit = BlockTools.getBlockClickedOn(player, player.field_70170_p, true);
        if (hit == null) {
            return;
        }
        NBTTagCompound tag = stack.func_77942_o() && stack.func_77978_p().func_74764_b("AWGateInfo") ? stack.func_77978_p().func_74775_l("AWGateInfo") : new NBTTagCompound();
        if (!tag.func_74764_b("pos2")) {
            if (tag.func_74764_b("pos1")) {
                Gate g = Gate.getGateByID(stack.func_77960_j());
                if (g.arePointsValidPair(new BlockPosition(tag.func_74775_l("pos1")), hit)) {
                    tag.func_74782_a("pos2", (NBTBase)hit.writeToNBT(new NBTTagCompound()));
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("guistrings.gate.set_pos_two", new Object[0]));
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("guistrings.gate.invalid_position", new Object[0]));
                }
            } else {
                tag.func_74782_a("pos1", (NBTBase)hit.writeToNBT(new NBTTagCompound()));
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("guistrings.gate.set_pos_one", new Object[0]));
            }
        }
        stack.func_77983_a("AWGateInfo", (NBTBase)tag);
    }

    @Override
    public void renderBox(EntityPlayer player, ItemStack stack, float delta) {
        BlockPosition p2;
        BlockPosition p1;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("AWGateInfo")) {
            if ((tag = tag.func_74775_l("AWGateInfo")).func_74764_b("pos1")) {
                p1 = new BlockPosition(tag.func_74775_l("pos1"));
                if (tag.func_74764_b("pos2")) {
                    p2 = new BlockPosition(tag.func_74775_l("pos2"));
                } else {
                    p2 = BlockTools.getBlockClickedOn(player, player.field_70170_p, true);
                    if (p2 == null) {
                        return;
                    }
                }
            } else {
                p1 = BlockTools.getBlockClickedOn(player, player.field_70170_p, true);
                if (p1 == null) {
                    return;
                }
                p2 = p1;
            }
        } else {
            p1 = BlockTools.getBlockClickedOn(player, player.field_70170_p, true);
            if (p1 == null) {
                return;
            }
            p2 = p1;
        }
        IBoxRenderer.Util.renderBoundingBox(player, BlockTools.getMin(p1, p2), BlockTools.getMax(p1, p2), delta);
    }
}

