/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.StatCollector;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.NumberInput;
import net.shadowmage.ancientwarfare.core.interfaces.IWidgetSelection;
import net.shadowmage.ancientwarfare.structure.gui.GuiStructureScanner;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationProperty;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;

public class GuiStructureValidationSettings
extends GuiContainerBase {
    private final GuiStructureScanner parent;
    private CompositeScrolled area;
    private Label typeLabel;
    private final Set<Button> typeButtons = new HashSet<Button>();
    private final HashMap<Button, StructureValidationType> buttonToValidationType = new HashMap();

    public GuiStructureValidationSettings(GuiStructureScanner parent) {
        super((ContainerBase)((Object)parent.getContainer()));
        this.parent = parent;
        this.shouldCloseOnVanillaKeys = false;
    }

    @Override
    public void initElements() {
        this.area = new CompositeScrolled(this, 0, 30, 256, 210);
        this.addGuiElement(this.area);
        Listener listener = new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (widget.isMouseOverElement(evt.mx, evt.my)) {
                    GuiStructureValidationSettings.this.onTypeButtonPressed((Button)widget);
                }
                return true;
            }
        };
        Button button = new Button(8, 8, 78, 16, StructureValidationType.GROUND.getName());
        button.addNewListener(listener);
        this.buttonToValidationType.put(button, StructureValidationType.GROUND);
        this.typeButtons.add(button);
        button = new Button(86, 8, 78, 16, StructureValidationType.UNDERGROUND.getName());
        button.addNewListener(listener);
        this.buttonToValidationType.put(button, StructureValidationType.UNDERGROUND);
        this.typeButtons.add(button);
        button = new Button(164, 8, 78, 16, StructureValidationType.SKY.getName());
        button.addNewListener(listener);
        this.buttonToValidationType.put(button, StructureValidationType.SKY);
        this.typeButtons.add(button);
        button = new Button(8, 24, 78, 16, StructureValidationType.WATER.getName());
        button.addNewListener(listener);
        this.buttonToValidationType.put(button, StructureValidationType.WATER);
        this.typeButtons.add(button);
        button = new Button(86, 24, 78, 16, StructureValidationType.UNDERWATER.getName());
        button.addNewListener(listener);
        this.buttonToValidationType.put(button, StructureValidationType.UNDERWATER);
        this.typeButtons.add(button);
        button = new Button(164, 24, 78, 16, StructureValidationType.ISLAND.getName());
        button.addNewListener(listener);
        this.buttonToValidationType.put(button, StructureValidationType.ISLAND);
        this.typeButtons.add(button);
        button = new Button(8, 40, 78, 16, StructureValidationType.HARBOR.getName());
        button.addNewListener(listener);
        this.buttonToValidationType.put(button, StructureValidationType.HARBOR);
        this.typeButtons.add(button);
        this.typeLabel = new Label(8, 8, "");
        this.addGuiElement(this.typeLabel);
        button = new Button(193, 8, 55, 12, "guistrings.done");
        button.addNewListener(new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (widget.isMouseOverElement(evt.mx, evt.my)) {
                    GuiStructureValidationSettings.this.closeGui();
                }
                return true;
            }
        });
        this.addGuiElement(button);
    }

    private void onTypeButtonPressed(Button button) {
        StructureValidationType type = this.buttonToValidationType.get(button);
        if (type == null) {
            return;
        }
        StructureValidator newValidator = type.getValidator();
        newValidator.inheritPropertiesFrom(this.parent.validator);
        this.parent.validationType = type;
        this.parent.validator = newValidator;
        this.refreshGui();
    }

    @Override
    public void setupElements() {
        this.typeLabel.setText(StatCollector.func_74838_a((String)"guistrings.validation_type") + ": " + this.parent.validationType.getName());
        int totalHeight = 0;
        this.area.clearElements();
        for (Button b : this.typeButtons) {
            this.area.addGuiElement(b);
        }
        totalHeight += 60;
        Label label = null;
        for (StructureValidationProperty property : this.parent.validator.getProperties()) {
            String propName = property.getRegName();
            if (propName.equals("biomeList") || propName.equals("biomeWhiteList") || propName.equals("dimensionList") || propName.equals("dimensionWhiteList") || propName.equals("blockList")) continue;
            label = new Label(8, totalHeight, "structure.validation." + property.getRegName());
            this.area.addGuiElement(label);
            switch (property.getDataType()) {
                case 1: {
                    PropertyNumberInputInteger input = new PropertyNumberInputInteger(200, totalHeight - 1, 32, property, this);
                    this.area.addGuiElement(input);
                    break;
                }
                case 3: {
                    PropertyCheckbox box = new PropertyCheckbox(200, totalHeight - 3, 16, 16, property);
                    this.area.addGuiElement(box);
                }
            }
            totalHeight += 16;
        }
        this.area.setAreaSize(totalHeight);
    }

    @Override
    protected boolean onGuiCloseRequested() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this.parent);
        return false;
    }

    private class PropertyNumberInputInteger
    extends NumberInput {
        final StructureValidationProperty prop;

        public PropertyNumberInputInteger(int topLeftX, int topLeftY, int width, StructureValidationProperty property, IWidgetSelection selector) {
            super(topLeftX, topLeftY, width, property.getDataInt(), selector);
            this.prop = property;
            this.setIntegerValue();
        }

        @Override
        public void onValueUpdated(float value) {
            this.prop.setValue((int)value);
        }
    }

    private class PropertyCheckbox
    extends Checkbox {
        final StructureValidationProperty prop;

        public PropertyCheckbox(int topLeftX, int topLeftY, int width, int height, StructureValidationProperty property) {
            super(topLeftX, topLeftY, width, height, "");
            this.prop = property;
            this.setChecked(this.prop.getDataBoolean());
        }

        @Override
        public void onToggled() {
            this.prop.setValue(this.checked());
        }
    }
}

