/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.interfaces.IEntityPacketHandler;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.network.PacketEntity;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.gates.types.Gate;
import net.shadowmage.ancientwarfare.structure.gates.types.GateRotatingBridge;

public class EntityGate
extends Entity
implements IEntityAdditionalSpawnData,
IEntityPacketHandler {
    public BlockPosition pos1;
    public BlockPosition pos2;
    public float edgePosition;
    public float edgeMax;
    public float openingSpeed = 0.0f;
    Gate gateType = Gate.getGateByID(0);
    String ownerName;
    int health = 0;
    public int hurtAnimationTicks = 0;
    byte gateStatus = 0;
    public byte gateOrientation = 0;
    public int hurtInvulTicks = 0;
    boolean hasSetWorldEntityRadius = false;
    public boolean wasPoweredA = false;
    public boolean wasPoweredB = false;

    public EntityGate(World par1World) {
        super(par1World);
        this.field_70129_M = 0.0f;
        this.field_70158_ak = true;
        this.field_70156_m = true;
    }

    public void setOwnerName(String name) {
        this.ownerName = name;
    }

    public Team getTeam() {
        return this.field_70170_p.func_96441_U().func_96509_i(this.ownerName);
    }

    public Gate getGateType() {
        return this.gateType;
    }

    public void setGateType(Gate type) {
        this.gateType = type;
        this.setHealth(type.getMaxHealth());
    }

    protected void func_70088_a() {
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return Gate.getItemToConstruct(this.gateType.getGlobalID());
    }

    public void repackEntity() {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return;
        }
        this.gateType.onGateStartOpen(this);
        this.gateType.onGateStartClose(this);
        ItemStack item = Gate.getItemToConstruct(this.gateType.getGlobalID());
        EntityItem entity = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, item);
        this.field_70170_p.func_72838_d((Entity)entity);
        this.func_70106_y();
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.field_70170_p.field_72995_K) {
            this.gateType.onGateStartOpen(this);
            this.gateType.onGateStartClose(this);
        }
    }

    protected void setOpeningStatus(byte op) {
        this.gateStatus = op;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, op);
        }
        if (op == -1) {
            this.gateType.onGateStartClose(this);
        } else if (op == 1) {
            this.gateType.onGateStartOpen(this);
        }
    }

    public int func_70070_b(float par1) {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70161_v);
        int k = MathHelper.func_76128_c((double)this.field_70163_u);
        if (this.pos1.y > k) {
            k = this.pos1.y;
        }
        if (this.pos2.y > k) {
            k = this.pos2.y;
        }
        return this.field_70170_p.func_72802_i(i, k, j, 0);
    }

    public void func_70103_a(byte par1) {
        if (this.field_70170_p.field_72995_K && (par1 == -1 || par1 == 0 || par1 == 1)) {
            this.setOpeningStatus(par1);
        }
        super.func_70103_a(par1);
    }

    public boolean isClosed() {
        return this.gateStatus == 0 && this.edgePosition == 0.0f;
    }

    public byte getOpeningStatus() {
        return this.gateStatus;
    }

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int val) {
        if (val < 0) {
            val = 0;
        }
        if (val < this.health) {
            this.hurtAnimationTicks = 20;
        }
        if (val < this.health && !this.field_70170_p.field_72995_K) {
            PacketEntity pkt = new PacketEntity(this);
            pkt.packetData.func_74768_a("health", val);
            NetworkHandler.sendToAllTracking(this, pkt);
        }
        this.health = val;
    }

    public void func_70107_b(double par1, double par3, double par5) {
        this.field_70165_t = par1;
        this.field_70163_u = par3;
        this.field_70161_v = par5;
        if (this.gateType != null) {
            this.gateType.setCollisionBoundingBox(this);
        }
    }

    public void func_70056_a(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.func_70107_b(par1, par3, par5);
        this.func_70101_b(par7, par8);
    }

    public boolean func_130002_c(EntityPlayer par1EntityPlayer) {
        boolean canInteract;
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        boolean bl = canInteract = par1EntityPlayer.func_70005_c_().equals(this.ownerName) || par1EntityPlayer.func_96124_cp() != null && par1EntityPlayer.func_96124_cp().func_142054_a(this.getTeam());
        if (canInteract) {
            if (par1EntityPlayer.func_70093_af()) {
                NetworkHandler.INSTANCE.openGui(par1EntityPlayer, 11, this.func_145782_y(), 0, 0);
            } else {
                this.activateGate();
            }
            return true;
        }
        par1EntityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("guistrings.gate.use_error", new Object[0]));
        return false;
    }

    public void activateGate() {
        if (this.gateStatus == 1 && this.gateType.canActivate(this, false)) {
            this.setOpeningStatus((byte)-1);
        } else if (this.gateStatus == -1 && this.gateType.canActivate(this, true)) {
            this.setOpeningStatus((byte)1);
        } else if (this.edgePosition == 0.0f && this.gateType.canActivate(this, true)) {
            this.setOpeningStatus((byte)1);
        } else if (this.gateType.canActivate(this, false)) {
            this.setOpeningStatus((byte)-1);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.gateType.onUpdate(this);
        float prevEdge = this.edgePosition;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.hurtInvulTicks > 0) {
            --this.hurtInvulTicks;
        }
        this.checkForPowerUpdates();
        if (this.hurtAnimationTicks > 0) {
            --this.hurtAnimationTicks;
        }
        if (this.gateStatus == 1) {
            this.edgePosition += this.gateType.getMoveSpeed();
            if (this.edgePosition >= this.edgeMax) {
                this.edgePosition = this.edgeMax;
                this.gateStatus = 0;
                this.gateType.onGateFinishOpen(this);
            }
        } else if (this.gateStatus == -1) {
            this.edgePosition -= this.gateType.getMoveSpeed();
            if (this.edgePosition <= 0.0f) {
                this.edgePosition = 0.0f;
                this.gateStatus = 0;
                this.gateType.onGateFinishClose(this);
            }
        }
        this.openingSpeed = prevEdge - this.edgePosition;
        if (!this.hasSetWorldEntityRadius) {
            this.hasSetWorldEntityRadius = true;
            BlockPosition min = BlockTools.getMin(this.pos1, this.pos2);
            BlockPosition max = BlockTools.getMax(this.pos1, this.pos2);
            int xSize = max.x - min.x + 1;
            int zSize = max.z - min.z + 1;
            int ySize = max.y - min.y + 1;
            int largest = xSize > ySize ? xSize : ySize;
            largest = largest > zSize ? largest : zSize;
            if (World.MAX_ENTITY_RADIUS < (double)(largest = largest / 2 + 1)) {
                World.MAX_ENTITY_RADIUS = largest;
            }
        }
    }

    protected void checkForPowerUpdates() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        boolean activate = false;
        int y = this.pos2.y < this.pos1.y ? this.pos2.y : this.pos1.y;
        boolean foundPowerA = this.field_70170_p.func_72864_z(this.pos1.x, y, this.pos1.z);
        boolean foundPowerB = this.field_70170_p.func_72864_z(this.pos2.x, y, this.pos2.z);
        if (foundPowerA && !this.wasPoweredA) {
            activate = true;
        }
        if (foundPowerB && !this.wasPoweredB) {
            activate = true;
        }
        this.wasPoweredA = foundPowerA;
        this.wasPoweredB = foundPowerB;
        if (activate) {
            this.activateGate();
        }
    }

    private boolean isInsensitiveTo(DamageSource source) {
        return source == null || source == DamageSource.field_82728_o || source == DamageSource.field_76367_g || source == DamageSource.field_76369_e || source == DamageSource.field_76379_h || source == DamageSource.field_82729_p || source == DamageSource.field_76368_d || source == DamageSource.field_76366_f;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.isInsensitiveTo(par1DamageSource) || par2 < 0.0f) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        if (!par1DamageSource.func_94541_c()) {
            if (this.hurtInvulTicks > 0) {
                return false;
            }
            this.hurtInvulTicks = 10;
        }
        int health = this.getHealth();
        health = (int)((float)health - par2);
        this.setHealth(health);
        if (health <= 0) {
            this.func_70106_y();
        }
        return !this.field_70128_L;
    }

    public void func_71027_c(int dimension) {
    }

    public boolean func_70072_I() {
        return false;
    }

    public void func_70060_a(float moveX, float moveZ, float factor) {
    }

    public void func_70024_g(double moveX, double moveY, double moveZ) {
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return -0.1f;
    }

    public boolean func_70104_M() {
        return true;
    }

    public void func_70108_f(Entity entity) {
        super.func_70108_f(entity);
        if (this.isInside(entity)) {
            entity.func_70024_g(0.0, (double)(-this.gateStatus) * 0.5, 0.0);
        }
    }

    public void func_70100_b_(EntityPlayer entity) {
        if (this.isInside((Entity)entity)) {
            entity.func_70024_g(0.0, (double)(-this.gateStatus) * 0.5, 0.0);
        }
    }

    private boolean isInside(Entity entity) {
        return this.gateType instanceof GateRotatingBridge && this.field_70121_D.func_72326_a(entity.field_70121_D);
    }

    public void func_70078_a(Entity mont) {
    }

    public String getTexture() {
        return "textures/models/gate/" + this.gateType.getTexture();
    }

    public float func_70053_R() {
        return 0.0f;
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.pos1 = new BlockPosition(tag.func_74775_l("pos1"));
        this.pos2 = new BlockPosition(tag.func_74775_l("pos2"));
        this.setGateType(Gate.getGateByID(tag.func_74762_e("type")));
        this.ownerName = tag.func_74779_i("owner");
        this.edgePosition = tag.func_74760_g("edge");
        this.edgeMax = tag.func_74760_g("edgeMax");
        this.setHealth(tag.func_74762_e("health"));
        this.gateStatus = tag.func_74771_c("status");
        this.gateOrientation = tag.func_74771_c("orient");
        this.wasPoweredA = tag.func_74767_n("power");
        this.wasPoweredB = tag.func_74767_n("power2");
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74782_a("pos1", (NBTBase)this.pos1.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("pos2", (NBTBase)this.pos2.writeToNBT(new NBTTagCompound()));
        tag.func_74768_a("type", this.gateType.getGlobalID());
        if (this.ownerName != null && !this.ownerName.isEmpty()) {
            tag.func_74778_a("owner", this.ownerName);
        }
        tag.func_74776_a("edge", this.edgePosition);
        tag.func_74776_a("edgeMax", this.edgeMax);
        tag.func_74768_a("health", this.getHealth());
        tag.func_74774_a("status", this.gateStatus);
        tag.func_74774_a("orient", this.gateOrientation);
        tag.func_74757_a("power", this.wasPoweredA);
        tag.func_74757_a("power2", this.wasPoweredB);
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.pos1.x);
        data.writeInt(this.pos1.y);
        data.writeInt(this.pos1.z);
        data.writeInt(this.pos2.x);
        data.writeInt(this.pos2.y);
        data.writeInt(this.pos2.z);
        data.writeInt(this.gateType.getGlobalID());
        data.writeFloat(this.edgePosition);
        data.writeFloat(this.edgeMax);
        data.writeByte((int)this.gateStatus);
        data.writeByte((int)this.gateOrientation);
        data.writeInt(this.health);
    }

    public void readSpawnData(ByteBuf data) {
        this.pos1 = new BlockPosition(data.readInt(), data.readInt(), data.readInt());
        this.pos2 = new BlockPosition(data.readInt(), data.readInt(), data.readInt());
        this.gateType = Gate.getGateByID(data.readInt());
        this.edgePosition = data.readFloat();
        this.edgeMax = data.readFloat();
        this.gateStatus = data.readByte();
        this.gateOrientation = data.readByte();
        this.health = data.readInt();
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("health")) {
            this.health = tag.func_74762_e("health");
            this.hurtAnimationTicks = 20;
        }
    }
}

