/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.trade;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.shadowmage.ancientwarfare.npc.trade.POTrade;

public class POTradeList {
    List<POTrade> tradeList = new ArrayList<POTrade>();

    public void decrementTrade(int index) {
        if (index <= 0 || index >= this.tradeList.size()) {
            return;
        }
        POTrade t = this.tradeList.remove(index);
        this.tradeList.add(index - 1, t);
    }

    public void incrementTrade(int index) {
        if (index < 0 || index >= this.tradeList.size() - 1) {
            return;
        }
        POTrade t = this.tradeList.remove(index);
        this.tradeList.add(index + 1, t);
    }

    public void deleteTrade(int index) {
        if (index < 0 || index >= this.tradeList.size()) {
            return;
        }
        this.tradeList.remove(index);
    }

    public void addNewTrade() {
        this.tradeList.add(new POTrade());
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (POTrade aTrade : this.tradeList) {
            list.func_74742_a((NBTBase)aTrade.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("tradeList", (NBTBase)list);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.tradeList.clear();
        NBTTagList list = tag.func_150295_c("tradeList", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            POTrade t = new POTrade();
            t.readFromNBT(list.func_150305_b(i));
            this.tradeList.add(t);
        }
    }

    public void getTrades(List<POTrade> trades) {
        trades.addAll(this.tradeList);
    }

    public void performTrade(EntityPlayer player, IInventory tradeInput, IInventory storage, int integer) {
        this.tradeList.get(integer).perfromTrade(player, tradeInput, storage);
    }
}

