/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.trade;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.npc.trade.Trade;

public class FactionTrade
extends Trade {
    private int refillFrequency;
    private int ticksTilRefill;
    private int maxAvailable;
    private int currentAvailable;

    public FactionTrade() {
        this.ticksTilRefill = this.refillFrequency = 6000;
        this.maxAvailable = 1;
        this.currentAvailable = 1;
    }

    public boolean hasItems() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.getInputStack(i) == null && this.getOutputStack(i) == null) continue;
            return true;
        }
        return false;
    }

    public int getRefillFrequency() {
        return this.refillFrequency;
    }

    public int getMaxAvailable() {
        return this.maxAvailable;
    }

    public int getCurrentAvailable() {
        return this.currentAvailable;
    }

    public void setRefillFrequency(int refill) {
        this.ticksTilRefill = this.refillFrequency = refill;
    }

    public void setMaxAvailable(int max) {
        this.maxAvailable = max;
        this.currentAvailable = max;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("refillFrequency", this.refillFrequency);
        tag.func_74768_a("ticksTilRefill", this.ticksTilRefill);
        tag.func_74768_a("maxAvailable", this.maxAvailable);
        tag.func_74768_a("currentAvailable", this.currentAvailable);
        return super.writeToNBT(tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.refillFrequency = tag.func_74762_e("refillFrequency");
        this.ticksTilRefill = tag.func_74762_e("ticksTilRefill");
        this.maxAvailable = tag.func_74762_e("maxAvailable");
        this.currentAvailable = tag.func_74762_e("currentAvailable");
        super.readFromNBT(tag);
    }

    public void updateTrade(int ticks) {
        this.ticksTilRefill += ticks;
        if (this.refillFrequency > 0) {
            while (this.ticksTilRefill >= this.refillFrequency) {
                this.ticksTilRefill -= this.refillFrequency;
                if (this.currentAvailable >= this.maxAvailable) continue;
                ++this.currentAvailable;
            }
        } else if (this.refillFrequency == 0) {
            this.currentAvailable = this.maxAvailable;
        }
    }

    @Override
    public void performTrade(EntityPlayer player, IInventory storage) {
        if (this.currentAvailable > 0) {
            super.performTrade(player, null);
        }
    }

    @Override
    protected void doTrade(EntityPlayer player, IInventory storage) {
        if (this.refillFrequency != 0) {
            --this.currentAvailable;
        }
        super.doTrade(player, storage);
    }
}

