/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.orders;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.interfaces.INBTSerialable;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.interfaces.IWorker;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.OrderingList;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.item.ItemWorkOrder;

public class WorkOrder
extends OrderingList<WorkEntry>
implements INBTSerialable {
    public static final int MAX_SIZE = 8;
    private WorkPriorityType priorityType = WorkPriorityType.ROUTE;
    private boolean nightShift;

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.clear();
        NBTTagList entryList = tag.func_150295_c("entryList", 10);
        for (int i = 0; i < entryList.func_74745_c(); ++i) {
            this.add(new WorkEntry(entryList.func_150305_b(i)));
        }
        this.priorityType = WorkPriorityType.values()[tag.func_74762_e("priorityType")];
        this.nightShift = tag.func_74767_n("nightShift");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagList entryList = new NBTTagList();
        for (WorkEntry entry : this.points) {
            entryList.func_74742_a((NBTBase)entry.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("entryList", (NBTBase)entryList);
        tag.func_74768_a("priorityType", this.priorityType.ordinal());
        tag.func_74757_a("nightShift", this.nightShift);
        return tag;
    }

    public boolean isNightShift() {
        return this.nightShift;
    }

    public void toggleShift() {
        this.nightShift = !this.nightShift;
    }

    public WorkPriorityType getPriorityType() {
        return this.priorityType;
    }

    public List<WorkEntry> getEntries() {
        return this.points;
    }

    public boolean addWorkPosition(World world, BlockPosition position) {
        if (position != null && this.size() < 8) {
            this.add(new WorkEntry(position, world.field_73011_w.field_76574_g, 0));
            return true;
        }
        return false;
    }

    public String toString() {
        return "Work Orders size: " + this.size() + " of type: " + (Object)((Object)this.priorityType);
    }

    public static WorkOrder getWorkOrder(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemWorkOrder) {
            WorkOrder order = new WorkOrder();
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("orders")) {
                order.readFromNBT(stack.func_77978_p().func_74775_l("orders"));
            }
            return order;
        }
        return null;
    }

    public void write(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemWorkOrder) {
            stack.func_77983_a("orders", (NBTBase)this.writeToNBT(new NBTTagCompound()));
        }
    }

    public void togglePriority() {
        WorkPriorityType[] type = WorkPriorityType.values();
        this.priorityType = type[(this.priorityType.ordinal() + 1) % type.length];
    }

    public static enum WorkPriorityType {
        SITE_NEED{

            @Override
            public int getNextWorkIndex(int current, List<WorkEntry> orders, NpcBase npc) {
                for (int i = 0; i < orders.size(); ++i) {
                    IWorkSite site;
                    BlockPosition pos = orders.get(i).getPosition();
                    TileEntity te = npc.field_70170_p.func_147438_o(pos.x, pos.y, pos.z);
                    if (!(te instanceof IWorkSite) || !((IWorker)((Object)npc)).canWorkAt((site = (IWorkSite)te).getWorkType()) || !site.hasWork()) continue;
                    return i;
                }
                return 0;
            }
        }
        ,
        ROUTE,
        TIMED;


        public int getNextWorkIndex(int current, List<WorkEntry> orders, NpcBase npcBase) {
            if (current + 1 >= orders.size()) {
                return 0;
            }
            return current + 1;
        }

        public boolean isTimed() {
            return this == TIMED;
        }
    }

    public static final class WorkEntry {
        private BlockPosition position;
        int dimension;
        private int workLength;

        private WorkEntry(NBTTagCompound tag) {
            this.readFromNBT(tag);
        }

        public WorkEntry(BlockPosition position, int dimension, int workLength) {
            this.setPosition(position);
            this.dimension = dimension;
            this.setWorkLength(workLength);
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.setPosition(new BlockPosition(tag.func_74775_l("pos")));
            this.dimension = tag.func_74762_e("dim");
            this.setWorkLength(tag.func_74762_e("length"));
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74782_a("pos", (NBTBase)this.getPosition().writeToNBT(new NBTTagCompound()));
            tag.func_74768_a("dim", this.dimension);
            tag.func_74768_a("length", this.getWorkLength());
            return tag;
        }

        public Block getBlock() {
            return this.getPosition().get(this.dimension);
        }

        public BlockPosition getPosition() {
            return this.position;
        }

        public void setPosition(BlockPosition position) {
            this.position = position;
        }

        public int getWorkLength() {
            return this.workLength;
        }

        public void setWorkLength(int workLength) {
            this.workLength = workLength;
        }
    }
}

