/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.item;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.interfaces.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.RayTraceUtils;
import net.shadowmage.ancientwarfare.npc.item.ItemOrders;
import net.shadowmage.ancientwarfare.npc.orders.TradeOrder;

public class ItemTradeOrder
extends ItemOrders {
    @Override
    public Collection<? extends BlockPosition> getPositionsForRender(ItemStack stack) {
        ArrayList<BlockPosition> positionList = new ArrayList<BlockPosition>();
        TradeOrder order = TradeOrder.getTradeOrder(stack);
        if (order != null && order.getRoute().size() > 0) {
            for (int i = 0; i < order.getRoute().size(); ++i) {
                positionList.add(order.getRoute().get(i).getPosition());
            }
        }
        return positionList;
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemKey key) {
        return key == IItemKeyInterface.ItemKey.KEY_0 || key == IItemKeyInterface.ItemKey.KEY_1 || key == IItemKeyInterface.ItemKey.KEY_2;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 6, 0, 0, 0);
        }
        return stack;
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemKey key) {
        MovingObjectPosition hit = RayTraceUtils.getPlayerTarget(player, 5.0f, 0.0f);
        if (hit == null || hit.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        TradeOrder order = TradeOrder.getTradeOrder(stack);
        BlockPosition pos = new BlockPosition(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
        if (key == IItemKeyInterface.ItemKey.KEY_0) {
            order.getRoute().addRoutePoint(pos);
            order.write(stack);
        } else if (key == IItemKeyInterface.ItemKey.KEY_1) {
            order.getRestockData().setDepositPoint(pos, hit.field_72310_e);
            order.write(stack);
        } else if (key == IItemKeyInterface.ItemKey.KEY_2) {
            order.getRestockData().setWithdrawPoint(pos, hit.field_72310_e);
            order.write(stack);
        }
    }
}

