/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.api.AWItems;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.npc.entity.AWNPCEntityLoader;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.item.AWNpcItemLoader;

public class ItemNpcSpawner
extends Item {
    private HashMap<String, String> iconNames = new HashMap();
    private HashMap<String, IIcon> iconMap = new HashMap();

    public ItemNpcSpawner() {
        this.func_77637_a(AWNpcItemLoader.npcTab);
        this.func_111206_d("ancientwarfare:npc/spawner_miner");
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        list.add(StatCollector.func_74838_a((String)"guistrings.npc.spawner.right_click_to_place"));
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        String npcName = ItemNpcSpawner.getNpcType(par1ItemStack);
        if (npcName != null) {
            String npcSub = ItemNpcSpawner.getNpcSubtype(par1ItemStack);
            if (!npcSub.isEmpty()) {
                npcName = npcName + "." + npcSub;
            }
            return "entity.AncientWarfareNpc." + npcName;
        }
        return super.func_77667_c(par1ItemStack);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return stack;
        }
        BlockPosition hit = BlockTools.getBlockClickedOn(player, player.field_70170_p, true);
        if (hit == null) {
            return stack;
        }
        NpcBase npc = ItemNpcSpawner.createNpcFromItem(player.field_70170_p, stack);
        if (npc != null) {
            npc.setOwner(player);
            npc.func_70107_b((double)hit.x + 0.5, hit.y, (double)hit.z + 0.5);
            npc.setHomeAreaAtCurrentPosition();
            player.field_70170_p.func_72838_d((Entity)npc);
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
        }
        return stack;
    }

    public static NpcBase createNpcFromItem(World world, ItemStack stack) {
        String type = ItemNpcSpawner.getNpcType(stack);
        if (type == null) {
            return null;
        }
        String subType = ItemNpcSpawner.getNpcSubtype(stack);
        NpcBase npc = AWNPCEntityLoader.createNpc(world, type, subType);
        if (npc == null) {
            return null;
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("npcStoredData")) {
            for (int i = 0; i < 5; ++i) {
                npc.func_70062_b(i, null);
            }
            npc.readAdditionalItemData(stack.func_77978_p().func_74775_l("npcStoredData"));
        }
        return npc;
    }

    public static ItemStack getSpawnerItemForNpc(NpcBase npc) {
        String type = npc.getNpcType();
        String sub = npc.getNpcSubType();
        ItemStack stack = ItemNpcSpawner.getStackForNpcType(type, sub);
        NBTTagCompound tag = new NBTTagCompound();
        npc.writeAdditionalItemData(tag);
        stack.func_77983_a("npcStoredData", (NBTBase)tag);
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        AWNPCEntityLoader.getSpawnerSubItems(list);
    }

    public static ItemStack getStackForNpcType(String type, String npcSubtype) {
        ItemStack stack = new ItemStack(AWItems.npcSpawner);
        stack.func_77983_a("npcType", (NBTBase)new NBTTagString(type));
        stack.func_77983_a("npcSubtype", (NBTBase)new NBTTagString(npcSubtype));
        return stack;
    }

    public static String getNpcType(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("npcType")) {
            return stack.func_77978_p().func_74779_i("npcType");
        }
        return null;
    }

    public static String getNpcSubtype(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("npcSubtype")) {
            return stack.func_77978_p().func_74779_i("npcSubtype");
        }
        return "";
    }

    public void addNpcType(String name, String icon) {
        this.iconNames.put(name, icon);
    }

    public void func_94581_a(IIconRegister par1IconRegister) {
        super.func_94581_a(par1IconRegister);
        for (String name : this.iconNames.keySet()) {
            IIcon icon = par1IconRegister.func_94245_a(this.iconNames.get(name));
            this.iconMap.put(name, icon);
        }
    }

    public IIcon func_77650_f(ItemStack stack) {
        String type = ItemNpcSpawner.getNpcType(stack);
        String sub = ItemNpcSpawner.getNpcSubtype(stack);
        if (type != null) {
            if (!sub.isEmpty()) {
                type = type + "." + sub;
            }
            if (this.iconMap.containsKey(type)) {
                return this.iconMap.get(type);
            }
        }
        return super.func_77650_f(stack);
    }
}

