/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.gui;

import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Line;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcFactionTradeView;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionTrader;
import net.shadowmage.ancientwarfare.npc.trade.FactionTrade;

public class GuiNpcFactionTradeView
extends GuiContainerBase<ContainerNpcFactionTradeView> {
    private Button inventoryButton;
    private Button setupButton;
    private CompositeScrolled area;

    public GuiNpcFactionTradeView(ContainerBase container) {
        super(container);
    }

    @Override
    public void initElements() {
        int areaYSize = this.player.field_71075_bZ.field_75098_d ? this.field_147000_g - 24 - 16 - 4 - 72 : this.field_147000_g - 16 - 4 - 72;
        this.area = new CompositeScrolled(this, 0, this.player.field_71075_bZ.field_75098_d ? 24 : 0, this.field_146999_f, areaYSize);
        this.inventoryButton = new Button(8, 8, 120, 12, "guistrings.inventory"){

            @Override
            protected void onPressed() {
                NetworkHandler.INSTANCE.openGui(GuiNpcFactionTradeView.this.player, 4, ((NpcFactionTrader)((ContainerNpcFactionTradeView)((Object)GuiNpcFactionTradeView.this.getContainer())).entity).func_145782_y(), 0, 0);
            }
        };
        this.setupButton = new Button(128, 8, 120, 12, "guistrings.trade_setup"){

            @Override
            protected void onPressed() {
                NetworkHandler.INSTANCE.openGui(GuiNpcFactionTradeView.this.player, 39, ((NpcFactionTrader)((ContainerNpcFactionTradeView)((Object)GuiNpcFactionTradeView.this.getContainer())).entity).func_145782_y(), 0, 0);
            }
        };
    }

    @Override
    public void setupElements() {
        this.clearElements();
        this.addGuiElement(this.area);
        if (this.player.field_71075_bZ.field_75098_d) {
            this.addGuiElement(this.inventoryButton);
            this.addGuiElement(this.setupButton);
        }
        this.addTrades();
    }

    private void addTrades() {
        this.area.clearElements();
        int totalHeight = 8;
        if (((ContainerNpcFactionTradeView)((Object)this.getContainer())).tradeList.isEmpty()) {
            this.area.addGuiElement(new Label(8, 8, "guistrings.trader.no_trade"));
        } else {
            for (int i = 0; i < ((ContainerNpcFactionTradeView)((Object)this.getContainer())).tradeList.size(); ++i) {
                totalHeight = this.addTrade((FactionTrade)((ContainerNpcFactionTradeView)((Object)this.getContainer())).tradeList.get(i), i, totalHeight);
            }
        }
        this.area.setAreaSize(totalHeight);
    }

    private int addTrade(final FactionTrade trade, final int tradeNum, int startHeight) {
        if (trade.getCurrentAvailable() <= 0) {
            return startHeight;
        }
        int gridX = 0;
        int gridY = 0;
        for (int i = 0; i < trade.size(); ++i) {
            int slotX = gridX * 18 + 8;
            int slotY = gridY * 18 + startHeight;
            this.addTradeInputSlot(trade, slotX, slotY, i);
            this.addTradeOutputSlot(trade, slotX += 63, slotY, i);
            if (++gridX < 3) continue;
            gridX = 0;
            ++gridY;
        }
        int startWidth = 62;
        if (trade.size() < 3) {
            startWidth += (trade.size() - 3) * 18;
        }
        this.area.addGuiElement(new Label(startWidth + 1, startHeight + (gridY + 1) * 5, ">"));
        startWidth *= 2;
        Button tradeButton = new Button(startWidth += 9, startHeight + 17, 70, 20, "guistrings.trade"){

            @Override
            protected void onPressed() {
                trade.performTrade(GuiNpcFactionTradeView.this.player, null);
                ((ContainerNpcFactionTradeView)((Object)GuiNpcFactionTradeView.this.getContainer())).doTrade(tradeNum);
                GuiNpcFactionTradeView.this.refreshGui();
            }
        };
        this.area.addGuiElement(tradeButton);
        Label available = new Label(startWidth, startHeight, StatCollector.func_74837_a((String)"guistrings.trades_available", (Object[])new Object[]{trade.getCurrentAvailable()}));
        this.area.addGuiElement(available);
        this.area.addGuiElement(new Line(0, (startHeight += 18 * gridY) + 1, this.field_146999_f, startHeight + 1, 1, 255));
        return startHeight += 5;
    }

    private void addTradeInputSlot(FactionTrade trade, int x, int y, int slotNum) {
        ItemStack stack = trade.getInputStack(slotNum);
        stack = stack == null ? null : stack.func_77946_l();
        ItemSlot slot = new ItemSlot(x, y, stack, this);
        if (stack == null) {
            slot.addTooltip("guistrings.npc.trade_input_slot");
        }
        this.area.addGuiElement(slot);
    }

    private void addTradeOutputSlot(FactionTrade trade, int x, int y, int slotNum) {
        ItemStack stack = trade.getOutputStack(slotNum);
        stack = stack == null ? null : stack.func_77946_l();
        ItemSlot slot = new ItemSlot(x, y, stack, this);
        if (stack == null) {
            slot.addTooltip("guistrings.npc.trade_output_slot");
        }
        this.area.addGuiElement(slot);
    }
}

