/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity;

import java.util.HashMap;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public class NpcLevelingStats {
    private final HashMap<String, ExperienceEntry> experienceMap = new HashMap();
    private int xp;
    private int level;
    private final NpcBase npc;

    public NpcLevelingStats(NpcBase npc) {
        this.npc = npc;
    }

    public int getExperience() {
        String type = this.npc.getNpcFullType();
        if (this.experienceMap.containsKey(type)) {
            return this.experienceMap.get((Object)type).xp;
        }
        return 0;
    }

    public int getLevel() {
        String type = this.npc.getNpcFullType();
        if (this.experienceMap.containsKey(type)) {
            return this.experienceMap.get((Object)type).level;
        }
        return 0;
    }

    public int getBaseExperience() {
        return this.xp;
    }

    public int getBaseLevel() {
        return this.level;
    }

    public void addExperience(int xpGained) {
        if (this.npc.field_70170_p.field_72995_K) {
            return;
        }
        String type = this.npc.getNpcFullType();
        if (!this.experienceMap.containsKey(type)) {
            this.experienceMap.put(type, new ExperienceEntry());
        }
        ExperienceEntry entry = this.experienceMap.get(type);
        entry.xp += xpGained;
        while (entry.level < AWNPCStatics.maxNpcLevel && entry.xp >= this.getXPToLevel(entry.level + 1)) {
            entry.xp -= this.getXPToLevel(entry.level + 1);
            ++entry.level;
            this.onSubLevelGained(entry.level);
        }
        this.xp += xpGained;
        while (this.level < AWNPCStatics.maxNpcLevel && this.xp >= this.getXPToLevel(this.level)) {
            this.xp -= this.getXPToLevel(this.level);
            this.onBaseLevelGained(this.level + 1);
        }
    }

    private void onBaseLevelGained(int newLevel) {
        this.level = newLevel;
        if (newLevel <= AWNPCStatics.maxNpcLevel) {
            if (this.npc.getMaxHealthOverride() <= 0) {
                double health = AncientWarfareNPC.statics.getMaxHealthFor(this.npc.getNpcType()) + (double)newLevel;
                this.npc.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(health);
            }
            this.npc.updateDamageFromLevel();
        }
    }

    private void onSubLevelGained(int newLevel) {
        this.npc.updateDamageFromLevel();
    }

    private int getXPToLevel(int level) {
        return (level + 3) * (level + 3);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("xp", this.xp);
        tag.func_74768_a("level", this.level);
        NBTTagList entryList = new NBTTagList();
        for (String key : this.experienceMap.keySet()) {
            NBTTagCompound xpTag = new NBTTagCompound();
            xpTag.func_74778_a("type", key);
            xpTag.func_74768_a("xp", this.experienceMap.get((Object)key).xp);
            xpTag.func_74768_a("level", this.experienceMap.get((Object)key).level);
            entryList.func_74742_a((NBTBase)xpTag);
        }
        tag.func_74782_a("entryList", (NBTBase)entryList);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.experienceMap.clear();
        this.xp = tag.func_74762_e("xp");
        this.level = tag.func_74762_e("level");
        NBTTagList entryList = tag.func_150295_c("entryList", 10);
        for (int i = 0; i < entryList.func_74745_c(); ++i) {
            NBTTagCompound xpTag = entryList.func_150305_b(i);
            ExperienceEntry entry = new ExperienceEntry();
            entry.xp = xpTag.func_74762_e("xp");
            entry.level = xpTag.func_74762_e("level");
            this.experienceMap.put(xpTag.func_74779_i("type"), entry);
        }
    }

    private class ExperienceEntry {
        int xp;
        int level;

        private ExperienceEntry() {
        }
    }
}

