/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.container;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.shadowmage.ancientwarfare.core.container.ContainerTileBase;
import net.shadowmage.ancientwarfare.npc.tile.TileTownHall;

public class ContainerTownHall
extends ContainerTileBase<TileTownHall> {
    List<TileTownHall.NpcDeathEntry> deathList = new ArrayList<TileTownHall.NpcDeathEntry>();

    public ContainerTownHall(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        for (int i = 0; i < ((TileTownHall)this.tileEntity).func_70302_i_(); ++i) {
            int xPos = i % 9 * 18 + 8;
            int yPos = i / 9 * 18 + 8 + 16;
            this.func_75146_a(new Slot((IInventory)this.tileEntity, i, xPos, yPos));
        }
        this.addPlayerSlots(86);
        if (!player.field_70170_p.field_72995_K) {
            this.deathList.addAll(((TileTownHall)this.tileEntity).getDeathList());
            ((TileTownHall)this.tileEntity).addViewer(this);
        }
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("deathList")) {
            this.deathList.clear();
            NBTTagList list = tag.func_150295_c("deathList", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.deathList.add(new TileTownHall.NpcDeathEntry(list.func_150305_b(i)));
            }
            this.refreshGui();
        } else if (tag.func_74764_b("clear")) {
            ((TileTownHall)this.tileEntity).clearDeathNotices();
        }
        if (tag.func_74764_b("range")) {
            ((TileTownHall)this.tileEntity).setRange(tag.func_74762_e("range"));
            this.refreshGui();
        }
        if (!((TileTownHall)this.tileEntity).func_145831_w().field_72995_K) {
            ((TileTownHall)this.tileEntity).func_70296_d();
        }
    }

    @Override
    public void sendInitData() {
        this.sendDeathListToClient(true);
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        super.func_75134_a(par1EntityPlayer);
        ((TileTownHall)this.tileEntity).removeViewer(this);
    }

    public void onTownHallDeathListUpdated() {
        this.deathList.clear();
        this.deathList.addAll(((TileTownHall)this.tileEntity).getDeathList());
        this.sendDeathListToClient(false);
    }

    public void setRange(int value) {
        ((TileTownHall)this.tileEntity).setRange(value);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("range", value);
        this.sendDataToServer(tag);
    }

    public void clearList() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("clear", true);
        this.sendDataToServer(tag);
    }

    private void sendDeathListToClient(boolean withRange) {
        NBTTagList list = new NBTTagList();
        for (TileTownHall.NpcDeathEntry entry : this.deathList) {
            list.func_74742_a((NBTBase)entry.writeToNBT(new NBTTagCompound()));
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("deathList", (NBTBase)list);
        if (withRange) {
            tag.func_74768_a("range", ((TileTownHall)this.tileEntity).getRange());
        }
        this.sendDataToClient(tag);
    }

    public List<TileTownHall.NpcDeathEntry> getDeathList() {
        return this.deathList;
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int slotClickedIndex) {
        ItemStack slotStackCopy = null;
        Slot theSlot = this.func_75139_a(slotClickedIndex);
        if (theSlot != null && theSlot.func_75216_d()) {
            ItemStack slotStack = theSlot.func_75211_c();
            slotStackCopy = slotStack.func_77946_l();
            if (slotClickedIndex < ((TileTownHall)this.tileEntity).func_70302_i_() ? !this.func_75135_a(slotStack, ((TileTownHall)this.tileEntity).func_70302_i_(), ((TileTownHall)this.tileEntity).func_70302_i_() + this.playerSlots, false) : !this.func_75135_a(slotStack, 0, ((TileTownHall)this.tileEntity).func_70302_i_(), false)) {
                return null;
            }
            if (slotStack.field_77994_a == 0) {
                theSlot.func_75215_d(null);
            } else {
                theSlot.func_75218_e();
            }
            if (slotStack.field_77994_a == slotStackCopy.field_77994_a) {
                return null;
            }
            theSlot.func_82870_a(par1EntityPlayer, slotStack);
        }
        return slotStackCopy;
    }
}

