/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public class NpcAIMedicBase
extends NpcAI<NpcBase> {
    private int injuredRecheckDelay = 0;
    private int injuredRecheckDelayMax = 20;
    private int healDelay = 0;
    private int healDelayMax = 20;
    private EntityLivingBase targetToHeal = null;
    private final EntityAINearestAttackableTarget.Sorter sorter;
    private IEntitySelector selector;

    public NpcAIMedicBase(NpcBase npc) {
        super(npc);
        this.sorter = new EntityAINearestAttackableTarget.Sorter((Entity)npc);
        this.selector = new IEntitySelector(){

            public boolean func_82704_a(Entity var1) {
                EntityLivingBase e;
                return var1 instanceof EntityLivingBase && (e = (EntityLivingBase)var1).func_70089_S() && e.func_110143_aJ() < e.func_110138_aP() && !NpcAIMedicBase.this.npc.isHostileTowards((Entity)e);
            }
        };
    }

    public boolean func_75250_a() {
        if (!this.npc.getIsAIEnabled()) {
            return false;
        }
        if (!this.isProperSubtype()) {
            return false;
        }
        if (this.injuredRecheckDelay-- > 0) {
            return false;
        }
        this.injuredRecheckDelay = this.injuredRecheckDelayMax;
        double dist = this.npc.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        AxisAlignedBB bb = this.npc.field_70121_D.func_72314_b(dist, dist / 2.0, dist);
        List potentialTargets = this.npc.field_70170_p.func_82733_a(EntityLivingBase.class, bb, this.selector);
        if (potentialTargets.isEmpty()) {
            return false;
        }
        Collections.sort(potentialTargets, this.sorter);
        Iterable sub = Iterables.filter((Iterable)potentialTargets, (Predicate)new Predicate<EntityLivingBase>(){

            public boolean apply(EntityLivingBase input) {
                return input instanceof NpcBase || input instanceof EntityPlayer;
            }
        });
        Iterator iterator = sub.iterator();
        while (iterator.hasNext()) {
            EntityLivingBase base;
            this.targetToHeal = base = (EntityLivingBase)iterator.next();
            if (!this.validateTarget()) continue;
            return true;
        }
        this.targetToHeal = (EntityLivingBase)potentialTargets.get(0);
        if (!this.validateTarget()) {
            this.targetToHeal = null;
            return false;
        }
        return true;
    }

    private boolean validateTarget() {
        return this.targetToHeal != null && this.targetToHeal.func_70089_S() && this.targetToHeal.func_110143_aJ() < this.targetToHeal.func_110138_aP();
    }

    public boolean func_75253_b() {
        return this.npc.getIsAIEnabled() && this.isProperSubtype() && this.validateTarget();
    }

    protected boolean isProperSubtype() {
        return "medic".equals(this.npc.getNpcSubType());
    }

    public void func_75249_e() {
        this.npc.addAITask(64);
    }

    public void func_75246_d() {
        double attackDistance;
        double dist = this.npc.func_70068_e((Entity)this.targetToHeal);
        if (dist > (attackDistance = (double)(this.npc.field_70130_N * this.npc.field_70130_N * 2.0f * 2.0f + this.targetToHeal.field_70130_N * this.targetToHeal.field_70130_N * 2.0f * 2.0f))) {
            this.npc.addAITask(512);
            this.moveToEntity((Entity)this.targetToHeal, dist);
            this.healDelay = this.healDelayMax;
        } else {
            this.npc.removeAITask(512);
            --this.healDelay;
            if (this.healDelay < 0) {
                this.healDelay = this.healDelayMax;
                float amountToHeal = (float)this.npc.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() / 2.0f;
                this.npc.func_71038_i();
                this.targetToHeal.func_70691_i(amountToHeal);
            }
        }
    }

    public void func_75251_c() {
        this.npc.removeAITask(576);
        this.targetToHeal = null;
    }
}

