/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public abstract class NpcAI<T extends NpcBase>
extends EntityAIBase {
    public static final int NUMBER_OF_TASKS = 10;
    public static final int TASK_ATTACK = 1;
    public static final int TASK_UPKEEP = 2;
    public static final int TASK_IDLE_HUNGRY = 4;
    public static final int TASK_GO_HOME = 8;
    public static final int TASK_WORK = 16;
    public static final int TASK_PATROL = 32;
    public static final int TASK_GUARD = 64;
    public static final int TASK_FOLLOW = 128;
    public static final int TASK_WANDER = 256;
    public static final int TASK_MOVE = 512;
    public static final int MOVE = 1;
    public static final int ATTACK = 2;
    public static final int SWIM = 4;
    public static final int HUNGRY = 8;
    public static final int MIN_RANGE = 9;
    public static final int ACTION_RANGE = 25;
    protected int moveRetryDelay;
    protected double moveSpeed = 1.0;
    private double maxPFDist;
    private double maxPFDistSq;
    protected T npc;

    public NpcAI(T npc) {
        this.npc = npc;
        this.maxPFDist = npc.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111125_b() * 0.9;
        this.maxPFDistSq = this.maxPFDist * this.maxPFDist;
    }

    protected final void moveToEntity(Entity target, double sqDist) {
        this.moveToPosition(target.field_70165_t, target.field_70121_D.field_72338_b, target.field_70161_v, sqDist);
    }

    protected final void moveToPosition(int x, int y, int z, double sqDist) {
        this.moveToPosition((double)x + 0.5, (double)y, (double)z + 0.5, sqDist);
    }

    protected final void moveToPosition(BlockPosition pos, double sqDist) {
        this.moveToPosition(pos.x, pos.y, pos.z, sqDist);
    }

    protected final void moveToPosition(double x, double y, double z, double sqDist) {
        --this.moveRetryDelay;
        if (this.moveRetryDelay <= 0) {
            if (sqDist > this.maxPFDistSq) {
                this.moveLongDistance(x, y, z);
                this.moveRetryDelay = 60;
            } else {
                this.setPath(x, y, z);
                this.moveRetryDelay = 10;
                if (sqDist > 256.0) {
                    this.moveRetryDelay += 10;
                }
                if (sqDist > 1024.0) {
                    this.moveRetryDelay += 20;
                }
            }
        }
    }

    protected final void moveLongDistance(double x, double y, double z) {
        Vec3 vec = Vec3.func_72443_a((double)(x - ((NpcBase)this.npc).field_70165_t), (double)(y - ((NpcBase)this.npc).field_70163_u), (double)(z - ((NpcBase)this.npc).field_70161_v));
        double w = Math.sqrt(vec.field_72450_a * vec.field_72450_a + vec.field_72448_b * vec.field_72448_b + vec.field_72449_c * vec.field_72449_c);
        if (w != 0.0) {
            vec.field_72450_a /= w;
            vec.field_72448_b /= w;
            vec.field_72449_c /= w;
        }
        vec.field_72450_a *= this.maxPFDist;
        vec.field_72448_b *= this.maxPFDist;
        vec.field_72449_c *= this.maxPFDist;
        vec.field_72450_a += ((NpcBase)this.npc).field_70165_t;
        vec.field_72448_b += ((NpcBase)this.npc).field_70163_u;
        vec.field_72449_c += ((NpcBase)this.npc).field_70161_v;
        this.setPath(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    protected final void returnHome() {
        ChunkCoordinates cc = this.npc.func_110172_bL();
        this.setPath(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c);
    }

    protected final void setPath(double x, double y, double z) {
        PathEntity pathEntity = this.trimPath(this.npc.func_70661_as().func_75488_a(x, y, z));
        this.npc.func_70661_as().func_75484_a(pathEntity, this.moveSpeed);
    }

    protected PathEntity trimPath(PathEntity pathEntity) {
        if (pathEntity != null) {
            int index = pathEntity.func_75873_e();
            PathPoint pathpoint = pathEntity.func_75877_a(index);
            if (((NpcBase)this.npc).func_70783_a(pathpoint.field_75839_a, pathpoint.field_75837_b, pathpoint.field_75838_c) >= 0.0f) {
                for (int i = index + 1; i < pathEntity.func_75874_d(); ++i) {
                    pathpoint = pathEntity.func_75877_a(i);
                    if (!(((NpcBase)this.npc).func_70783_a(pathpoint.field_75839_a, pathpoint.field_75837_b, pathpoint.field_75838_c) < 0.0f)) continue;
                    pathEntity.func_75871_b(i - 1);
                    break;
                }
            } else {
                Vec3 vec = RandomPositionGenerator.func_75461_b(this.npc, (int)9, (int)9, (Vec3)Vec3.func_72443_a((double)((NpcBase)this.npc).field_70165_t, (double)((NpcBase)this.npc).field_70163_u, (double)((NpcBase)this.npc).field_70161_v));
                if (vec != null) {
                    return this.npc.func_70661_as().func_75488_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                }
            }
        }
        return pathEntity;
    }
}

