/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.core.util.Json;
import net.shadowmage.ancientwarfare.core.util.JsonTagReader;

public class JsonTagWriter {
    public static Json.JsonObject getJsonForTag(NBTTagCompound tag) {
        Json.JsonObject base = new Json.JsonObject();
        base.writeValue("id", new Json.JsonValue(Json.getTagType((NBTBase)tag)));
        base.writeAbstract("val", JsonTagWriter.getJsonValueForCompoundTag(tag));
        return base;
    }

    private static Json.JsonArray getJsonValueForListTag(NBTTagList tag) {
        Json.JsonArray base = new Json.JsonArray();
        tag = (NBTTagList)tag.func_74737_b();
        while (tag.func_74745_c() > 0) {
            Json.JsonAbstract valueJson = JsonTagWriter.getJsonFor(tag.func_74744_a(0));
            if (valueJson == null) continue;
            base.add(valueJson);
        }
        return base;
    }

    private static Json.JsonObject getJsonValueForCompoundTag(NBTTagCompound tag) {
        Json.JsonObject base = new Json.JsonObject();
        for (String key : tag.func_150296_c()) {
            Json.JsonAbstract valueJson = JsonTagWriter.getJsonFor(tag.func_74781_a(key));
            if (valueJson == null) continue;
            base.writeAbstract(key, valueJson);
        }
        return base;
    }

    private static Json.JsonArray getJsonValueForByteArray(NBTTagByteArray tag) {
        byte[] bytes;
        Json.JsonArray array = new Json.JsonArray();
        for (byte b : bytes = tag.func_150292_c()) {
            array.add(new Json.JsonValue(String.valueOf(b)));
        }
        return array;
    }

    private static Json.JsonArray getJsonValueForIntArray(NBTTagIntArray tag) {
        int[] ints;
        Json.JsonArray array = new Json.JsonArray();
        for (int b : ints = tag.func_150302_c()) {
            array.add(new Json.JsonValue(String.valueOf(b)));
        }
        return array;
    }

    private static Json.JsonAbstract getJsonFor(NBTBase tag) {
        String typeId = Json.getTagType(tag);
        byte id = tag.func_74732_a();
        if (typeId == null) {
            return null;
        }
        Json.JsonObject object = new Json.JsonObject();
        Json.JsonAbstract value = null;
        object.writeValue("id", new Json.JsonValue(typeId));
        switch (id) {
            case 1: {
                value = new Json.JsonValue(String.valueOf(((NBTTagByte)tag).func_150290_f()));
                break;
            }
            case 2: {
                value = new Json.JsonValue(String.valueOf(((NBTTagShort)tag).func_150289_e()));
                break;
            }
            case 3: {
                value = new Json.JsonValue(String.valueOf(((NBTTagInt)tag).func_150287_d()));
                break;
            }
            case 4: {
                value = new Json.JsonValue(String.valueOf(((NBTTagLong)tag).func_150291_c()));
                break;
            }
            case 5: {
                value = new Json.JsonValue(String.valueOf(((NBTTagFloat)tag).func_150288_h()));
                break;
            }
            case 6: {
                value = new Json.JsonValue(String.valueOf(((NBTTagDouble)tag).func_150286_g()));
                break;
            }
            case 7: {
                value = JsonTagWriter.getJsonValueForByteArray((NBTTagByteArray)tag);
                break;
            }
            case 8: {
                value = new Json.JsonValue(((NBTTagString)tag).func_150285_a_());
                break;
            }
            case 9: {
                value = JsonTagWriter.getJsonValueForListTag((NBTTagList)tag);
                break;
            }
            case 10: {
                value = JsonTagWriter.getJsonValueForCompoundTag((NBTTagCompound)tag);
                break;
            }
            case 11: {
                value = JsonTagWriter.getJsonValueForIntArray((NBTTagIntArray)tag);
            }
        }
        if (value == null) {
            return null;
        }
        object.writeAbstract("val", value);
        return object;
    }

    public static void JsonTest() {
        AWLog.logDebug("testing json read/write!!");
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("fooInt", 1);
        tag.func_74778_a("fooString", "stringData");
        tag.func_74777_a("fooShort", (short)1);
        tag.func_74773_a("fooByteArray", new byte[]{0, 1, 0, 1});
        tag.func_74783_a("fooIntArray", new int[]{0, 1, 0, 1, 0, 1});
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagString("listString1"));
        list.func_74742_a((NBTBase)new NBTTagString("listString2"));
        list.func_74742_a((NBTBase)new NBTTagString("listString3"));
        list.func_74742_a((NBTBase)new NBTTagString("listString4"));
        tag.func_74782_a("list", (NBTBase)list);
        Json.JsonObject o = JsonTagWriter.getJsonForTag(tag);
        String os = Json.getJsonData(o);
        AWLog.logDebug("pre out : " + os);
        o = Json.parseJson(os);
        os = Json.getJsonData(o);
        AWLog.logDebug("post out: " + os);
        AWLog.logDebug("pre tag : " + tag);
        tag = JsonTagReader.getTagFrom(o);
        AWLog.logDebug("post tag: " + tag);
        Integer.parseInt("foo");
    }
}

