/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.NBTBase;

public class Json {
    public static String getTagType(NBTBase tag) {
        byte id = tag.func_74732_a();
        switch (id) {
            case 1: {
                return "pb";
            }
            case 2: {
                return "ps";
            }
            case 3: {
                return "pi";
            }
            case 4: {
                return "pl";
            }
            case 5: {
                return "pf";
            }
            case 6: {
                return "pd";
            }
            case 7: {
                return "ab";
            }
            case 8: {
                return "ss";
            }
            case 9: {
                return "ls";
            }
            case 10: {
                return "ct";
            }
            case 11: {
                return "ai";
            }
        }
        return null;
    }

    public static String getJsonData(JsonObject json) {
        return "JSON:{" + json.getJsonString() + "}";
    }

    public static JsonObject parseJson(String data) {
        if (data.startsWith("JSON:{") && data.endsWith("}")) {
            JsonParser parser = new JsonParser(data.substring(6, data.length() - 1));
            try {
                return parser.process();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static JsonObject parseJson(Reader reader) {
        JsonParser parser = new JsonParser(reader);
        try {
            return parser.process();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final class JsonValue
    extends JsonAbstract {
        String value;

        public JsonValue(String value) {
            this.value = value;
        }

        public String getStringValue() {
            return this.value;
        }

        public boolean getBooleanValue() {
            return Boolean.parseBoolean(this.value);
        }

        public long getIntegerValue() {
            try {
                return Long.parseLong(this.value);
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }

        public double getFloatValue() {
            try {
                return Double.parseDouble(this.value);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }

        public String toString() {
            return this.value;
        }

        @Override
        protected String getJsonString() {
            String val = this.value.replace("\"", "\\\"");
            return "\"" + val + "\"";
        }
    }

    public static final class JsonArray
    extends JsonAbstract {
        private List<JsonAbstract> values = new ArrayList<JsonAbstract>();

        public void add(JsonAbstract value) {
            this.values.add(value);
        }

        public int size() {
            return this.values.size();
        }

        public JsonAbstract getAbstract(int index) {
            return this.values.get(index);
        }

        public JsonArray getArray(int index) {
            JsonAbstract a = this.values.get(index);
            return a instanceof JsonArray ? (JsonArray)a : null;
        }

        public JsonValue getValue(int index) {
            JsonAbstract a = this.values.get(index);
            return a instanceof JsonValue ? (JsonValue)a : null;
        }

        public JsonObject getObject(int index) {
            JsonAbstract a = this.values.get(index);
            return a instanceof JsonObject ? (JsonObject)a : null;
        }

        @Override
        protected String getJsonString() {
            JsonAbstract value;
            String data = "[";
            Iterator<JsonAbstract> it = this.values.iterator();
            while (it.hasNext() && (value = it.next()) != null) {
                data = data + value.getJsonString();
                if (!it.hasNext()) continue;
                data = data + ",";
            }
            data = data + "]";
            return data;
        }
    }

    public static final class JsonObject
    extends JsonAbstract {
        private HashMap<String, JsonAbstract> fields = new HashMap();

        public JsonArray getArray(String name) {
            JsonAbstract a = this.fields.get(name);
            return a instanceof JsonArray ? (JsonArray)a : null;
        }

        public JsonValue getValue(String name) {
            JsonAbstract a = this.fields.get(name);
            return a instanceof JsonValue ? (JsonValue)a : null;
        }

        public JsonObject getObject(String name) {
            JsonAbstract a = this.fields.get(name);
            return a instanceof JsonObject ? (JsonObject)a : null;
        }

        public JsonAbstract getAbstract(String name) {
            return this.fields.get(name);
        }

        public Set<String> keySet() {
            return this.fields.keySet();
        }

        public void writeObject(String name, JsonObject object) {
            this.fields.put(name, object);
        }

        public void writeArray(String name, JsonArray array) {
            this.fields.put(name, array);
        }

        public void writeValue(String name, JsonValue value) {
            this.fields.put(name, value);
        }

        public void writeAbstract(String name, JsonAbstract value) {
            this.fields.put(name, value);
        }

        @Override
        protected String getJsonString() {
            String key;
            String data = "{";
            Iterator<String> it = this.fields.keySet().iterator();
            while (it.hasNext() && (key = it.next()) != null) {
                data = data + "\"" + key + "\":" + this.fields.get(key).getJsonString();
                if (!it.hasNext()) continue;
                data = data + ",";
            }
            data = data + "}";
            return data;
        }
    }

    public static abstract class JsonAbstract {
        protected abstract String getJsonString();
    }

    private static class JsonParser {
        Reader reader;
        int rawChar;
        int charIndex = -1;
        boolean readEnd = false;
        boolean atEnd = false;
        int bufferStart = 0;
        int bufferEnd = 0;
        char[] readBuffer = new char[1024];
        char currentChar;

        protected JsonParser(String data) {
            this.reader = new StringReader(data);
        }

        protected JsonParser(Reader reader) {
            this.reader = reader;
        }

        protected JsonObject process() throws IOException {
            this.readRawChar();
            return this.readObject();
        }

        private void readRawChar() throws IOException {
            int index;
            if (this.atEnd) {
                return;
            }
            ++this.charIndex;
            if (this.charIndex >= this.bufferEnd) {
                if (this.readEnd) {
                    this.atEnd = true;
                    return;
                }
                this.bufferStart = this.charIndex;
                this.bufferEnd = this.bufferStart + this.readBuffer.length;
                int read = this.reader.read(this.readBuffer);
                if (this.bufferStart + read < this.bufferEnd) {
                    this.bufferEnd = this.bufferStart + read;
                    this.readEnd = true;
                }
            }
            if ((index = this.charIndex - this.bufferStart) >= this.bufferEnd) {
                this.charIndex = -1;
                this.rawChar = -1;
                this.currentChar = (char)32;
                return;
            }
            this.rawChar = this.readBuffer[index];
            this.currentChar = this.readBuffer[index];
        }

        private void skipBlanks() throws IOException {
            while (this.rawChar == 32 || this.rawChar == 13 || this.rawChar == 10) {
                this.readRawChar();
            }
        }

        protected JsonAbstract readAbstract() throws IOException {
            if (this.rawChar == 123) {
                return this.readObject();
            }
            if (this.rawChar == 91) {
                return this.readArray();
            }
            return this.readValue();
        }

        protected JsonObject readObject() throws IOException {
            if (this.rawChar != 123) {
                throw this.throwUnexpectedException("expected object start {");
            }
            JsonObject object = new JsonObject();
            this.readRawChar();
            this.skipBlanks();
            if (this.rawChar == 125) {
                this.readRawChar();
                this.skipBlanks();
                return object;
            }
            while (this.rawChar != 125) {
                this.skipBlanks();
                String name = this.readName();
                this.skipBlanks();
                if (this.rawChar != 58) {
                    throw this.throwUnexpectedException("Did not find name separator : while parsing object");
                }
                this.readRawChar();
                this.skipBlanks();
                JsonAbstract value = this.readAbstract();
                object.writeAbstract(name, value);
                this.skipBlanks();
                if (this.rawChar != 44) continue;
                this.readRawChar();
                this.skipBlanks();
            }
            this.readRawChar();
            this.skipBlanks();
            return object;
        }

        protected JsonArray readArray() throws IOException {
            if (this.rawChar != 91) {
                throw this.throwUnexpectedException("expected array start [");
            }
            JsonArray array = new JsonArray();
            this.readRawChar();
            this.skipBlanks();
            if (this.rawChar == 93) {
                this.readRawChar();
                this.skipBlanks();
                return array;
            }
            while (this.rawChar != 93) {
                this.skipBlanks();
                JsonAbstract value = this.readAbstract();
                array.add(value);
                this.skipBlanks();
                if (this.rawChar != 44) continue;
                this.readRawChar();
                this.skipBlanks();
            }
            this.readRawChar();
            this.skipBlanks();
            return array;
        }

        protected JsonValue readValue() throws IOException {
            return new JsonValue(this.readString());
        }

        private String readName() throws IOException {
            if (this.rawChar != 34) {
                throw this.throwUnexpectedException("Did not find name start while parsing object");
            }
            return this.readString();
        }

        private String readString() throws IOException {
            if (this.rawChar != 34) {
                throw this.throwUnexpectedException("Did not find string entry while parsing value");
            }
            StringBuilder builder = new StringBuilder();
            this.readRawChar();
            char prevChar = '.';
            while (this.rawChar != 34) {
                prevChar = this.currentChar;
                this.readRawChar();
                if (prevChar == '\\' && this.rawChar == 34) {
                    prevChar = this.currentChar;
                    this.readRawChar();
                }
                builder.append(prevChar);
            }
            this.readRawChar();
            return builder.toString();
        }

        private JsonParsingException throwUnexpectedException(String message) {
            return new JsonParsingException(message + "\n" + "At char index: " + this.charIndex + " char: " + this.currentChar);
        }

        public static class JsonParsingException
        extends RuntimeException {
            public JsonParsingException(String message) {
                super(message);
            }
        }
    }
}

