/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.model;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import net.shadowmage.ancientwarfare.core.model.ModelPiece;
import org.lwjgl.opengl.GL11;

public abstract class Primitive {
    private float tx;
    private float ty;
    float x;
    float y;
    float z;
    float rx;
    float ry;
    float rz;
    public ModelPiece parent;

    public Primitive(ModelPiece parent) {
        this.parent = parent;
    }

    public final void render(float tw, float th) {
        this.buildDisplayList(tw, th);
    }

    protected void buildDisplayList(float tw, float th) {
        GL11.glPushMatrix();
        if (this.x != 0.0f || this.y != 0.0f || this.z != 0.0f) {
            GL11.glTranslatef((float)this.x, (float)this.y, (float)this.z);
        }
        if (this.rx != 0.0f) {
            GL11.glRotatef((float)this.rx, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (this.ry != 0.0f) {
            GL11.glRotatef((float)this.ry, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.rz != 0.0f) {
            GL11.glRotatef((float)this.rz, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        this.renderPrimitive(tw, th);
        GL11.glPopMatrix();
    }

    protected abstract void renderPrimitive(float var1, float var2);

    public abstract Primitive copy();

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public float rx() {
        return this.rx;
    }

    public float ry() {
        return this.ry;
    }

    public float rz() {
        return this.rz;
    }

    public float tx() {
        return this.tx;
    }

    public float ty() {
        return this.ty;
    }

    public void setOrigin(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setRotation(float rx, float ry, float rz) {
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
    }

    public void setTx(float tx) {
        if (tx < 0.0f) {
            tx = 0.0f;
        }
        this.tx = tx;
    }

    public void setTy(float ty) {
        if (ty < 0.0f) {
            ty = 0.0f;
        }
        this.ty = ty;
    }

    public abstract void addPrimitiveLines(ArrayList<String> var1);

    public abstract void readFromLine(String[] var1);

    public abstract void addUVMapToImage(BufferedImage var1);

    protected void setImagePixel(BufferedImage image, int x, int y, int rgb) {
        if (x >= 0 && x < image.getWidth() && y >= 0 && y < image.getHeight()) {
            image.setRGB(x, y, rgb);
        }
    }
}

