/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.input;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Property;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.core.config.AWCoreStatics;
import net.shadowmage.ancientwarfare.core.interfaces.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.network.PacketItemInteraction;
import org.lwjgl.input.Keyboard;

public class InputHandler {
    public static final String KEY_ALT_ITEM_USE_0 = "keybind.alt_item_use_1";
    public static final String KEY_ALT_ITEM_USE_1 = "keybind.alt_item_use_2";
    public static final String KEY_ALT_ITEM_USE_2 = "keybind.alt_item_use_3";
    public static final String KEY_ALT_ITEM_USE_3 = "keybind.alt_item_use_4";
    public static final String KEY_ALT_ITEM_USE_4 = "keybind.alt_item_use_5";
    public static final InputHandler instance = new InputHandler();
    private final HashMap<String, Keybind> keybindMap = new HashMap();
    private final HashMap<Integer, Set<Keybind>> bindsByKey = new HashMap();
    private long lastMouseInput = -1L;

    private InputHandler() {
    }

    public void loadConfig() {
        this.registerKeybind(KEY_ALT_ITEM_USE_0, 44, new ItemInputCallback(IItemKeyInterface.ItemKey.KEY_0));
        this.registerKeybind(KEY_ALT_ITEM_USE_1, 45, new ItemInputCallback(IItemKeyInterface.ItemKey.KEY_1));
        this.registerKeybind(KEY_ALT_ITEM_USE_2, 46, new ItemInputCallback(IItemKeyInterface.ItemKey.KEY_2));
        this.registerKeybind(KEY_ALT_ITEM_USE_3, 47, new ItemInputCallback(IItemKeyInterface.ItemKey.KEY_3));
        this.registerKeybind(KEY_ALT_ITEM_USE_4, 48, new ItemInputCallback(IItemKeyInterface.ItemKey.KEY_4));
    }

    public void updateFromConfig() {
        this.updateKeybind(KEY_ALT_ITEM_USE_0);
        this.updateKeybind(KEY_ALT_ITEM_USE_1);
        this.updateKeybind(KEY_ALT_ITEM_USE_2);
        this.updateKeybind(KEY_ALT_ITEM_USE_3);
        this.updateKeybind(KEY_ALT_ITEM_USE_4);
    }

    private void updateKeybind(String name) {
        Keybind k = this.getKeybind(name);
        if (k != null) {
            this.reassignKeyCode(k, this.getKeybindProp(name, k.key).getInt());
        }
    }

    public List<Property> getKeyConfig(String select) {
        ArrayList<Property> list = new ArrayList<Property>();
        for (Keybind entry : this.keybindMap.values()) {
            if (!entry.getName().contains(select)) continue;
            list.add(this.getKeybindProp(entry.getName(), entry.getKeyCode()));
        }
        return list;
    }

    public Property getKeybindProp(String name) {
        Keybind k = this.getKeybind(name);
        if (k != null) {
            return this.getKeybindProp(name, k.key);
        }
        return null;
    }

    private Property getKeybindProp(String keyName, int defaultVal) {
        return AncientWarfareCore.statics.getKeyBindID(keyName, defaultVal);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent evt) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft == null) {
            return;
        }
        EntityClientPlayerMP player = minecraft.field_71439_g;
        if (player == null) {
            return;
        }
        int key = Keyboard.getEventKey();
        boolean state = Keyboard.getEventKeyState();
        if (this.bindsByKey.containsKey(key)) {
            Set<Keybind> keys = this.bindsByKey.get(key);
            for (Keybind k : keys) {
                if (state) {
                    k.onKeyPressed();
                    continue;
                }
                k.onKeyReleased();
            }
        }
    }

    public Keybind getKeybind(String name) {
        return this.keybindMap.get(name);
    }

    public String getKeybindBinding(String name) {
        return Keyboard.getKeyName((int)this.getKeybind(name).getKeyCode());
    }

    public void registerKeybind(String name, int keyCode, InputCallback cb) {
        Keybind k;
        int key;
        if (!this.keybindMap.containsKey(name)) {
            Property property = this.getKeybindProp(name, keyCode);
            property.comment = "Default key: " + Keyboard.getKeyName((int)keyCode);
            key = property.getInt();
            k = new Keybind(name, key);
            this.keybindMap.put(name, k);
            if (!this.bindsByKey.containsKey(key)) {
                this.bindsByKey.put(key, new HashSet());
            }
        } else {
            throw new RuntimeException("Attempt to register duplicate keybind: " + name);
        }
        this.bindsByKey.get(key).add(k);
        if (cb != null) {
            this.keybindMap.get((Object)name).inputHandlers.add(cb);
        }
    }

    public void reassignKeybind(String name, int newKey) {
        Keybind k = this.keybindMap.get(name);
        if (k == null) {
            return;
        }
        this.getKeybindProp(name, k.key).set(newKey);
        this.reassignKeyCode(k, newKey);
        AWCoreStatics.update();
    }

    private void reassignKeyCode(Keybind k, int newKey) {
        this.bindsByKey.get(k.key).remove(k);
        k.key = newKey;
        if (!this.bindsByKey.containsKey(newKey)) {
            this.bindsByKey.put(newKey, new HashSet());
        }
        this.bindsByKey.get(newKey).add(k);
    }

    public void addInputCallback(String name, InputCallback cb) {
        this.keybindMap.get((Object)name).inputHandlers.add(cb);
    }

    public Collection<Keybind> getKeybinds() {
        return this.keybindMap.values();
    }

    private static final class ItemInputCallback
    implements InputCallback {
        private final IItemKeyInterface.ItemKey key;

        public ItemInputCallback(IItemKeyInterface.ItemKey key) {
            this.key = key;
        }

        @Override
        public void onKeyPressed() {
            Minecraft minecraft = Minecraft.func_71410_x();
            if (minecraft.field_71462_r != null) {
                return;
            }
            ItemStack stack = minecraft.field_71439_g.func_70694_bm();
            if (stack != null && stack.func_77973_b() instanceof IItemKeyInterface && ((IItemKeyInterface)stack.func_77973_b()).onKeyActionClient((EntityPlayer)minecraft.field_71439_g, stack, this.key)) {
                PacketItemInteraction pkt = new PacketItemInteraction(0, this.key);
                NetworkHandler.sendToServer(pkt);
            }
        }

        @Override
        public void onKeyReleased() {
        }
    }

    public static interface InputCallback {
        public void onKeyPressed();

        public void onKeyReleased();
    }

    public static final class Keybind {
        List<InputCallback> inputHandlers = new ArrayList<InputCallback>();
        private int key;
        private final String name;
        private boolean isPressed;

        private Keybind(String name, int key) {
            this.name = name;
            this.key = key;
        }

        public String getName() {
            return this.name;
        }

        public int getKeyCode() {
            return this.key;
        }

        private void onKeyPressed() {
            this.isPressed = true;
            for (InputCallback c : this.inputHandlers) {
                c.onKeyPressed();
            }
        }

        public void onKeyReleased() {
            for (InputCallback c : this.inputHandlers) {
                c.onKeyReleased();
            }
        }

        public String toString() {
            return "Keybind [" + this.key + "," + this.name + "]";
        }

        public boolean isPressed() {
            return this.isPressed;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Keybind && this.getName().equals(((Keybind)o).getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }
    }
}

