/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.model.ModelBaseAW;
import net.shadowmage.ancientwarfare.core.model.ModelLoader;
import net.shadowmage.ancientwarfare.core.model.ModelPiece;
import net.shadowmage.ancientwarfare.core.model.Primitive;
import net.shadowmage.ancientwarfare.core.util.AWTextureManager;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class ModelWidget
extends GuiElement {
    ModelLoader loader = new ModelLoader();
    private ModelBaseAW model;
    private ModelPiece selectedPiece = null;
    private Primitive selectedPrimitive = null;
    private int downX;
    private int downY;
    boolean dragging = false;
    boolean dragLeft = true;
    private int lastX;
    private int lastY;
    private boolean selectable = false;
    private boolean doSelection = false;
    private int selectionX;
    private int selectionY;
    int gridDisplayList = -1;
    float yaw;
    float pitch;
    float viewDistance = 5.0f;
    float viewPosX;
    float viewPosY;
    float viewPosZ;
    float viewTargetX;
    float viewTargetY;
    float viewTargetZ;
    ResourceLocation texture;
    List<ModelPiece> parents = new ArrayList<ModelPiece>();

    public ModelWidget(int topLeftX, int topLeftY, int width, int height) {
        super(topLeftX, topLeftY, width, height);
        this.addNewListener(new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (ModelWidget.this.isMouseOverElement(evt.mx, evt.my)) {
                    if (ModelWidget.this.selectable && ModelWidget.this.downX == evt.mx && ModelWidget.this.downY == evt.my) {
                        ModelWidget.this.doSelection = true;
                        ModelWidget.this.selectionX = Mouse.getX();
                        ModelWidget.this.selectionY = Mouse.getY();
                    }
                    ModelWidget.this.dragging = false;
                }
                return true;
            }
        });
        this.addNewListener(new Listener(8){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (ModelWidget.this.isMouseOverElement(evt.mx, evt.my)) {
                    ModelWidget.this.dragging = true;
                    ModelWidget.this.downX = evt.mx;
                    ModelWidget.this.downY = evt.my;
                    ModelWidget.this.lastX = evt.mx;
                    ModelWidget.this.lastY = evt.my;
                    ModelWidget.this.dragLeft = evt.mButton == 0;
                }
                return true;
            }
        });
        this.addNewListener(new Listener(32){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (ModelWidget.this.dragging && ModelWidget.this.isMouseOverElement(evt.mx, evt.my)) {
                    ModelWidget.this.handleMouseDragged(evt.mx, evt.my);
                } else {
                    ModelWidget.this.dragging = false;
                    ModelWidget.this.lastX = evt.mx;
                    ModelWidget.this.lastY = evt.my;
                }
                return true;
            }
        });
        this.addNewListener(new Listener(16){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (ModelWidget.this.isMouseOverElement(evt.mx, evt.my)) {
                    ModelWidget.this.handleMouseWheel(evt.mw);
                }
                return true;
            }
        });
        this.viewPosZ = 5.0f;
        this.viewPosY = 5.0f;
    }

    public void setTexture(ResourceLocation loc) {
        this.texture = loc;
    }

    private void handleMouseDragged(int mx, int my) {
        int dx = mx - this.lastX;
        int dy = my - this.lastY;
        if (this.dragLeft) {
            float xChange = (float)dy * MathHelper.func_76126_a((float)this.pitch) * MathHelper.func_76126_a((float)this.yaw);
            float zChange = (float)dy * MathHelper.func_76126_a((float)this.pitch) * MathHelper.func_76134_b((float)this.yaw);
            float yChange = (float)dy * MathHelper.func_76134_b((float)this.pitch);
            this.viewPosX -= (xChange += MathHelper.func_76134_b((float)this.yaw) * (float)dx) * 0.1f;
            this.viewPosY += yChange * 0.1f;
            this.viewPosZ -= (zChange -= MathHelper.func_76126_a((float)this.yaw) * (float)dx) * 0.1f;
            this.viewTargetX -= xChange * 0.1f;
            this.viewTargetY += yChange * 0.1f;
            this.viewTargetZ -= zChange * 0.1f;
        } else {
            this.yaw -= (float)dx * ((float)Math.PI / 180);
            this.pitch += (float)dy * ((float)Math.PI / 180);
            if (this.pitch * 57.295776f >= 89.0f) {
                this.pitch = 1.553343f;
            }
            if (this.pitch * 57.295776f <= -89.0f) {
                this.pitch = -1.553343f;
            }
            this.viewPosX = this.viewTargetX + this.viewDistance * MathHelper.func_76126_a((float)this.yaw) * MathHelper.func_76134_b((float)this.pitch);
            this.viewPosZ = this.viewTargetZ + this.viewDistance * MathHelper.func_76134_b((float)this.yaw) * MathHelper.func_76134_b((float)this.pitch);
            this.viewPosY = this.viewTargetY + this.viewDistance * MathHelper.func_76126_a((float)this.pitch);
        }
        this.lastX = mx;
        this.lastY = my;
    }

    private void handleMouseWheel(int wheel) {
        this.viewDistance = wheel < 0 ? (this.viewDistance += 0.25f) : (this.viewDistance -= 0.25f);
        this.viewPosX = this.viewTargetX + this.viewDistance * MathHelper.func_76126_a((float)this.yaw) * MathHelper.func_76134_b((float)this.pitch);
        this.viewPosZ = this.viewTargetZ + this.viewDistance * MathHelper.func_76134_b((float)this.yaw) * MathHelper.func_76134_b((float)this.pitch);
        this.viewPosY = this.viewTargetY + this.viewDistance * MathHelper.func_76126_a((float)this.pitch);
    }

    public void setSelectable(boolean val) {
        this.selectable = val;
    }

    public void setModel(ModelBaseAW model) {
        this.model = model;
        this.selectedPiece = null;
        this.selectedPrimitive = null;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        GL11.glEnable((int)2929);
        this.setViewport();
        if (this.model != null) {
            if (this.doSelection) {
                GL11.glClearColor((float)0.2f, (float)0.2f, (float)0.2f, (float)0.2f);
                GL11.glClear((int)16640);
                this.doSelection();
                this.doSelection = false;
            }
            GL11.glClearColor((float)0.2f, (float)0.2f, (float)0.2f, (float)0.2f);
            GL11.glClear((int)16640);
            this.renderGrid();
            this.enableModelLighting();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
            this.calculateHighlightedPieces();
            this.model.renderForEditor(this.selectedPiece, this.selectedPrimitive, this.parents);
            this.parents.clear();
        }
        this.resetViewport();
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
    }

    private void calculateHighlightedPieces() {
        this.parents.clear();
        if (this.selectedPiece != null) {
            this.selectedPiece.getPieces(this.parents);
        }
    }

    private void enableModelLighting() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        int bright = player.field_70170_p.func_72802_i((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, 0);
        int var11 = bright % 65536;
        int var12 = bright / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)var11 / 1.0f), (float)((float)var12 / 1.0f));
        RenderHelper.func_74519_b();
    }

    private void renderGrid() {
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glLineWidth((float)2.0f);
        if (this.gridDisplayList >= 0) {
            GL11.glCallList((int)this.gridDisplayList);
        } else {
            this.gridDisplayList = GL11.glGenLists((int)1);
            GL11.glNewList((int)this.gridDisplayList, (int)4865);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            for (int x = -5; x <= 5; ++x) {
                GL11.glBegin((int)2);
                GL11.glVertex3f((float)x, (float)0.0f, (float)-5.0f);
                GL11.glVertex3f((float)x, (float)0.0f, (float)5.0f);
                GL11.glEnd();
            }
            for (int z = -5; z <= 5; ++z) {
                GL11.glBegin((int)2);
                GL11.glVertex3f((float)-5.0f, (float)0.0f, (float)z);
                GL11.glVertex3f((float)5.0f, (float)0.0f, (float)z);
                GL11.glEnd();
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEndList();
        }
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
    }

    private void setViewport() {
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        Minecraft mc = Minecraft.func_71410_x();
        float aspect = (float)mc.field_71443_c / (float)mc.field_71440_d;
        GLU.gluPerspective((float)60.0f, (float)aspect, (float)0.1f, (float)100.0f);
        GLU.gluLookAt((float)this.viewPosX, (float)this.viewPosY, (float)this.viewPosZ, (float)this.viewTargetX, (float)this.viewTargetY, (float)this.viewTargetZ, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glClear((int)256);
        GuiContainerBase.pushViewport(this.renderX, this.renderY, this.width, this.height);
    }

    private void resetViewport() {
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GuiContainerBase.popViewport();
    }

    private void doSelection() {
        Primitive p;
        int posX = this.selectionX;
        int posY = this.selectionY;
        GL11.glDisable((int)3553);
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glClear((int)16640);
        this.model.renderForSelection();
        byte[] pixelColorsb = new byte[3];
        ByteBuffer pixelColors = ByteBuffer.allocateDirect(3);
        GL11.glReadPixels((int)posX, (int)posY, (int)1, (int)1, (int)6407, (int)5120, (ByteBuffer)pixelColors);
        for (int i = 0; i < 3; ++i) {
            pixelColorsb[i] = pixelColors.get(i);
        }
        int r = pixelColorsb[0] & 0xFF;
        int g = pixelColorsb[1] & 0xFF;
        int b = pixelColorsb[2] & 0xFF;
        GL11.glEnable((int)3553);
        int color = r << 14 | g << 7 | b;
        GL11.glClearColor((float)0.2f, (float)0.2f, (float)0.2f, (float)1.0f);
        GL11.glClear((int)16640);
        this.selectedPrimitive = p = this.model.getPrimitive(color);
        this.selectedPiece = p == null ? null : p.parent;
        this.onSelection(this.selectedPiece, this.selectedPrimitive);
    }

    public ModelPiece getSelectedPiece() {
        return this.selectedPiece;
    }

    public Primitive getSelectedPrimitive() {
        return this.selectedPrimitive;
    }

    public ModelBaseAW getModel() {
        return this.model;
    }

    public void addNewPrimitive(Primitive p) {
        if (p.parent != this.selectedPiece) {
            return;
        }
        p.parent.addPrimitive(p);
        this.selectedPiece = p.parent;
        this.selectedPrimitive = p;
        this.onSelection(this.selectedPiece, this.selectedPrimitive);
    }

    public void addNewPiece(String pieceName) {
        ModelPiece pieceParent = this.selectedPiece == null ? null : this.selectedPiece;
        ModelPiece newPiece = new ModelPiece(pieceName, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, pieceParent);
        this.model.addPiece(newPiece);
        this.selectedPiece = newPiece;
        this.selectedPrimitive = null;
        this.onSelection(this.selectedPiece, this.selectedPrimitive);
    }

    public void deleteSelectedPiece() {
        if (this.selectedPiece != null) {
            this.selectedPiece.setParent(null);
            this.model.removePiece(this.selectedPiece);
        }
        this.selectedPiece = null;
        this.selectedPrimitive = null;
        this.onSelection(this.selectedPiece, this.selectedPrimitive);
    }

    public void deleteSelectedPrimitive() {
        if (this.selectedPrimitive != null) {
            this.selectedPrimitive.parent.removePrimitive(this.selectedPrimitive);
        }
        this.selectedPrimitive = null;
        this.onSelection(this.selectedPiece, this.selectedPrimitive);
    }

    public void copyPiece() {
        if (this.selectedPiece != null) {
            ModelPiece copy = this.selectedPiece.copy();
            if (copy.getParent() != null) {
                copy.getParent().addChild(copy);
            }
            this.model.addPiece(copy);
            this.selectedPiece = copy;
            this.selectedPrimitive = null;
        }
        this.onSelection(this.selectedPiece, this.selectedPrimitive);
    }

    public void renameCurrentPiece(String name) {
        ModelPiece piece = this.getSelectedPiece();
        piece.setName(name);
        this.model.removePiece(piece);
        this.model.addPiece(piece);
        this.onSelection(this.selectedPiece, this.selectedPrimitive);
    }

    public void copyPrimitive() {
        Primitive p = this.getSelectedPrimitive().copy();
        this.getSelectedPiece().addPrimitive(p);
        this.selectedPrimitive = p;
        this.onSelection(this.selectedPiece, this.selectedPrimitive);
    }

    public void swapPieceParent(ModelPiece newParent) {
        this.getSelectedPiece().setParent(newParent);
    }

    public void swapPrimitiveParent(ModelPiece newParent) {
        Primitive p = this.getSelectedPrimitive();
        ModelPiece oldParent = p.parent;
        oldParent.removePrimitive(p);
        newParent.addPrimitive(p);
    }

    public void loadModel(File file) {
        ModelBaseAW model = this.loader.loadModel(file);
        if (model != null) {
            this.model = model;
            this.setSelection(null, null);
        }
    }

    public void setSelection(ModelPiece piece, Primitive p) {
        this.selectedPiece = piece;
        this.selectedPrimitive = p;
        this.onSelection(piece, p);
        this.calculateHighlightedPieces();
    }

    public void saveModel(File file) {
        this.loader.saveModel(this.model, file);
    }

    public void loadTexture(File file) {
        try {
            BufferedImage image = ImageIO.read(file);
            this.setTexture(AWTextureManager.instance().loadImageBasedTexture(file.getAbsolutePath(), image));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void importPieces(File file) {
        ModelBaseAW model = this.loader.loadModel(file);
        if (model != null) {
            for (ModelPiece p : model.getBasePieces()) {
                this.model.addPiece(p);
            }
        }
    }

    protected void onSelection(ModelPiece piece, Primitive primitive) {
    }

    public void clearPieceParent() {
        if (this.selectedPiece != null) {
            this.model.removePiece(this.selectedPiece);
            this.selectedPiece.setParent(null);
            this.model.addPiece(this.selectedPiece);
        }
    }
}

