/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.crafting.AWCraftingManager;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.interfaces.IResearchRecipe;
import net.shadowmage.ancientwarfare.core.interfaces.ITooltipRenderer;
import net.shadowmage.ancientwarfare.core.research.ResearchGoal;
import net.shadowmage.ancientwarfare.core.research.ResearchTracker;

public class GuiResearchBook
extends GuiContainerBase {
    private IResearchRecipe selectedRecipe = null;
    private ResearchGoal selectedGoal = null;
    private CompositeScrolled area;
    private CompositeScrolled detailsArea;
    private boolean researchMode = true;
    private Checkbox modeBox;

    public GuiResearchBook(ContainerBase container) {
        super(container, 400, 240);
    }

    @Override
    public void initElements() {
        this.area = new CompositeScrolled(this, 0, 40, this.field_146999_f / 2, this.field_147000_g - 40);
        this.addGuiElement(this.area);
        this.modeBox = new Checkbox(8, 8, 16, 16, "guistrings.research.research_mode"){

            @Override
            public void onToggled() {
                GuiResearchBook.this.researchMode = this.checked();
                GuiResearchBook.this.refreshGui();
            }
        };
        this.modeBox.setChecked(this.researchMode);
        this.addGuiElement(this.modeBox);
        this.detailsArea = new CompositeScrolled(this, this.field_146999_f / 2, 40, this.field_146999_f / 2, this.field_147000_g - 40);
        this.addGuiElement(this.detailsArea);
    }

    @Override
    public void setupElements() {
        this.area.clearElements();
        this.detailsArea.clearElements();
        this.modeBox.setChecked(this.researchMode);
        if (this.researchMode) {
            this.addResearchModeControls();
        } else {
            this.addRecipeModeControls();
        }
    }

    private void addRecipeModeControls() {
        int totalHeight = 8;
        for (IResearchRecipe recipe : AWCraftingManager.INSTANCE.getRecipes()) {
            this.area.addGuiElement(new RecipeButton(8, totalHeight, recipe));
            totalHeight += 12;
        }
        this.area.setAreaSize(totalHeight);
        totalHeight = 8;
        this.detailsArea.addGuiElement(this.getRecipeButton(8, totalHeight, this.selectedRecipe));
        totalHeight += 14;
        if (this.selectedRecipe != null) {
            Set<Integer> depIds = this.selectedRecipe.getNeededResearch();
            boolean canShow = true;
            for (int num : depIds) {
                if (ResearchTracker.INSTANCE.hasPlayerCompleted((World)this.field_146297_k.field_71441_e, this.field_146297_k.field_71439_g.func_70005_c_(), num)) continue;
                canShow = false;
                break;
            }
            if (canShow) {
                int i;
                ItemStack[] ingredients = new ItemStack[this.selectedRecipe.func_77570_a()];
                for (i = 0; i < ingredients.length; ++i) {
                    Object object = this.selectedRecipe.getInputs()[i];
                    if (object instanceof ItemStack) {
                        ingredients[i] = (ItemStack)object;
                        continue;
                    }
                    if (!(object instanceof Iterable)) continue;
                    ingredients[i] = (ItemStack)((Iterable)object).iterator().next();
                }
                for (i = 0; i < this.selectedRecipe.getRecipeWidth(); ++i) {
                    for (int j = 0; j < this.selectedRecipe.getRecipeHeight(); ++j) {
                        this.detailsArea.addGuiElement(new ItemSlot(9 + 18 * i, totalHeight + 18 * j, ingredients[i + j * this.selectedRecipe.getRecipeWidth()], this));
                    }
                }
                this.detailsArea.addGuiElement(new Label(8 + 18 * (this.selectedRecipe.getRecipeWidth() + 1), (totalHeight += (this.selectedRecipe.getRecipeHeight() - 1) * 9) + 2, "->"));
            }
            this.detailsArea.addGuiElement(new ItemSlot(9 + 18 * (this.selectedRecipe.getRecipeWidth() + 2), totalHeight, this.selectedRecipe.func_77571_b(), this));
            totalHeight = canShow ? (totalHeight += (this.selectedRecipe.getRecipeHeight() + 1) * 9) : (totalHeight += 20);
            this.detailsArea.addGuiElement(new Label(8, totalHeight, "guistrings.research.research_needed"));
            totalHeight += 14;
            for (int num : depIds) {
                ResearchGoal goal = ResearchGoal.getGoal(num);
                if (goal == null) continue;
                GoalButton button = new GoalButton(8, totalHeight, goal);
                this.detailsArea.addGuiElement(button);
                totalHeight += 12;
            }
        }
    }

    private void addResearchModeControls() {
        ArrayList<ResearchGoal> goals = new ArrayList<ResearchGoal>();
        goals.addAll(ResearchGoal.getResearchGoals());
        Collections.sort(goals, new ResearchSorter());
        int totalHeight = 8;
        for (ResearchGoal goal : goals) {
            this.area.addGuiElement(new GoalButton(8, totalHeight, goal));
            totalHeight += 12;
        }
        this.area.setAreaSize(totalHeight);
        totalHeight = 8;
        this.detailsArea.addGuiElement(this.getResearchButton(8, totalHeight, this.selectedGoal));
        totalHeight += 16;
        if (this.selectedGoal != null) {
            Set<ResearchGoal> deps;
            List<IResearchRecipe> recipes = AWCraftingManager.INSTANCE.getRecipes();
            ArrayList<IResearchRecipe> list = new ArrayList<IResearchRecipe>();
            for (IResearchRecipe recipe : recipes) {
                if (!recipe.getNeededResearch().contains(this.selectedGoal.getId())) continue;
                list.add(recipe);
            }
            if (!list.isEmpty()) {
                this.detailsArea.addGuiElement(new Label(8, totalHeight, "guistrings.research.researched_items"));
                totalHeight += 14;
                for (int i = 0; i < list.size(); ++i) {
                    RecipeSlot slot = new RecipeSlot(i, totalHeight, (IResearchRecipe)list.get(i), this);
                    this.detailsArea.addGuiElement(slot);
                }
                totalHeight += 18 * (1 + list.size() / 9);
            }
            if (!(deps = this.selectedGoal.getDependencies()).isEmpty()) {
                this.detailsArea.addGuiElement(new Label(8, totalHeight, "guistrings.research.research_needed"));
                totalHeight += 14;
                for (ResearchGoal goal : deps) {
                    GoalButton button = new GoalButton(8, totalHeight, goal);
                    this.detailsArea.addGuiElement(button);
                    totalHeight += 12;
                }
            }
        }
    }

    private Button getRecipeButton(int topLeftX, int topLeftY, IResearchRecipe recipe) {
        return new Button(topLeftX, topLeftY, 160, 12, recipe == null ? "guistrings.no_selection" : recipe.func_77571_b().func_82833_r());
    }

    private Button getResearchButton(int topLeftX, int topLeftY, ResearchGoal goal) {
        return new Button(topLeftX, topLeftY, 160, 10, goal == null ? "guistrings.no_selection" : goal.getName());
    }

    private class ResearchSorter
    implements Comparator<ResearchGoal> {
        private ResearchSorter() {
        }

        @Override
        public int compare(ResearchGoal arg0, ResearchGoal arg1) {
            String nameA = StatCollector.func_74838_a((String)arg0.getName());
            String nameB = StatCollector.func_74838_a((String)arg1.getName());
            return nameA.compareTo(nameB);
        }
    }

    private class GoalButton
    extends Button {
        final ResearchGoal goal;

        public GoalButton(int topLeftX, int topLeftY, ResearchGoal goal) {
            super(topLeftX, topLeftY, 160, 10, goal == null ? "guistrings.no_selection" : goal.getName());
            this.goal = goal;
        }

        @Override
        protected void onPressed() {
            GuiResearchBook.this.selectedGoal = this.goal;
            GuiResearchBook.this.researchMode = true;
            GuiResearchBook.this.refreshGui();
        }
    }

    private class RecipeButton
    extends Button {
        final IResearchRecipe recipe;

        public RecipeButton(int topLeftX, int topLeftY, IResearchRecipe recipe) {
            super(topLeftX, topLeftY, 160, 12, recipe == null ? "guistrings.no_selection" : recipe.func_77571_b().func_82833_r());
            this.recipe = recipe;
        }

        @Override
        protected void onPressed() {
            GuiResearchBook.this.selectedRecipe = this.recipe;
            GuiResearchBook.this.refreshGui();
        }
    }

    private class RecipeSlot
    extends ItemSlot {
        private final IResearchRecipe researched;

        public RecipeSlot(int i, int totalHeight, IResearchRecipe recipe, ITooltipRenderer render) {
            super(8 + 18 * (i % 9), totalHeight + 18 * (i / 9), recipe.func_77571_b(), render);
            this.setRenderItemQuantity(false);
            this.researched = recipe;
        }

        @Override
        public void onSlotClicked(ItemStack stack) {
            GuiResearchBook.this.selectedRecipe = this.researched;
            GuiResearchBook.this.researchMode = false;
            GuiResearchBook.this.refreshGui();
        }
    }
}

