/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.entity;

import java.util.Comparator;
import net.minecraft.entity.DataWatcher;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.util.StringTools;

public class WatchedData
extends DataWatcher.WatchableObject {
    public WatchedData(int key, Object value) {
        super(Type.index(value.getClass()), key, value);
    }

    public WatchedData(Type type, int key, String text) {
        super(type.ordinal(), key, type.parse(text));
    }

    public boolean isValid() {
        return this.func_75669_b() != null && this.func_75672_a() <= 31 && this.func_75674_c() >= 0 && this.func_75674_c() < Type.values().length;
    }

    public Type getType() {
        return Type.values()[this.func_75674_c()];
    }

    public boolean collideWith(DataWatcher.WatchableObject object) {
        return this.func_75672_a() == object.func_75672_a();
    }

    public boolean canReplace(DataWatcher.WatchableObject object) {
        return this.collideWith(object) && this.func_75674_c() == object.func_75674_c();
    }

    public void add(DataWatcher watcher) {
        watcher.func_75682_a(this.func_75672_a(), this.func_75669_b());
    }

    public static WatchedData fromTag(NBTTagCompound tagCompound) {
        byte i = tagCompound.func_74771_c("Index");
        Type t = Type.valueOf(tagCompound.func_74779_i("Type"));
        Object value = t.getValue(tagCompound);
        if (value != null) {
            return new WatchedData(i, value);
        }
        return null;
    }

    public NBTTagCompound toTag() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74774_a("Index", (byte)this.func_75672_a());
        Type t = Type.values()[this.func_75674_c()];
        tagCompound.func_74778_a("Type", t.name());
        t.setValue(tagCompound, this.func_75669_b());
        return tagCompound;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof WatchedData && this.canReplace((DataWatcher.WatchableObject)object) && this.func_75669_b().equals(((DataWatcher.WatchableObject)object).func_75669_b());
    }

    public int hashCode() {
        return ((31 + this.func_75672_a()) * 31 + this.func_75674_c()) * 31 + this.func_75669_b().hashCode();
    }

    public static enum IndexSorter implements Comparator<DataWatcher.WatchableObject>
    {
        INSTANCE;


        @Override
        public int compare(DataWatcher.WatchableObject o1, DataWatcher.WatchableObject o2) {
            return o1.func_75672_a() - o2.func_75672_a();
        }
    }

    public static enum Type {
        BYTE(Byte.class),
        SHORT(Short.class),
        INT(Integer.class),
        FLOAT(Float.class),
        STRING(String.class),
        STACK(ItemStack.class);

        private static final String TAG = "Value";
        private final Class c;

        private Type(Class c) {
            this.c = c;
        }

        public Type next() {
            return Type.values()[(this.ordinal() + 1) % Type.values().length];
        }

        public static int index(Class cl) {
            for (Type type : Type.values()) {
                if (!cl.equals(type.c)) continue;
                return type.ordinal();
            }
            return -1;
        }

        public Object getValue(NBTTagCompound compound) {
            if (this == BYTE) {
                return compound.func_74771_c(TAG);
            }
            if (this == SHORT) {
                return compound.func_74765_d(TAG);
            }
            if (this == INT) {
                return compound.func_74762_e(TAG);
            }
            if (this == FLOAT) {
                return Float.valueOf(compound.func_74760_g(TAG));
            }
            if (this == STRING) {
                return compound.func_74779_i(TAG);
            }
            if (this == STACK) {
                return ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l(TAG));
            }
            return null;
        }

        public void setValue(NBTTagCompound compound, Object object) {
            if (this == BYTE) {
                compound.func_74774_a(TAG, ((Byte)object).byteValue());
            } else if (this == SHORT) {
                compound.func_74777_a(TAG, ((Short)object).shortValue());
            } else if (this == INT) {
                compound.func_74768_a(TAG, ((Integer)object).intValue());
            } else if (this == FLOAT) {
                compound.func_74776_a(TAG, ((Float)object).floatValue());
            } else if (this == STRING) {
                compound.func_74778_a(TAG, (String)object);
            } else if (this == STACK) {
                NBTTagCompound nbt = new NBTTagCompound();
                ((ItemStack)object).func_77955_b(nbt);
                compound.func_74782_a(TAG, (NBTBase)nbt);
            }
        }

        public Object parse(String text) {
            if (this == BYTE) {
                return Byte.valueOf(text);
            }
            if (this == SHORT) {
                return Short.valueOf(text);
            }
            if (this == INT) {
                return Integer.valueOf(text);
            }
            if (this == FLOAT) {
                return Float.valueOf(text);
            }
            if (this == STACK) {
                String[] splits = StringTools.parseStringArray(text);
                if (splits.length > 2) {
                    return StringTools.safeParseStack(splits[0], splits[1], splits[2]);
                }
                if (splits.length == 2) {
                    return StringTools.safeParseStack(splits[0], "0", splits[1]);
                }
                return StringTools.safeParseStack(text, "0", "1");
            }
            return text;
        }

        public String toString(Object value) {
            if (this == BYTE) {
                return Byte.toString((Byte)value);
            }
            if (this == SHORT) {
                return Short.toString((Short)value);
            }
            if (this == INT) {
                return Integer.toString((Integer)value);
            }
            if (this == FLOAT) {
                return Float.toString(((Float)value).floatValue());
            }
            if (this == STACK) {
                ItemStack stack = (ItemStack)value;
                String result = Item.field_150901_e.func_148750_c((Object)stack.func_77973_b());
                return result + "," + stack.func_77960_j() + "," + stack.field_77994_a;
            }
            return value.toString();
        }
    }
}

