/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite;

import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteBoundedInventory;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.upgrade.WorksiteUpgrade;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public final class WorkSiteQuarry
extends TileWorksiteBoundedInventory {
    private static final int TOP_LENGTH = 27;
    boolean finished;
    private boolean hasDoneInit = false;
    private int currentX;
    private int currentY;
    private int currentZ;
    private int validateX;
    private int validateY;
    private int validateZ;

    public WorkSiteQuarry() {
        this.inventory = new BlockRotationHandler.InventorySided(this, BlockRotationHandler.RotationType.FOUR_WAY, 27);
        int[] topIndices = InventoryTools.getIndiceArrayForSpread(27);
        this.inventory.setAccessibleSideDefault(BlockRotationHandler.RelativeSide.TOP, BlockRotationHandler.RelativeSide.TOP, topIndices);
    }

    @Override
    public boolean userAdjustableBlocks() {
        return false;
    }

    @Override
    protected void onBoundsSet() {
        super.onBoundsSet();
        this.offsetBounds();
    }

    private void offsetBounds() {
        BlockPosition pos = this.getWorkBoundsMax();
        this.setWorkBoundsMax(pos.moveUp(this.field_145848_d - 1 - pos.y));
        pos = this.getWorkBoundsMin();
        this.setWorkBoundsMin(pos.moveUp(1 - pos.y));
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void onBoundsAdjusted() {
        this.offsetBounds();
        this.currentX = this.getWorkBoundsMin().x;
        this.currentY = this.getWorkBoundsMax().y;
        this.currentZ = this.getWorkBoundsMin().z;
        this.validateX = this.currentX;
        this.validateY = this.currentY;
        this.validateZ = this.currentZ;
    }

    @Override
    public EnumSet<WorksiteUpgrade> getValidUpgrades() {
        return EnumSet.of(WorksiteUpgrade.ENCHANTED_TOOLS_1, new WorksiteUpgrade[]{WorksiteUpgrade.ENCHANTED_TOOLS_2, WorksiteUpgrade.QUARRY_MEDIUM, WorksiteUpgrade.QUARRY_LARGE, WorksiteUpgrade.TOOL_QUALITY_1, WorksiteUpgrade.TOOL_QUALITY_2, WorksiteUpgrade.TOOL_QUALITY_3, WorksiteUpgrade.QUARRY_CHUNK_LOADER});
    }

    @Override
    public int getBoundsMaxWidth() {
        return this.getUpgrades().contains((Object)WorksiteUpgrade.QUARRY_LARGE) ? 64 : (this.getUpgrades().contains((Object)WorksiteUpgrade.QUARRY_MEDIUM) ? 32 : 16);
    }

    @Override
    protected void updateWorksite() {
        if (!this.hasDoneInit) {
            this.initWorkSite();
            this.hasDoneInit = true;
        }
        this.field_145850_b.field_72984_F.func_76320_a("Incremental Scan");
        if (this.canHarvest(this.validateX, this.validateY, this.validateZ)) {
            this.currentX = this.validateX;
            this.currentY = this.validateY;
            this.currentZ = this.validateZ;
            this.finished = false;
        } else {
            this.incrementValidationPosition();
        }
        this.field_145850_b.field_72984_F.func_76319_b();
    }

    @Override
    public void addUpgrade(WorksiteUpgrade upgrade) {
        super.addUpgrade(upgrade);
        this.currentY = this.getWorkBoundsMax().y;
        this.currentX = this.getWorkBoundsMin().x;
        this.currentZ = this.getWorkBoundsMin().z;
        this.validateX = this.currentX;
        this.validateY = this.currentY;
        this.validateZ = this.currentZ;
        this.finished = false;
    }

    @Override
    protected boolean processWork() {
        if (!this.hasDoneInit) {
            this.initWorkSite();
            this.hasDoneInit = true;
        }
        if (this.finished) {
            return false;
        }
        while (!this.canHarvest(this.currentX, this.currentY, this.currentZ)) {
            if (this.incrementPosition()) continue;
            this.finished = true;
            return false;
        }
        return this.harvestBlock(this.currentX, this.currentY, this.currentZ, BlockRotationHandler.RelativeSide.TOP);
    }

    private boolean incrementPosition() {
        if (this.finished) {
            return false;
        }
        ++this.currentX;
        if (this.currentX > this.getWorkBoundsMax().x) {
            this.currentX = this.getWorkBoundsMin().x;
            ++this.currentZ;
            if (this.currentZ > this.getWorkBoundsMax().z) {
                this.currentZ = this.getWorkBoundsMin().z;
                --this.currentY;
                if (this.currentY <= 0) {
                    return false;
                }
            }
        }
        return true;
    }

    private void incrementValidationPosition() {
        ++this.validateX;
        if (this.validateY >= this.currentY && this.validateZ >= this.currentZ && this.validateX >= this.currentX) {
            this.validateY = this.getWorkBoundsMax().y;
            this.validateX = this.getWorkBoundsMin().x;
            this.validateZ = this.getWorkBoundsMin().z;
        } else if (this.validateX > this.getWorkBoundsMax().x) {
            this.validateX = this.getWorkBoundsMin().x;
            ++this.validateZ;
            if (this.validateZ > this.getWorkBoundsMax().z) {
                this.validateZ = this.getWorkBoundsMin().z;
                --this.validateY;
                if (this.validateY <= 0) {
                    this.validateY = this.getWorkBoundsMax().y;
                    this.validateX = this.getWorkBoundsMin().x;
                    this.validateZ = this.getWorkBoundsMin().z;
                }
            }
        }
    }

    private boolean canHarvest(int x, int y, int z) {
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        if (block.isAir((IBlockAccess)this.field_145850_b, x, y, z) || block.func_149688_o().func_76224_d()) {
            return false;
        }
        int harvestLevel = block.getHarvestLevel(this.field_145850_b.func_72805_g(x, y, z));
        if (harvestLevel >= 2) {
            int toolLevel = 1;
            if (this.getUpgrades().contains((Object)WorksiteUpgrade.TOOL_QUALITY_3)) {
                toolLevel = Integer.MAX_VALUE;
            } else if (this.getUpgrades().contains((Object)WorksiteUpgrade.TOOL_QUALITY_2)) {
                toolLevel = 3;
            } else if (this.getUpgrades().contains((Object)WorksiteUpgrade.TOOL_QUALITY_1)) {
                toolLevel = 2;
            }
            if (toolLevel < harvestLevel) {
                return false;
            }
        }
        return block.func_149712_f(this.field_145850_b, x, y, z) >= 0.0f;
    }

    public void initWorkSite() {
        BlockPosition pos = this.getWorkBoundsMin();
        this.setWorkBoundsMin(pos.moveUp(1 - pos.y));
        this.currentY = this.getWorkBoundsMax().y;
        this.currentX = this.getWorkBoundsMin().x;
        this.currentZ = this.getWorkBoundsMin().z;
        this.validateX = this.currentX;
        this.validateY = this.currentY;
        this.validateZ = this.currentZ;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.MINING;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.currentY = tag.func_74762_e("currentY");
        this.currentX = tag.func_74762_e("currentX");
        this.currentZ = tag.func_74762_e("currentZ");
        this.validateX = tag.func_74762_e("validateX");
        this.validateY = tag.func_74762_e("validateY");
        this.validateZ = tag.func_74762_e("validateZ");
        this.finished = tag.func_74767_n("finished");
        this.hasDoneInit = tag.func_74767_n("init");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("currentY", this.currentY);
        tag.func_74768_a("currentX", this.currentX);
        tag.func_74768_a("currentZ", this.currentZ);
        tag.func_74768_a("validateX", this.validateX);
        tag.func_74768_a("validateY", this.validateY);
        tag.func_74768_a("validateZ", this.validateZ);
        tag.func_74757_a("finished", this.finished);
        tag.func_74757_a("init", this.hasDoneInit);
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 24, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @Override
    protected boolean hasWorksiteWork() {
        return !this.finished;
    }
}

