/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite;

import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInvBasic;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteBase;
import net.shadowmage.ancientwarfare.core.crafting.AWCraftingManager;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.item.ItemResearchBook;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class TileAutoCrafting
extends TileWorksiteBase
implements ISidedInventory,
IInvBasic {
    public net.shadowmage.ancientwarfare.core.inventory.InventoryBasic bookSlot;
    public net.shadowmage.ancientwarfare.core.inventory.InventoryBasic outputInventory;
    public net.shadowmage.ancientwarfare.core.inventory.InventoryBasic resourceInventory;
    public net.shadowmage.ancientwarfare.core.inventory.InventoryBasic outputSlot;
    public InventoryCrafting craftMatrix;
    private boolean canCraftLastCheck = false;
    private boolean canHoldLastCheck = false;
    private int[] outputSlotIndices;
    private int[] resourceSlotIndices;

    public TileAutoCrafting() {
        int i;
        Container dummy = new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return true;
            }

            public void func_75130_a(IInventory par1iInventory) {
                TileAutoCrafting.this.onLayoutMatrixChanged();
                TileAutoCrafting.this.func_76316_a(null);
            }
        };
        this.craftMatrix = new InventoryCrafting(dummy, 3, 3);
        this.resourceInventory = new net.shadowmage.ancientwarfare.core.inventory.InventoryBasic(18, this);
        this.outputInventory = new net.shadowmage.ancientwarfare.core.inventory.InventoryBasic(9, this);
        this.outputSlot = new net.shadowmage.ancientwarfare.core.inventory.InventoryBasic(1);
        this.bookSlot = new net.shadowmage.ancientwarfare.core.inventory.InventoryBasic(1, this);
        this.resourceSlotIndices = new int[this.resourceInventory.func_70302_i_()];
        for (i = 0; i < this.resourceSlotIndices.length; ++i) {
            this.resourceSlotIndices[i] = i;
        }
        this.outputSlotIndices = new int[this.outputInventory.func_70302_i_()];
        for (i = 0; i < this.outputSlotIndices.length; ++i) {
            this.outputSlotIndices[i] = i + this.resourceSlotIndices.length;
        }
    }

    private boolean canCraft() {
        boolean found;
        if (this.outputSlot.func_70301_a(0) == null) {
            return false;
        }
        ArrayList<ItemStack> compactedCraft = new ArrayList<ItemStack>();
        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            ItemStack stack1 = this.craftMatrix.func_70301_a(i);
            if (stack1 == null) continue;
            found = false;
            for (ItemStack stack3 : compactedCraft) {
                if (!InventoryTools.doItemStacksMatch(stack3, stack1)) continue;
                ++stack3.field_77994_a;
                found = true;
                break;
            }
            if (found) continue;
            ItemStack stack2 = stack1.func_77946_l();
            stack2.field_77994_a = 1;
            compactedCraft.add(stack2);
        }
        found = true;
        for (ItemStack stack3 : compactedCraft) {
            if (InventoryTools.getCountOf((IInventory)this.resourceInventory, -1, stack3) >= stack3.field_77994_a) continue;
            found = false;
            break;
        }
        return found;
    }

    public String getCrafterName() {
        return ItemResearchBook.getResearcherName(this.bookSlot.func_70301_a(0));
    }

    public boolean tryCraftItem() {
        if (this.canCraft() && this.canHold()) {
            this.craftItem();
            return true;
        }
        return false;
    }

    private void craftItem() {
        ItemStack stack = this.outputSlot.func_70301_a(0).func_77946_l();
        this.useResources();
        stack = InventoryTools.mergeItemStack((IInventory)this.outputInventory, stack, -1);
        if (stack != null) {
            InventoryTools.dropItemInWorld(this.field_145850_b, stack, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private void useResources() {
        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            ItemStack stack1 = this.craftMatrix.func_70301_a(i);
            if (stack1 == null || InventoryTools.removeItems((IInventory)this.resourceInventory, -1, stack1, 1) == null || (stack1 = InventoryTools.getConsumedItem((IInventory)this.craftMatrix, (IInventory)this.resourceInventory, i, stack1)) == null) continue;
            InventoryTools.dropItemInWorld(this.field_145850_b, stack1, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.CRAFTING;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.bookSlot.readFromNBT(tag.func_74775_l("bookSlot"));
        this.resourceInventory.readFromNBT(tag.func_74775_l("resourceInventory"));
        this.outputInventory.readFromNBT(tag.func_74775_l("outputInventory"));
        this.outputSlot.readFromNBT(tag.func_74775_l("outputSlot"));
        InventoryTools.readInventoryFromNBT((IInventory)this.craftMatrix, tag.func_74775_l("craftMatrix"));
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74782_a("bookSlot", (NBTBase)this.bookSlot.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("resourceInventory", (NBTBase)this.resourceInventory.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("outputInventory", (NBTBase)this.outputInventory.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("outputSlot", (NBTBase)this.outputSlot.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("craftMatrix", (NBTBase)InventoryTools.writeInventoryToNBT((IInventory)this.craftMatrix, new NBTTagCompound()));
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        this.onLayoutMatrixChanged();
    }

    private void onLayoutMatrixChanged() {
        this.outputSlot.func_70299_a(0, AWCraftingManager.INSTANCE.findMatchingRecipe(this.craftMatrix, this.field_145850_b, this.getCrafterName()));
    }

    public int func_70302_i_() {
        return this.resourceInventory.func_70302_i_() + this.outputInventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slotIndex) {
        if (slotIndex >= this.resourceInventory.func_70302_i_()) {
            return this.outputInventory.func_70301_a(slotIndex - this.resourceInventory.func_70302_i_());
        }
        return this.resourceInventory.func_70301_a(slotIndex);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (slot >= this.resourceInventory.func_70302_i_()) {
            return this.outputInventory.func_70298_a(slot - this.resourceInventory.func_70302_i_(), amount);
        }
        return this.resourceInventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int var1) {
        if (var1 >= this.resourceInventory.func_70302_i_()) {
            return this.outputInventory.func_70304_b(var1 - this.resourceInventory.func_70302_i_());
        }
        return this.resourceInventory.func_70304_b(var1);
    }

    public void func_70299_a(int var1, ItemStack var2) {
        if (var1 >= this.resourceInventory.func_70302_i_()) {
            this.outputInventory.func_70299_a(var1 - this.resourceInventory.func_70302_i_(), var2);
            return;
        }
        this.resourceInventory.func_70299_a(var1, var2);
    }

    public void func_76316_a(InventoryBasic internal) {
        if (internal == this.bookSlot) {
            this.onLayoutMatrixChanged();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "autocrafting";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return true;
    }

    public int[] func_94128_d(int side) {
        ForgeDirection d = ForgeDirection.getOrientation((int)side);
        if (d == ForgeDirection.UP) {
            return this.resourceSlotIndices;
        }
        if (d == ForgeDirection.DOWN) {
            return this.outputSlotIndices;
        }
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack var2, int side) {
        return ForgeDirection.getOrientation((int)side) == ForgeDirection.UP;
    }

    public boolean func_102008_b(int slot, ItemStack var2, int side) {
        return ForgeDirection.getOrientation((int)side) == ForgeDirection.DOWN;
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 15, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @Override
    protected boolean processWork() {
        return this.tryCraftItem();
    }

    @Override
    protected boolean hasWorksiteWork() {
        return this.canCraftLastCheck && this.canHoldLastCheck && this.outputSlot.func_70301_a(0) != null;
    }

    @Override
    protected void updateWorksite() {
        this.canCraftLastCheck = this.canCraft();
        this.canHoldLastCheck = this.canHold();
    }

    private boolean canHold() {
        ItemStack test = this.outputSlot.func_70301_a(0);
        return test != null && InventoryTools.canInventoryHold((IInventory)this.outputInventory, -1, test);
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }
}

