/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.warehouse2;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.IControlledTile;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.IControllerTile;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseBase;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public abstract class TileControlled
extends TileEntity
implements IControlledTile {
    private boolean init;
    private IControllerTile controller;
    private BlockPosition controllerPosition;

    public final boolean canUpdate() {
        return true;
    }

    public final void func_145845_h() {
        if (!this.init) {
            this.init = true;
            if (!this.loadController()) {
                this.searchForController();
            }
        }
        this.updateTile();
    }

    private boolean loadController() {
        TileEntity te;
        BlockPosition pos = this.controllerPosition;
        this.controllerPosition = null;
        if (pos != null && this.controller != null && (te = this.field_145850_b.func_147438_o(pos.x, pos.y, pos.z)) instanceof IControllerTile && this.isValidController((IControllerTile)te)) {
            ((IControllerTile)te).addControlledTile(this);
        }
        return this.controller != null;
    }

    protected abstract void updateTile();

    protected void searchForController() {
        BlockPosition pos = this.getPosition();
        BlockPosition min = pos.offset(-16, -4, -16);
        BlockPosition max = pos.offset(16, 4, 16);
        for (TileEntity te : WorldTools.getTileEntitiesInArea(this.field_145850_b, min.x, min.y, min.z, max.x, max.y, max.z)) {
            if (!(te instanceof IControllerTile) || !this.isValidController((IControllerTile)te)) continue;
            ((IControllerTile)te).addControlledTile(this);
            break;
        }
    }

    protected boolean isValidController(IControllerTile tile) {
        return tile instanceof TileWarehouseBase && BlockTools.isPositionWithinBounds(this.getPosition(), ((TileWarehouseBase)tile).getWorkBoundsMin(), ((TileWarehouseBase)tile).getWorkBoundsMax());
    }

    public final void func_145843_s() {
        if (this.controller != null) {
            this.controller.removeControlledTile(this);
        }
        this.controller = null;
        this.init = false;
        super.func_145843_s();
    }

    public final void func_145829_t() {
        this.func_145843_s();
        super.func_145829_t();
    }

    @Override
    public final void setController(IControllerTile tile) {
        this.controller = tile;
        this.controllerPosition = tile == null ? null : tile.getPosition();
    }

    @Override
    public final IControllerTile getController() {
        return this.controller;
    }

    @Override
    public final BlockPosition getPosition() {
        return new BlockPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("controllerPosition")) {
            this.controllerPosition = new BlockPosition(tag.func_74775_l("controllerPosition"));
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.controllerPosition != null) {
            tag.func_74782_a("controllerPosition", (NBTBase)this.controllerPosition.writeToNBT(new NBTTagCompound()));
        }
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof TileControlled && this.field_145850_b == ((TileControlled)obj).func_145831_w() && this.getPosition().equals(((TileControlled)obj).getPosition());
    }

    public final int hashCode() {
        return this.getPosition().hashCode();
    }
}

