/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.torque;

import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.scoreboard.Team;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.automation.config.AWAutomationStatics;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueSingleCell;
import net.shadowmage.ancientwarfare.core.config.AWCoreStatics;
import net.shadowmage.ancientwarfare.core.interfaces.IOwnable;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.interfaces.IWorker;
import net.shadowmage.ancientwarfare.core.upgrade.WorksiteUpgrade;

public class TileHandGenerator
extends TileTorqueSingleCell
implements IWorkSite,
IOwnable {
    String ownerName = "";
    private final ITorque.TorqueCell inputCell;
    double clientInputEnergy;
    int clientInputDestEnergy;
    double inputRotation;
    double prevInputRotation;

    public TileHandGenerator() {
        double eff = AWAutomationStatics.low_efficiency_factor;
        this.torqueCell = new ITorque.TorqueCell(0.0, 32.0, 32.0, eff);
        this.inputCell = new ITorque.TorqueCell(32.0, 0.0, 150.0, eff);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.serverNetworkUpdate();
            this.torqueIn = this.torqueCell.getEnergy() - this.prevEnergy;
            this.balancePower();
            this.torqueOut = this.transferPowerTo(this.getPrimaryFacing());
            this.torqueLoss = this.applyPowerDrain(this.torqueCell);
            this.torqueLoss += this.applyPowerDrain(this.inputCell);
            this.prevEnergy = this.torqueCell.getEnergy();
        } else {
            this.clientNetworkUpdate();
            this.updateRotation();
        }
    }

    protected void balancePower() {
        double trans = Math.min(2.0, this.torqueCell.getMaxEnergy() - this.torqueCell.getEnergy());
        trans = Math.min(trans, this.inputCell.getEnergy());
        this.inputCell.setEnergy(this.inputCell.getEnergy() - trans);
        this.torqueCell.setEnergy(this.torqueCell.getEnergy() + trans);
    }

    @Override
    protected void serverNetworkSynch() {
        super.serverNetworkSynch();
        int percent = (int)(this.inputCell.getPercentFull() * 100.0);
        if (percent != this.clientInputDestEnergy) {
            this.clientInputDestEnergy = percent;
            this.sendSideRotation(ForgeDirection.UP, percent);
        }
    }

    @Override
    protected void updateRotation() {
        super.updateRotation();
        this.prevInputRotation = this.inputRotation;
        if (this.clientInputEnergy > 0.0) {
            double r = 30.000001907348633 * this.clientInputEnergy * 0.01;
            this.inputRotation += r;
        }
    }

    @Override
    protected void clientNetworkUpdate() {
        if (this.clientEnergyState != (double)this.clientDestEnergyState || this.clientInputEnergy != (double)this.clientInputDestEnergy) {
            if (this.networkUpdateTicks >= 0) {
                this.clientEnergyState += ((double)this.clientDestEnergyState - this.clientEnergyState) / ((double)this.networkUpdateTicks + 1.0);
                this.clientInputEnergy += ((double)this.clientInputDestEnergy - this.clientInputEnergy) / ((double)this.networkUpdateTicks + 1.0);
                --this.networkUpdateTicks;
            } else {
                this.clientEnergyState = this.clientDestEnergyState;
                this.clientInputEnergy = this.clientInputDestEnergy;
            }
        }
    }

    @Override
    protected void handleClientRotationData(ForgeDirection side, int value) {
        super.handleClientRotationData(side, value);
        if (side == ForgeDirection.UP) {
            this.clientInputDestEnergy = value;
        }
    }

    @Override
    public void onBlockBroken() {
    }

    @Override
    public EnumSet<WorksiteUpgrade> getUpgrades() {
        return EnumSet.noneOf(WorksiteUpgrade.class);
    }

    @Override
    public EnumSet<WorksiteUpgrade> getValidUpgrades() {
        return EnumSet.noneOf(WorksiteUpgrade.class);
    }

    @Override
    public void addUpgrade(WorksiteUpgrade upgrade) {
    }

    @Override
    public void removeUpgrade(WorksiteUpgrade upgrade) {
    }

    @Override
    public boolean hasWork() {
        return this.inputCell.getEnergy() < this.inputCell.getMaxEnergy();
    }

    @Override
    public void addEnergyFromWorker(IWorker worker) {
        this.inputCell.setEnergy(this.inputCell.getEnergy() + AWCoreStatics.energyPerWorkUnit * (double)worker.getWorkEffectiveness(this.getWorkType()) * AWAutomationStatics.hand_cranked_generator_output);
    }

    @Override
    public void addEnergyFromPlayer(EntityPlayer player) {
        this.inputCell.setEnergy(this.inputCell.getEnergy() + AWCoreStatics.energyPerWorkUnit * AWAutomationStatics.hand_cranked_generator_output);
    }

    @Override
    public IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.CRAFTING;
    }

    @Override
    public Team getTeam() {
        return this.field_145850_b.func_96441_U().func_96509_i(this.ownerName);
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        return player != null && player.func_70005_c_().equals(this.ownerName);
    }

    @Override
    public void setOwner(EntityPlayer player) {
        this.ownerName = player.func_70005_c_();
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public NBTTagCompound getDescriptionTag() {
        NBTTagCompound tag = super.getDescriptionTag();
        tag.func_74768_a("clientInputDestEnergy", this.clientInputDestEnergy);
        return tag;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound tag = pkt.func_148857_g();
        this.clientInputDestEnergy = tag.func_74762_e("clientInputDestEnergy");
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("owner")) {
            this.ownerName = tag.func_74779_i("owner");
        }
        this.inputCell.setEnergy(tag.func_74769_h("inputEnergy"));
        this.clientInputDestEnergy = tag.func_74762_e("clientInputEnergy");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.ownerName != null) {
            tag.func_74778_a("owner", this.ownerName);
        }
        tag.func_74780_a("inputEnergy", this.inputCell.getEnergy());
        tag.func_74768_a("clientInputEnergy", this.clientInputDestEnergy);
    }

    @Override
    public double getMaxTorque(ForgeDirection from) {
        return this.inputCell.getMaxEnergy() + this.torqueCell.getMaxEnergy();
    }

    @Override
    public double getTorqueStored(ForgeDirection from) {
        return this.inputCell.getEnergy() + this.torqueCell.getEnergy();
    }

    @Override
    public double addTorque(ForgeDirection from, double energy) {
        if (from == this.getPrimaryFacing()) {
            return 0.0;
        }
        if (from == ForgeDirection.UP || from == ForgeDirection.UNKNOWN) {
            return this.inputCell.addEnergy(energy);
        }
        return 0.0;
    }

    @Override
    public double drainTorque(ForgeDirection from, double energy) {
        if (from == this.getPrimaryFacing()) {
            return this.torqueCell.drainEnergy(energy);
        }
        return 0.0;
    }

    @Override
    public double getMaxTorqueOutput(ForgeDirection from) {
        if (from == this.getPrimaryFacing()) {
            return this.torqueCell.getMaxTickOutput();
        }
        return 0.0;
    }

    @Override
    public double getMaxTorqueInput(ForgeDirection from) {
        return 0.0;
    }

    @Override
    public boolean canInputTorque(ForgeDirection from) {
        return false;
    }

    @Override
    public float getClientOutputRotation(ForgeDirection from, float delta) {
        if (from == this.getPrimaryFacing()) {
            return this.getRotation(this.rotation, this.prevRotation, delta);
        }
        if (from == ForgeDirection.UP) {
            return this.getRotation(this.inputRotation, this.prevInputRotation, delta);
        }
        return 0.0f;
    }

    @Override
    public boolean useOutputRotation(ForgeDirection from) {
        return true;
    }

    @Override
    protected double getTotalTorque() {
        return this.inputCell.getEnergy() + this.torqueCell.getEnergy();
    }
}

