/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.guide;

import com.cout970.magneticraft.client.gui.component.GuiPoint;
import net.minecraft.client.gui.Gui;

public class Box2D {
    private GuiPoint min;
    private GuiPoint max;

    public Box2D(int x1, int y1, int x2, int y2) {
        this.min = new GuiPoint(Math.min(x1, x2), Math.min(y1, y2));
        this.max = new GuiPoint(Math.max(x1, x2), Math.max(y1, y2));
    }

    public Box2D(GuiPoint a, GuiPoint b) {
        this(a.x, a.y, b.x, b.y);
    }

    public int getMinX() {
        return this.min.x;
    }

    public int getMinY() {
        return this.min.y;
    }

    public int getMaxX() {
        return this.max.x;
    }

    public int getMaxY() {
        return this.max.y;
    }

    public int sizeX() {
        return this.max.x - this.min.x;
    }

    public int sizeY() {
        return this.max.y - this.min.y;
    }

    public GuiPoint min() {
        return this.min.copy();
    }

    public GuiPoint max() {
        return this.max.copy();
    }

    public Box2D copy() {
        return new Box2D(this.max, this.min);
    }

    public Box2D translate(int x, int y) {
        this.min.x += x;
        this.max.x += x;
        this.min.y += y;
        this.max.y += y;
        return this;
    }

    public boolean isIn(int x, int y) {
        return x >= this.getMinX() && x <= this.getMaxX() && y >= this.getMinY() && y <= this.getMaxY();
    }

    public void draw(int color) {
        Gui.func_73734_a((int)this.getMinX(), (int)this.getMinY(), (int)(this.getMinX() + 1), (int)this.getMaxY(), (int)color);
        Gui.func_73734_a((int)this.getMinX(), (int)this.getMaxY(), (int)this.getMaxX(), (int)(this.getMaxY() + 1), (int)color);
        Gui.func_73734_a((int)this.getMinX(), (int)this.getMinY(), (int)this.getMaxX(), (int)(this.getMinY() + 1), (int)color);
        Gui.func_73734_a((int)this.getMaxX(), (int)this.getMinY(), (int)(this.getMaxX() + 1), (int)(this.getMaxY() + 1), (int)color);
    }

    public String toString() {
        return "Box2D{min=" + this.min + ", max=" + this.max + '}';
    }
}

