/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.synthesis;

import minechem.gui.GuiTabStateControl;
import minechem.tileentity.synthesis.SynthesisRecipe;
import minechem.tileentity.synthesis.SynthesisTileEntity;
import net.minecraft.client.gui.Gui;

public class SynthesisTabStateControl
extends GuiTabStateControl {
    private int lastKnownEnergyCost;

    public SynthesisTabStateControl(Gui gui, SynthesisTileEntity synthesis) {
        super(gui);
        this.tileEntity = synthesis;
        this.state = GuiTabStateControl.TabState.norecipe;
    }

    @Override
    public void update() {
        super.update();
        SynthesisTileEntity synthesis = (SynthesisTileEntity)this.tileEntity;
        SynthesisRecipe recipe = synthesis.getCurrentRecipe();
        if (recipe == null) {
            this.state = GuiTabStateControl.TabState.norecipe;
        } else {
            this.lastKnownEnergyCost = recipe.energyCost();
            this.state = synthesis.hasEnoughPowerForCurrentRecipe() ? GuiTabStateControl.TabState.powered : GuiTabStateControl.TabState.unpowered;
        }
        this.overlayColor = this.state.color;
    }

    @Override
    public String getTooltip() {
        if (!this.isFullyOpened()) {
            if (this.state == GuiTabStateControl.TabState.unpowered && this.lastKnownEnergyCost > 0) {
                return "Energy Needed: " + this.lastKnownEnergyCost;
            }
            return this.state.tooltip;
        }
        return null;
    }
}

