/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.blueprintprojector;

import java.util.HashMap;
import java.util.Map;
import minechem.MinechemItemsRegistration;
import minechem.gui.GuiContainerTabbed;
import minechem.gui.GuiTabHelp;
import minechem.gui.GuiTabPatreon;
import minechem.item.blueprint.BlueprintBlock;
import minechem.item.blueprint.MinechemBlueprint;
import minechem.reference.Resources;
import minechem.tileentity.blueprintprojector.BlueprintProjectorContainer;
import minechem.tileentity.blueprintprojector.BlueprintProjectorTileEntity;
import minechem.utils.MinechemUtil;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class BlueprintProjectorGui
extends GuiContainerTabbed {
    BlueprintProjectorTileEntity projector;

    public BlueprintProjectorGui(InventoryPlayer inventoryPlayer, BlueprintProjectorTileEntity projector) {
        super(new BlueprintProjectorContainer(inventoryPlayer, projector));
        this.projector = projector;
        this.addTab(new GuiTabHelp(this, MinechemUtil.getLocalString("help.projector")));
        this.addTab(new GuiTabPatreon(this));
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(Resources.Gui.PROJECTOR);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        ItemStack blueprintStack = this.projector.func_70301_a(0);
        if (blueprintStack != null) {
            this.drawBlueprintInfo(blueprintStack);
        }
        GL11.glPopMatrix();
    }

    private HashMap<Integer, Integer> getBlockCount(MinechemBlueprint blueprint) {
        HashMap<Integer, Integer> blockCount = new HashMap<Integer, Integer>();
        for (int x = 0; x < blueprint.xSize; ++x) {
            for (int y = 0; y < blueprint.ySize; ++y) {
                for (int z = 0; z < blueprint.zSize; ++z) {
                    int structureID = blueprint.getStructure()[y][x][z];
                    int count = 0;
                    if (blockCount.get(structureID) != null) {
                        count = blockCount.get(structureID);
                    }
                    blockCount.put(structureID, ++count);
                }
            }
        }
        return blockCount;
    }

    private void drawBlueprintInfo(ItemStack blueprintStack) {
        MinechemBlueprint blueprint = MinechemItemsRegistration.blueprint.getBlueprint(blueprintStack);
        if (blueprint == null) {
            return;
        }
        String name = blueprintStack.func_82833_r().replace("Blueprint", "");
        this.field_146289_q.func_78261_a(name, 64, 12, 0xFFFFFF);
        HashMap<Integer, Integer> blockCount = this.getBlockCount(blueprint);
        HashMap<Integer, BlueprintBlock> blockLookup = blueprint.getBlockLookup();
        int y = 23;
        for (Map.Entry<Integer, Integer> entry : blockCount.entrySet()) {
            BlueprintBlock block = blockLookup.get(entry.getKey());
            if (block == null) continue;
            ItemStack itemstack = new ItemStack(block.block, 1, block.metadata);
            String info = String.format("%dx%s", entry.getValue(), itemstack.func_82833_r());
            this.field_146289_q.func_78276_b(info, 64, y, 0xDDDDDD);
            y += 10;
        }
    }
}

