/*
 * Decompiled with CFR 0.152.
 */
package minechem.potion;

import java.util.ArrayList;
import minechem.item.molecule.Molecule;
import minechem.item.molecule.MoleculeEnum;
import minechem.potion.PotionChemical;
import net.minecraft.util.StatCollector;

public enum PotionMineralEnum {
    quartz("Quartz", new Molecule(MoleculeEnum.siliconDioxide)),
    berlinite("Berlinite", new Molecule(MoleculeEnum.aluminiumPhosphate, 4));

    private final String descriptiveName;
    private final String localizationKey;
    private final ArrayList<PotionChemical> components;

    public String getName() {
        String localizedName = StatCollector.func_74838_a((String)this.localizationKey);
        if (localizedName.isEmpty()) {
            return this.localizationKey;
        }
        return localizedName;
    }

    public PotionChemical[] getComposition() {
        return this.components.toArray(new PotionChemical[this.components.size()]);
    }

    private PotionMineralEnum(String descriptiveName, PotionChemical ... chemicals) {
        this.descriptiveName = descriptiveName;
        this.localizationKey = "mineral." + this.name();
        this.components = new ArrayList();
        for (PotionChemical potionChemical : chemicals) {
            this.components.add(potionChemical);
        }
    }
}

