/*
 * Decompiled with CFR 0.152.
 */
package minechem.fluid;

import java.awt.Color;
import minechem.MinechemItemsRegistration;
import minechem.fluid.MinechemFluid;
import minechem.item.MinechemChemicalType;
import minechem.item.element.ElementEnum;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FluidElement
extends MinechemFluid {
    public final ElementEnum element;
    private final int color;

    public FluidElement(ElementEnum element) {
        super("element." + element.name(), element.roomState());
        this.element = element;
        this.color = this.computColor();
    }

    @Override
    public ItemStack getOutputStack() {
        return new ItemStack((Item)MinechemItemsRegistration.element, 1, this.element.atomicNumber());
    }

    @Override
    public MinechemChemicalType getChemical() {
        return this.element;
    }

    public int getColor(FluidStack stack) {
        return stack.getFluid().getColor();
    }

    public int getColor() {
        return this.color;
    }

    private int computColor() {
        float red = 0.0f;
        float blue = 0.0f;
        float green = 0.0f;
        switch (this.element.classification()) {
            case actinide: {
                red = 1.0f;
                break;
            }
            case alkaliMetal: {
                green = 1.0f;
                break;
            }
            case alkalineEarthMetal: {
                blue = 1.0f;
                break;
            }
            case halogen: {
                red = 1.0f;
                green = 1.0f;
                break;
            }
            case inertGas: {
                green = 1.0f;
                blue = 1.0f;
                break;
            }
            case lanthanide: {
                red = 1.0f;
                blue = 1.0f;
                break;
            }
            case nonmetal: {
                red = 1.0f;
                green = 0.5f;
                break;
            }
            case otherMetal: {
                red = 0.5f;
                green = 1.0f;
                break;
            }
            case semimetallic: {
                green = 1.0f;
                blue = 0.5f;
                break;
            }
            case transitionMetal: {
                green = 0.5f;
                blue = 1.0f;
                break;
            }
        }
        return new Color(red, green, blue).getRGB();
    }
}

