/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.varia;

import mcjty.lib.container.InventoryHelper;
import mcjty.lib.varia.Coordinate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class InventoryLocator {
    private Coordinate inventoryCoordinate = null;
    private int inventorySide = 0;

    public IInventory getInventoryAtDirection(World worldObj, Coordinate thisCoordinate, ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            if (this.inventoryCoordinate != null) {
                return this.getInventoryAtCoordinate(worldObj, this.inventoryCoordinate);
            }
            return null;
        }
        this.inventoryCoordinate = thisCoordinate.addDirection(direction);
        this.inventorySide = direction.getOpposite().ordinal();
        return this.getInventoryAtCoordinate(worldObj, this.inventoryCoordinate);
    }

    private IInventory getInventoryAtCoordinate(World worldObj, Coordinate c) {
        TileEntity te = worldObj.func_147438_o(c.getX(), c.getY(), c.getZ());
        if (te instanceof IInventory) {
            return (IInventory)te;
        }
        return null;
    }

    public void ejectStack(World worldObj, int x, int y, int z, ItemStack spentMaterial, Coordinate thisCoordinate, ForgeDirection[] directions) {
        boolean spawnInWorld = true;
        for (ForgeDirection dir : directions) {
            IInventory inventory = this.getInventoryAtDirection(worldObj, thisCoordinate, dir);
            if (inventory == null || InventoryHelper.mergeItemStackSafe((IInventory)inventory, (boolean)false, (int)this.getInventorySide(), (ItemStack)spentMaterial, (int)0, (int)inventory.func_70302_i_(), null) != 0) continue;
            spawnInWorld = false;
            break;
        }
        if (spawnInWorld) {
            EntityItem entityItem = new EntityItem(worldObj, (double)x, (double)y, (double)z, spentMaterial);
            worldObj.func_72838_d((Entity)entityItem);
        }
    }

    public int getInventorySide() {
        return this.inventorySide;
    }
}

