/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.purifier;

import elec332.core.world.WorldHelper;
import java.util.Random;
import mcjty.deepresonance.blocks.base.ElecTileBase;
import mcjty.deepresonance.blocks.purifier.PurifierContainer;
import mcjty.deepresonance.blocks.tank.ITankHook;
import mcjty.deepresonance.blocks.tank.TileTank;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.deepresonance.fluid.DRFluidRegistry;
import mcjty.deepresonance.fluid.LiquidCrystalFluidTagData;
import mcjty.deepresonance.items.ModItems;
import mcjty.deepresonance.varia.InventoryLocator;
import mcjty.lib.container.InventoryHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class PurifierTileEntity
extends ElecTileBase
implements ITankHook,
ISidedInventory {
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, PurifierContainer.factory, 1);
    private TileTank bottomTank;
    private TileTank topTank;
    private int progress = 0;
    private InventoryLocator inventoryLocator = new InventoryLocator();
    private LiquidCrystalFluidTagData fluidData = null;
    private static Random random = new Random();
    private static ForgeDirection[] directions = new ForgeDirection[]{ForgeDirection.UNKNOWN, ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.SOUTH};

    protected void checkStateServer() {
        if (this.progress > 0) {
            --this.progress;
            if (this.progress == 0 && this.fluidData != null) {
                this.progress = 1;
                if (this.getOutputTank() != null && this.testFillOutputTank() && this.validSlot()) {
                    if (random.nextInt(this.doPurify()) == 0) {
                        this.consumeFilter();
                    }
                    this.progress = 0;
                }
            }
            this.func_70296_d();
        } else if (this.canWork() && this.validSlot()) {
            this.progress = ConfigMachines.Purifier.ticksPerPurify;
            this.fluidData = LiquidCrystalFluidTagData.fromStack(this.getInputTank().drain(ForgeDirection.UNKNOWN, ConfigMachines.Purifier.rclPerPurify, true));
            this.func_70296_d();
        }
    }

    private void consumeFilter() {
        this.inventoryHelper.decrStackSize(0, 1);
        ItemStack spentMaterial = new ItemStack((Item)ModItems.spentFilterMaterialItem, 1);
        this.inventoryLocator.ejectStack(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, spentMaterial, this.getCoordinate(), directions);
    }

    private int doPurify() {
        float maxPurityToAdd;
        float purity = this.fluidData.getPurity();
        float addedPurity = maxPurityToAdd = (float)ConfigMachines.Purifier.addedPurity / 100.0f;
        float maxPurity = (float)ConfigMachines.Purifier.maxPurity / 100.0f;
        if (purity + addedPurity > (maxPurity *= this.fluidData.getQuality()) && (addedPurity = maxPurity - purity) < 1.0E-4f) {
            FluidStack stack = this.fluidData.makeLiquidCrystalStack();
            this.getOutputTank().fill(ForgeDirection.UNKNOWN, stack, true);
            this.fluidData = null;
            return 1000;
        }
        this.fluidData.setPurity(purity += addedPurity);
        FluidStack stack = this.fluidData.makeLiquidCrystalStack();
        this.getOutputTank().fill(ForgeDirection.UNKNOWN, stack, true);
        this.fluidData = null;
        return (int)((maxPurityToAdd - addedPurity) * 1000.0f / maxPurityToAdd + 1.0f);
    }

    private boolean testFillOutputTank() {
        return this.getOutputTank().fill(ForgeDirection.UNKNOWN, new FluidStack(DRFluidRegistry.liquidCrystal, ConfigMachines.Purifier.rclPerPurify), false) == ConfigMachines.Purifier.rclPerPurify;
    }

    private TileTank getInputTank() {
        if (this.topTank == null) {
            return this.bottomTank;
        }
        return this.topTank;
    }

    private TileTank getOutputTank() {
        if (this.bottomTank == null) {
            return this.topTank;
        }
        return this.bottomTank;
    }

    private boolean canWork() {
        if (this.bottomTank == null && this.topTank == null) {
            return false;
        }
        if (this.getInputTank().getFluidAmount() < ConfigMachines.Purifier.rclPerPurify) {
            return false;
        }
        if (this.getInputTank().getMultiBlock().equals((Object)this.getOutputTank().getMultiBlock())) {
            return true;
        }
        return this.testFillOutputTank();
    }

    private boolean validSlot() {
        return this.inventoryHelper.getStackInSlot(0) != null && this.inventoryHelper.getStackInSlot(0).func_77973_b() == ModItems.filterMaterialItem;
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("progress", this.progress);
        if (this.fluidData != null) {
            NBTTagCompound dataCompound = new NBTTagCompound();
            this.fluidData.writeDataToNBT(dataCompound);
            tagCompound.func_74782_a("data", (NBTBase)dataCompound);
            tagCompound.func_74768_a("amount", this.fluidData.getInternalTankAmount());
        }
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.progress = tagCompound.func_74762_e("progress");
        if (tagCompound.func_74764_b("data")) {
            NBTTagCompound dataCompound = (NBTTagCompound)tagCompound.func_74781_a("data");
            int amount = dataCompound.func_74762_e("amount");
            this.fluidData = LiquidCrystalFluidTagData.fromNBT(dataCompound, amount);
        } else {
            this.fluidData = null;
        }
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.setStackInSlot(i, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound));
        }
    }

    @Override
    public void hook(TileTank tank, ForgeDirection direction) {
        if (direction == ForgeDirection.DOWN) {
            if (this.validRCLTank(tank)) {
                this.bottomTank = tank;
            }
        } else if (this.topTank == null && this.validRCLTank(tank)) {
            this.topTank = tank;
        }
    }

    @Override
    public void unHook(TileTank tank, ForgeDirection direction) {
        if (this.tilesEqual(this.bottomTank, tank)) {
            this.bottomTank = null;
            this.notifyNeighboursOfDataChange();
        } else if (this.tilesEqual(this.topTank, tank)) {
            this.topTank = null;
            this.notifyNeighboursOfDataChange();
        }
    }

    @Override
    public void onContentChanged(TileTank tank, ForgeDirection direction) {
        if (this.tilesEqual(this.topTank, tank) && !this.validRCLTank(tank)) {
            this.topTank = null;
        }
        if (this.tilesEqual(this.bottomTank, tank) && !this.validRCLTank(tank)) {
            this.bottomTank = null;
        }
    }

    private boolean validRCLTank(TileTank tank) {
        Fluid fluid = DRFluidRegistry.getFluidFromStack(tank.getFluid());
        return fluid == null || fluid == DRFluidRegistry.liquidCrystal;
    }

    private boolean tilesEqual(TileTank first, TileTank second) {
        return first != null && second != null && first.myLocation().equals((Object)second.myLocation()) && WorldHelper.getDimID((World)first.func_145831_w()) == WorldHelper.getDimID((World)second.func_145831_w());
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int index, ItemStack item, int side) {
        return PurifierContainer.factory.isInputSlot(index) || PurifierContainer.factory.isSpecificItemSlot(index);
    }

    public boolean func_102008_b(int index, ItemStack item, int side) {
        return PurifierContainer.factory.isOutputSlot(index);
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public String func_145825_b() {
        return "Purifier Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }
}

