/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.laser;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.blocks.laser.InfusingBonus;
import mcjty.deepresonance.blocks.laser.LaserContainer;
import mcjty.deepresonance.blocks.lens.LensSetup;
import mcjty.deepresonance.blocks.tank.TileTank;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.deepresonance.fluid.DRFluidRegistry;
import mcjty.deepresonance.fluid.LiquidCrystalFluidTagData;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketRequestIntegerFromServer;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Coordinate;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class LaserTileEntity
extends GenericEnergyReceiverTileEntity
implements ISidedInventory {
    public static final String CMD_GETLIQUID = "getLiquid";
    public static final String CLIENTCMD_GETLIQUID = "getLiquid";
    public static final int COLOR_BLUE = 1;
    public static final int COLOR_RED = 2;
    public static final int COLOR_GREEN = 3;
    public static final int COLOR_YELLOW = 4;
    private int tickCounter = 10;
    private int progressCounter = 0;
    private int color = 0;
    private int crystalLiquid = 0;
    private int powered = 0;
    private static int crystalLiquidClient = 0;
    public static Map<String, InfusingBonus> infusingBonusMap = null;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, LaserContainer.factory, 2);

    public LaserTileEntity() {
        super(ConfigMachines.Laser.rfMaximum, ConfigMachines.Laser.rfPerTick);
    }

    public void setPowered(int powered) {
        if (this.powered != powered) {
            this.powered = powered;
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    protected void checkStateServer() {
        --this.tickCounter;
        if (this.tickCounter > 0) {
            return;
        }
        this.tickCounter = 10;
        this.checkCrystal();
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.powered == 0) {
            this.changeColor(0, meta);
            return;
        }
        ItemStack stack = this.inventoryHelper.getStackInSlot(1);
        InfusingBonus bonus = LaserTileEntity.getInfusingBonus(stack);
        if (bonus == null) {
            this.changeColor(0, meta);
            return;
        }
        if (this.getEnergyStored(ForgeDirection.UNKNOWN) < ConfigMachines.Laser.rfUsePerCatalyst) {
            this.changeColor(0, meta);
            return;
        }
        if (this.crystalLiquid < ConfigMachines.Laser.crystalLiquidPerCatalyst) {
            this.changeColor(0, meta);
            return;
        }
        Coordinate tankCoordinate = this.findLens(meta);
        if (tankCoordinate == null) {
            this.changeColor(0, meta);
            return;
        }
        this.changeColor(bonus.getColor(), meta);
        --this.progressCounter;
        this.func_70296_d();
        if (this.progressCounter > 0) {
            return;
        }
        this.progressCounter = ConfigMachines.Laser.ticks10PerCatalyst;
        this.infuseLiquid(tankCoordinate, bonus);
    }

    private boolean validRCLTank(TileTank tank) {
        Fluid fluid = DRFluidRegistry.getFluidFromStack(tank.getFluid());
        return fluid == null || fluid == DRFluidRegistry.liquidCrystal;
    }

    private void infuseLiquid(Coordinate tankCoordinate, InfusingBonus bonus) {
        FluidStack stack;
        TileTank tileTank;
        this.func_70298_a(1, 1);
        this.consumeEnergy(ConfigMachines.Laser.rfUsePerCatalyst);
        this.crystalLiquid -= ConfigMachines.Laser.crystalLiquidPerCatalyst;
        TileEntity te = this.field_145850_b.func_147438_o(tankCoordinate.getX(), tankCoordinate.getY(), tankCoordinate.getZ());
        if (te instanceof TileTank && this.validRCLTank(tileTank = (TileTank)te) && (stack = tileTank.drain(ForgeDirection.UNKNOWN, ConfigMachines.Laser.rclPerCatalyst, false)) != null) {
            stack = tileTank.drain(ForgeDirection.UNKNOWN, ConfigMachines.Laser.rclPerCatalyst, true);
            LiquidCrystalFluidTagData fluidData = LiquidCrystalFluidTagData.fromStack(stack);
            float purity = bonus.getPurityModifier().modify(fluidData.getPurity(), fluidData.getQuality());
            float strength = bonus.getStrengthModifier().modify(fluidData.getStrength(), fluidData.getQuality());
            float efficiency = bonus.getEfficiencyModifier().modify(fluidData.getEfficiency(), fluidData.getQuality());
            fluidData.setPurity(purity);
            fluidData.setStrength(strength);
            fluidData.setEfficiency(efficiency);
            FluidStack newStack = fluidData.makeLiquidCrystalStack();
            if ((double)Math.abs(purity) < 0.01) {
                newStack.amount /= 10;
            }
            tileTank.fill(ForgeDirection.UNKNOWN, newStack, true);
        }
    }

    private void changeColor(int newcolor, int meta) {
        if (newcolor != this.color) {
            this.color = newcolor;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            meta = this.color == 4 ? meta & 3 | 8 : meta & 3 | this.color << 2;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta, 3);
            this.func_70296_d();
        }
    }

    public int getColor() {
        return this.color;
    }

    private void checkCrystal() {
        ItemStack stack = this.inventoryHelper.getStackInSlot(0);
        if (stack != null) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            float strength = tagCompound == null ? 0.0f : tagCompound.func_74760_g("strength") / 100.0f;
            int addAmount = (int)((float)ConfigMachines.Laser.minCrystalLiquidPerCrystal + strength * (float)(ConfigMachines.Laser.maxCrystalLiquidPerCrystal - ConfigMachines.Laser.minCrystalLiquidPerCrystal));
            int newAmount = this.crystalLiquid + addAmount;
            if (newAmount > ConfigMachines.Laser.crystalLiquidMaximum) {
                return;
            }
            this.inventoryHelper.decrStackSize(0, 1);
            this.crystalLiquid = newAmount;
            this.func_70296_d();
        }
    }

    public static InfusingBonus getInfusingBonus(ItemStack item) {
        if (item == null) {
            return null;
        }
        String name = Item.field_150901_e.func_148750_c((Object)item.func_77973_b());
        return infusingBonusMap.get(name);
    }

    public static void createDefaultInfusionBonusMap() {
        infusingBonusMap = new HashMap<String, InfusingBonus>();
        infusingBonusMap.put(Item.field_150901_e.func_148750_c((Object)Items.field_151045_i), new InfusingBonus(1, new InfusingBonus.Modifier(5.0f, 100.0f), InfusingBonus.Modifier.NONE, InfusingBonus.Modifier.NONE));
        infusingBonusMap.put(Item.field_150901_e.func_148750_c((Object)Items.field_151166_bC), new InfusingBonus(3, new InfusingBonus.Modifier(8.0f, 100.0f), InfusingBonus.Modifier.NONE, InfusingBonus.Modifier.NONE));
        infusingBonusMap.put(Item.field_150901_e.func_148750_c((Object)Items.field_151079_bi), new InfusingBonus(3, new InfusingBonus.Modifier(2.0f, 100.0f), InfusingBonus.Modifier.NONE, InfusingBonus.Modifier.NONE));
        infusingBonusMap.put(Item.field_150901_e.func_148750_c((Object)Items.field_151137_ax), new InfusingBonus(2, new InfusingBonus.Modifier(-1.0f, 0.0f), new InfusingBonus.Modifier(5.0f, 60.0f), InfusingBonus.Modifier.NONE));
        infusingBonusMap.put(Item.field_150901_e.func_148750_c((Object)Items.field_151016_H), new InfusingBonus(2, new InfusingBonus.Modifier(-5.0f, 0.0f), new InfusingBonus.Modifier(8.0f, 70.0f), new InfusingBonus.Modifier(4.0f, 60.0f)));
        infusingBonusMap.put(Item.field_150901_e.func_148750_c((Object)Items.field_151114_aO), new InfusingBonus(4, new InfusingBonus.Modifier(-2.0f, 0.0f), new InfusingBonus.Modifier(6.0f, 50.0f), new InfusingBonus.Modifier(3.0f, 50.0f)));
        infusingBonusMap.put(Item.field_150901_e.func_148750_c((Object)Items.field_151065_br), new InfusingBonus(4, new InfusingBonus.Modifier(-6.0f, 0.0f), new InfusingBonus.Modifier(5.0f, 70.0f), new InfusingBonus.Modifier(5.0f, 70.0f)));
        infusingBonusMap.put(Item.field_150901_e.func_148750_c((Object)Items.field_151128_bU), new InfusingBonus(1, new InfusingBonus.Modifier(-1.0f, 0.0f), InfusingBonus.Modifier.NONE, new InfusingBonus.Modifier(7.0f, 80.0f)));
        infusingBonusMap.put(Item.field_150901_e.func_148750_c((Object)Items.field_151156_bN), new InfusingBonus(2, new InfusingBonus.Modifier(-60.0f, 0.0f), new InfusingBonus.Modifier(90.0f, 100.0f), new InfusingBonus.Modifier(90.0f, 100.0f)));
        infusingBonusMap.put(Item.field_150901_e.func_148750_c((Object)Items.field_151073_bk), new InfusingBonus(4, new InfusingBonus.Modifier(-20.0f, 0.0f), new InfusingBonus.Modifier(25.0f, 100.0f), new InfusingBonus.Modifier(15.0f, 100.0f)));
        infusingBonusMap.put(Item.field_150901_e.func_148750_c((Object)Items.field_151123_aH), new InfusingBonus(3, InfusingBonus.Modifier.NONE, InfusingBonus.Modifier.NONE, new InfusingBonus.Modifier(-10.0f, 1.0f)));
        infusingBonusMap.put(Item.field_150901_e.func_148750_c((Object)Items.field_151044_h), new InfusingBonus(2, new InfusingBonus.Modifier(-1.0f, 0.0f), new InfusingBonus.Modifier(-10.0f, 0.0f), InfusingBonus.Modifier.NONE));
    }

    private Coordinate findLens(int meta) {
        ForgeDirection direction = BlockTools.getOrientationHoriz((int)meta);
        Coordinate shouldBeAir = this.getCoordinate().addDirection(direction);
        if (!this.field_145850_b.func_147437_c(shouldBeAir.getX(), shouldBeAir.getY(), shouldBeAir.getZ())) {
            return null;
        }
        Coordinate shouldBeLens = shouldBeAir.addDirection(direction);
        Block lensBlock = this.field_145850_b.func_147439_a(shouldBeLens.getX(), shouldBeLens.getY(), shouldBeLens.getZ());
        if (lensBlock != LensSetup.lensBlock) {
            return null;
        }
        ForgeDirection lensDirection = BlockTools.getOrientationHoriz((int)this.field_145850_b.func_72805_g(shouldBeLens.getX(), shouldBeLens.getY(), shouldBeLens.getZ()));
        if (lensDirection != direction) {
            return null;
        }
        return shouldBeLens.addDirection(direction);
    }

    public void requestCrystalLiquidFromServer() {
        DeepResonance.networkHandler.getNetworkWrapper().sendToServer((IMessage)new PacketRequestIntegerFromServer(this.field_145851_c, this.field_145848_d, this.field_145849_e, "getLiquid", "getLiquid", new Argument[0]));
    }

    @SideOnly(value=Side.CLIENT)
    public static int getCrystalLiquidClient() {
        return crystalLiquidClient;
    }

    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        Integer rc = super.executeWithResultInteger(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getLiquid".equals(command)) {
            return this.crystalLiquid;
        }
        return null;
    }

    public boolean execute(String command, Integer result) {
        boolean rc = super.execute(command, result);
        if (rc) {
            return true;
        }
        if ("getLiquid".equals(command)) {
            crystalLiquidClient = result;
            return true;
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.color = tagCompound.func_74762_e("color");
        this.progressCounter = tagCompound.func_74762_e("progress");
        this.powered = tagCompound.func_74771_c("powered");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        this.readBufferFromNBT(tagCompound);
        this.crystalLiquid = tagCompound.func_74762_e("liquid");
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.setStackInSlot(i, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound));
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("color", this.color);
        tagCompound.func_74768_a("progress", this.progressCounter);
        tagCompound.func_74774_a("powered", (byte)this.powered);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        this.writeBufferToNBT(tagCompound);
        tagCompound.func_74768_a("liquid", this.crystalLiquid);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 3), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - 3), (double)(this.field_145851_c + 4), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 4));
    }

    public boolean func_102008_b(int index, ItemStack item, int side) {
        return false;
    }

    public int[] func_94128_d(int side) {
        return new int[]{1, 0};
    }

    public boolean func_102007_a(int index, ItemStack item, int side) {
        switch (index) {
            case 0: {
                return item.func_77969_a(new ItemStack((Block)ModBlocks.resonatingCrystalBlock));
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(index == 0 ? 1 : 64, index, stack);
    }

    public String func_145825_b() {
        return "Laser Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.resonatingCrystalBlock);
        }
        return true;
    }
}

