/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.crystalizer;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import elec332.core.world.WorldHelper;
import java.util.Map;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.blocks.base.ElecEnergyReceiverTileBase;
import mcjty.deepresonance.blocks.crystalizer.CrystalizerContainer;
import mcjty.deepresonance.blocks.tank.ITankHook;
import mcjty.deepresonance.blocks.tank.TileTank;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.deepresonance.fluid.DRFluidRegistry;
import mcjty.deepresonance.fluid.LiquidCrystalFluidTagData;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketRequestIntegerFromServer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class CrystalizerTileEntity
extends ElecEnergyReceiverTileBase
implements ITankHook,
ISidedInventory {
    public static final String CMD_GETPROGRESS = "getProgress";
    public static final String CLIENTCMD_GETPROGRESS = "getProgress";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CrystalizerContainer.factory, 1);
    private TileTank rclTank;
    private static int totalProgress = 0;
    private int progress = 0;
    private LiquidCrystalFluidTagData mergedData = null;
    private static int clientProgress = 0;

    public CrystalizerTileEntity() {
        super(ConfigMachines.Crystalizer.rfMaximum, ConfigMachines.Crystalizer.rfPerTick);
    }

    public static int getTotalProgress() {
        if (totalProgress == 0) {
            totalProgress = ConfigMachines.Crystalizer.rclPerCrystal / ConfigMachines.Crystalizer.rclPerTick;
        }
        return totalProgress;
    }

    protected void checkStateServer() {
        if (!this.canCrystalize()) {
            return;
        }
        this.storage.extractEnergy(ConfigMachines.Crystalizer.rfPerRcl, false);
        FluidStack fluidStack = this.rclTank.drain(ForgeDirection.UNKNOWN, ConfigMachines.Crystalizer.rclPerTick, true);
        LiquidCrystalFluidTagData data = LiquidCrystalFluidTagData.fromStack(fluidStack);
        if (this.mergedData == null) {
            this.mergedData = data;
        } else {
            this.mergedData.merge(data);
        }
        this.handleProgress();
    }

    private void handleProgress() {
        ++this.progress;
        if (this.progress == 1) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.progress >= CrystalizerTileEntity.getTotalProgress()) {
            this.progress = 0;
            this.makeCrystal();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.func_70296_d();
    }

    public int getProgress() {
        return this.progress;
    }

    public static int getClientProgress() {
        return clientProgress;
    }

    private boolean canCrystalize() {
        if (this.rclTank == null) {
            return false;
        }
        if (this.storage.getEnergyStored() < ConfigMachines.Crystalizer.rfPerRcl) {
            return false;
        }
        if (this.hasCrystal()) {
            return false;
        }
        FluidStack fluidStack = this.rclTank.drain(ForgeDirection.UNKNOWN, ConfigMachines.Crystalizer.rclPerTick, false);
        return fluidStack != null && fluidStack.amount == ConfigMachines.Crystalizer.rclPerTick;
    }

    public boolean hasCrystal() {
        ItemStack crystalStack = this.inventoryHelper.getStackInSlot(0);
        return crystalStack != null;
    }

    private void makeCrystal() {
        ItemStack stack = new ItemStack((Block)ModBlocks.resonatingCrystalBlock);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74776_a("power", 100.0f);
        compound.func_74776_a("strength", this.mergedData.getStrength() * 100.0f);
        compound.func_74776_a("efficiency", this.mergedData.getEfficiency() * 100.0f);
        compound.func_74776_a("purity", this.mergedData.getPurity() * 100.0f);
        compound.func_74774_a("version", (byte)2);
        stack.func_77982_d(compound);
        this.mergedData = null;
        this.inventoryHelper.setStackInSlot(0, stack);
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("progress", this.progress);
        if (this.mergedData != null) {
            NBTTagCompound dataCompound = new NBTTagCompound();
            this.mergedData.writeDataToNBT(dataCompound);
            tagCompound.func_74782_a("data", (NBTBase)dataCompound);
            tagCompound.func_74768_a("amount", this.mergedData.getInternalTankAmount());
        }
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.progress = tagCompound.func_74762_e("progress");
        if (tagCompound.func_74764_b("data")) {
            NBTTagCompound dataCompound = (NBTTagCompound)tagCompound.func_74781_a("data");
            int amount = dataCompound.func_74762_e("amount");
            this.mergedData = LiquidCrystalFluidTagData.fromNBT(dataCompound, amount);
        } else {
            this.mergedData = null;
        }
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.setStackInSlot(i, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound));
        }
    }

    @Override
    public void hook(TileTank tank, ForgeDirection direction) {
        if (direction != ForgeDirection.DOWN) {
            return;
        }
        if (this.rclTank == null && this.validRCLTank(tank)) {
            this.rclTank = tank;
        }
    }

    @Override
    public void unHook(TileTank tank, ForgeDirection direction) {
        if (this.tilesEqual(this.rclTank, tank)) {
            this.rclTank = null;
            this.notifyNeighboursOfDataChange();
        }
    }

    @Override
    public void onContentChanged(TileTank tank, ForgeDirection direction) {
        if (this.tilesEqual(this.rclTank, tank) && !this.validRCLTank(tank)) {
            this.rclTank = null;
        }
    }

    private boolean validRCLTank(TileTank tank) {
        Fluid fluid = DRFluidRegistry.getFluidFromStack(tank.getFluid());
        return fluid == null || fluid == DRFluidRegistry.liquidCrystal;
    }

    private boolean tilesEqual(TileTank first, TileTank second) {
        return first != null && second != null && first.myLocation().equals((Object)second.myLocation()) && WorldHelper.getDimID((World)first.func_145831_w()) == WorldHelper.getDimID((World)second.func_145831_w());
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int index, ItemStack item, int side) {
        return false;
    }

    public boolean func_102008_b(int index, ItemStack item, int side) {
        return index == 0;
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public String func_145825_b() {
        return "Crystalizer Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.resonatingCrystalBlock);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    public void requestProgressFromServer() {
        DeepResonance.networkHandler.getNetworkWrapper().sendToServer((IMessage)new PacketRequestIntegerFromServer(this.field_145851_c, this.field_145848_d, this.field_145849_e, "getProgress", "getProgress", new Argument[0]));
    }

    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        Integer rc = super.executeWithResultInteger(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getProgress".equals(command)) {
            return this.progress * 100 / CrystalizerTileEntity.getTotalProgress();
        }
        return null;
    }

    public boolean execute(String command, Integer result) {
        boolean rc = super.execute(command, result);
        if (rc) {
            return true;
        }
        if ("getProgress".equals(command)) {
            clientProgress = result;
            return true;
        }
        return false;
    }
}

