/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.collector;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Set;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.blocks.collector.EnergyCollectorTESR;
import mcjty.deepresonance.blocks.crystals.ResonatingCrystalTileEntity;
import mcjty.deepresonance.blocks.generator.GeneratorConfiguration;
import mcjty.deepresonance.blocks.generator.GeneratorTileEntity;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.deepresonance.generatornetwork.DRGeneratorNetwork;
import mcjty.deepresonance.radiation.DRRadiationManager;
import mcjty.deepresonance.varia.Broadcaster;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.varia.Coordinate;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class EnergyCollectorTileEntity
extends GenericTileEntity {
    public static final float CRYSTAL_MIN_POWER = 1.0E-5f;
    public static int MAXTICKS = 20;
    private Set<Coordinate> crystals = new HashSet<Coordinate>();
    private boolean lasersActive = false;
    private int laserStartup = 0;
    private int radiationUpdateCount = MAXTICKS;
    private int networkID = -1;
    private static int ERROR_TOOMANYCRYSTALS = -1;
    private static int ERROR_TOOMUCHPOWER = -2;

    protected void checkStateServer() {
        boolean active = false;
        int startup = 0;
        DRGeneratorNetwork.Network network = null;
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (te instanceof GeneratorTileEntity) {
            GeneratorTileEntity generatorTileEntity = (GeneratorTileEntity)te;
            DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(this.field_145850_b);
            if (this.networkID != generatorTileEntity.getNetworkId()) {
                if (this.networkID != -1) {
                    generatorNetwork.getOrCreateNetwork(this.networkID).decCollectorBlocks();
                }
                this.networkID = generatorTileEntity.getNetworkId();
                generatorTileEntity.getNetwork().incCollectorBlocks();
                generatorNetwork.save(this.field_145850_b);
            }
            if ((network = generatorTileEntity.getNetwork()) != null) {
                if (network.isActive()) {
                    int rfPerTick = this.calculateRF();
                    network.setLastRfPerTick(rfPerTick);
                    int newEnergy = network.getEnergy() + rfPerTick;
                    int maxEnergy = network.getGeneratorBlocks() * GeneratorConfiguration.rfPerGeneratorBlock;
                    if (newEnergy > maxEnergy) {
                        newEnergy = maxEnergy;
                    }
                    if (network.getEnergy() != newEnergy) {
                        network.setEnergy(newEnergy);
                        generatorNetwork.save(this.field_145850_b);
                    }
                    active = true;
                } else {
                    network.setLastRfPerTick(0);
                }
                startup = network.getStartupCounter();
            }
        } else if (this.networkID != -1) {
            this.networkID = -1;
            this.func_70296_d();
        }
        if (active != this.lasersActive || startup != this.laserStartup) {
            boolean doFind = this.lasersActive != active || this.laserStartup > GeneratorConfiguration.startupTime - 5;
            this.lasersActive = active;
            this.laserStartup = startup;
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (doFind && te instanceof GeneratorTileEntity) {
                this.findCrystals(network);
            }
        }
    }

    public void disableCrystalGlow() {
        for (Coordinate coordinate : this.crystals) {
            TileEntity te = this.field_145850_b.func_147438_o(coordinate.getX() + this.field_145851_c, coordinate.getY() + this.field_145848_d, coordinate.getZ() + this.field_145849_e);
            if (!(te instanceof ResonatingCrystalTileEntity)) continue;
            ResonatingCrystalTileEntity resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)te;
            resonatingCrystalTileEntity.setGlowing(false);
        }
    }

    private int calculateRF() {
        HashSet<Coordinate> tokeep = new HashSet<Coordinate>();
        boolean dirty = false;
        float radiationRadius = 0.0f;
        float radiationStrength = 0.0f;
        boolean doRadiation = false;
        --this.radiationUpdateCount;
        if (this.radiationUpdateCount <= 0) {
            this.radiationUpdateCount = MAXTICKS;
            doRadiation = true;
        }
        int rf = 0;
        for (Coordinate coordinate : this.crystals) {
            TileEntity te = this.field_145850_b.func_147438_o(coordinate.getX() + this.field_145851_c, coordinate.getY() + this.field_145848_d, coordinate.getZ() + this.field_145849_e);
            if (te instanceof ResonatingCrystalTileEntity) {
                ResonatingCrystalTileEntity resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)te;
                if (resonatingCrystalTileEntity.getPower() > 1.0E-5f) {
                    float purity;
                    resonatingCrystalTileEntity.setGlowing(this.lasersActive);
                    tokeep.add(coordinate);
                    float power = resonatingCrystalTileEntity.getPower();
                    if (power < resonatingCrystalTileEntity.getPowerPerTick()) {
                        resonatingCrystalTileEntity.setPower(0.0f);
                        continue;
                    }
                    resonatingCrystalTileEntity.setPower(power -= resonatingCrystalTileEntity.getPowerPerTick());
                    int rfPerTick = resonatingCrystalTileEntity.getRfPerTick();
                    rf += rfPerTick;
                    if (!doRadiation || !((purity = resonatingCrystalTileEntity.getPurity()) < 99.0f)) continue;
                    float radius = DRRadiationManager.calculateRadiationRadius(resonatingCrystalTileEntity.getEfficiency(), purity);
                    if (radius > radiationRadius) {
                        radiationRadius = radius;
                    }
                    float strength = DRRadiationManager.calculateRadiationStrength(resonatingCrystalTileEntity.getStrength(), purity);
                    radiationStrength += strength;
                    continue;
                }
                resonatingCrystalTileEntity.setGlowing(false);
                dirty = true;
                continue;
            }
            dirty = true;
        }
        if (dirty) {
            this.crystals = tokeep;
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (doRadiation && radiationRadius > 0.1f) {
            GlobalCoordinate thisCoordinate;
            DRRadiationManager radiationManager = DRRadiationManager.getManager(this.field_145850_b);
            if (radiationManager.getRadiationSource(thisCoordinate = new GlobalCoordinate(new Coordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e), this.field_145850_b.field_73011_w.field_76574_g)) == null) {
                Logging.log((String)("Created radiation source with radius " + radiationRadius + " and strength " + radiationStrength));
            }
            DRRadiationManager.RadiationSource radiationSource = radiationManager.getOrCreateRadiationSource(thisCoordinate);
            radiationSource.update(radiationRadius, radiationStrength, MAXTICKS);
            radiationManager.save(this.field_145850_b);
        }
        return rf;
    }

    public void addCrystal(int x, int y, int z) {
        if (this.networkID == -1) {
            return;
        }
        DRGeneratorNetwork channels = DRGeneratorNetwork.getChannels(this.field_145850_b);
        DRGeneratorNetwork.Network network = channels.getChannel(this.networkID);
        if (network == null) {
            return;
        }
        int maxSupportedRF = network.getGeneratorBlocks() * GeneratorConfiguration.maxRFInputPerBlock;
        for (Coordinate crystal : this.crystals) {
            ResonatingCrystalTileEntity resonatingCrystalTileEntity;
            TileEntity te = this.field_145850_b.func_147438_o(crystal.getX(), crystal.getY(), crystal.getZ());
            if (!(te instanceof ResonatingCrystalTileEntity) || !((resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)te).getPower() > 1.0E-5f)) continue;
            maxSupportedRF -= resonatingCrystalTileEntity.getRfPerTick();
        }
        if (this.addCrystal(x, y, z, network, this.crystals, this.crystals, maxSupportedRF) >= 0) {
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private int addCrystal(int x, int y, int z, DRGeneratorNetwork.Network network, Set<Coordinate> newCrystals, Set<Coordinate> oldCrystals, int maxSupportedRF) {
        int maxSupportedCrystals = network.getGeneratorBlocks() * GeneratorConfiguration.maxCrystalsPerBlock;
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)te;
            if (resonatingCrystalTileEntity.getPower() > 1.0E-5f) {
                Coordinate crystalCoordinate = new Coordinate(x - this.field_145851_c, y - this.field_145848_d, z - this.field_145849_e);
                if (resonatingCrystalTileEntity.isGlowing() && !oldCrystals.contains(crystalCoordinate)) {
                    return maxSupportedRF;
                }
                if (newCrystals.size() >= maxSupportedCrystals) {
                    resonatingCrystalTileEntity.setGlowing(false);
                    return ERROR_TOOMANYCRYSTALS;
                }
                if (resonatingCrystalTileEntity.getRfPerTick() > maxSupportedRF) {
                    resonatingCrystalTileEntity.setGlowing(false);
                    return ERROR_TOOMUCHPOWER;
                }
                maxSupportedRF -= resonatingCrystalTileEntity.getRfPerTick();
                newCrystals.add(crystalCoordinate);
                resonatingCrystalTileEntity.setGlowing(this.lasersActive);
            } else {
                resonatingCrystalTileEntity.setGlowing(false);
            }
        }
        return maxSupportedRF;
    }

    private void findCrystals(DRGeneratorNetwork.Network network) {
        HashSet<Coordinate> newCrystals = new HashSet<Coordinate>();
        int maxSupportedRF = network.getGeneratorBlocks() * GeneratorConfiguration.maxRFInputPerBlock;
        boolean tooManyCrystals = false;
        boolean tooMuchPower = false;
        for (int y = this.field_145848_d - ConfigMachines.Collector.maxVerticalCrystalDistance; y <= this.field_145848_d + ConfigMachines.Collector.maxVerticalCrystalDistance; ++y) {
            if (y < 0 || y >= this.field_145850_b.func_72800_K()) continue;
            int maxhordist = ConfigMachines.Collector.maxHorizontalCrystalDistance;
            for (int x = this.field_145851_c - maxhordist; x <= this.field_145851_c + maxhordist; ++x) {
                for (int z = this.field_145849_e - maxhordist; z <= this.field_145849_e + maxhordist; ++z) {
                    if (this.field_145850_b.func_147439_a(x, y, z) != ModBlocks.resonatingCrystalBlock) continue;
                    if ((maxSupportedRF = this.addCrystal(x, y, z, network, newCrystals, this.crystals, maxSupportedRF)) == ERROR_TOOMANYCRYSTALS) {
                        tooManyCrystals = true;
                        continue;
                    }
                    if (maxSupportedRF != ERROR_TOOMUCHPOWER) continue;
                    tooMuchPower = true;
                }
            }
        }
        if (!((Object)newCrystals).equals(this.crystals)) {
            this.crystals = newCrystals;
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.lasersActive && (tooManyCrystals || tooMuchPower)) {
            if (tooManyCrystals) {
                Broadcaster.broadcast(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, "There are too many crystals for this size generator!", 100.0f);
            }
            if (tooMuchPower) {
                Broadcaster.broadcast(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, "Some crystals are too powerful for this size generator!!", 100.0f);
            }
        }
    }

    public Set<Coordinate> getCrystals() {
        return this.crystals;
    }

    public boolean areLasersActive() {
        return this.lasersActive;
    }

    public int getLaserStartup() {
        return this.laserStartup;
    }

    public int getNetworkID() {
        return this.networkID;
    }

    public void setNetworkID(int networkID) {
        this.networkID = networkID;
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        byte[] crystalX = tagCompound.func_74770_j("crystalsX");
        byte[] crystalY = tagCompound.func_74770_j("crystalsY");
        byte[] crystalZ = tagCompound.func_74770_j("crystalsZ");
        this.crystals.clear();
        for (int i = 0; i < crystalX.length; ++i) {
            this.crystals.add(new Coordinate((int)crystalX[i], (int)crystalY[i], (int)crystalZ[i]));
        }
        this.lasersActive = tagCompound.func_74767_n("lasersActive");
        this.laserStartup = tagCompound.func_74762_e("laserStartup");
        this.networkID = tagCompound.func_74764_b("networkId") ? tagCompound.func_74762_e("networkId") : -1;
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        byte[] crystalX = new byte[this.crystals.size()];
        byte[] crystalY = new byte[this.crystals.size()];
        byte[] crystalZ = new byte[this.crystals.size()];
        int i = 0;
        for (Coordinate crystal : this.crystals) {
            crystalX[i] = (byte)crystal.getX();
            crystalY[i] = (byte)crystal.getY();
            crystalZ[i] = (byte)crystal.getZ();
            ++i;
        }
        tagCompound.func_74773_a("crystalsX", crystalX);
        tagCompound.func_74773_a("crystalsY", crystalY);
        tagCompound.func_74773_a("crystalsZ", crystalZ);
        tagCompound.func_74757_a("lasersActive", this.lasersActive);
        tagCompound.func_74768_a("laserStartup", this.laserStartup);
        tagCompound.func_74768_a("networkId", this.networkID);
    }

    public boolean shouldRenderInPass(int pass) {
        EnergyCollectorTESR.currentPass = pass;
        return pass == 0 || pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 7), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - 7), (double)(this.field_145851_c + 8), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 8));
    }
}

