/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import sonar.core.network.PacketCoords;
import sonar.core.network.PacketCoordsHandler;
import sonar.core.utils.BlockInteraction;
import sonar.core.utils.IInteractBlock;

public class PacketBlockInteraction
extends PacketCoords {
    public BlockInteraction interact;

    public PacketBlockInteraction() {
    }

    public PacketBlockInteraction(int x, int y, int z, BlockInteraction interact) {
        super(x, y, z);
        this.interact = interact;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.interact = BlockInteraction.readFromBuf(buf);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        this.interact.writeToBuf(buf);
    }

    public static class Handler
    extends PacketCoordsHandler<PacketBlockInteraction> {
        @Override
        public IMessage processMessage(PacketBlockInteraction message, World world, EntityPlayer player) {
            Block target;
            if (!world.field_72995_K && (target = world.func_147439_a(message.xCoord, message.yCoord, message.zCoord)) != null && target instanceof IInteractBlock) {
                IInteractBlock interact = (IInteractBlock)target;
                interact.operateBlock(world, message.xCoord, message.yCoord, message.zCoord, player, message.interact);
            }
            return null;
        }
    }
}

