/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.inventories;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import cpw.mods.fml.common.Loader;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.ActionType;
import sonar.core.api.InventoryHandler;
import sonar.core.api.SonarAPI;
import sonar.core.api.StoredItemStack;

public class DrawersInventoryProvider
extends InventoryHandler {
    public static String name = "Storage Drawers";

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean canHandleItems(TileEntity tile, ForgeDirection dir) {
        return tile instanceof IDrawerGroup;
    }

    @Override
    public StoredItemStack getStack(int slot, TileEntity tile, ForgeDirection dir) {
        IDrawerGroup drawers;
        if (tile instanceof IDrawerGroup && slot < (drawers = (IDrawerGroup)tile).getDrawerCount()) {
            IDrawer draw = drawers.getDrawer(slot);
            ItemStack item = draw.getStoredItemCopy();
            if (item != null) {
                return new StoredItemStack(item);
            }
            return null;
        }
        return null;
    }

    @Override
    public InventoryHandler.StorageSize getItems(List<StoredItemStack> storedStacks, TileEntity tile, ForgeDirection dir) {
        if (tile instanceof IDrawerGroup) {
            IDrawerGroup drawers = (IDrawerGroup)tile;
            long maxStorage = 0L;
            long stored = 0L;
            for (int i = 0; i < drawers.getDrawerCount(); ++i) {
                if (drawers.getDrawer(i) == null) continue;
                IDrawer draw = drawers.getDrawer(i);
                ItemStack item = draw.getStoredItemCopy();
                maxStorage += (long)draw.getMaxCapacity();
                stored += (long)draw.getStoredItemCount();
                if (item == null) continue;
                SonarAPI.getItemHelper().addStackToList(storedStacks, new StoredItemStack(item, draw.getStoredItemCount()));
            }
            return new InventoryHandler.StorageSize(stored, maxStorage);
        }
        return InventoryHandler.StorageSize.EMPTY;
    }

    @Override
    public boolean isLoadable() {
        return Loader.isModLoaded((String)"StorageDrawers");
    }

    private long injectItemsIntoDrawer(IDrawer drawer, long itemCount) {
        return itemCount;
    }

    @Override
    public StoredItemStack addStack(StoredItemStack add, TileEntity tile, ForgeDirection dir, ActionType action) {
        return add;
    }

    @Override
    public StoredItemStack removeStack(StoredItemStack remove, TileEntity tile, ForgeDirection dir, ActionType action) {
        return remove;
    }
}

