/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.blocks.BlocksCommonProxy;
import am2.entities.EntityThrownRock;
import am2.items.ItemsCommonProxy;
import am2.spell.SpellUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class FallingStar
implements ISpellComponent {
    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[5];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.essence, 1, 0);
        objectArray[1] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 2);
        objectArray[2] = new ItemStack((Item)ItemsCommonProxy.essence, 1, 0);
        objectArray[3] = BlocksCommonProxy.manaBattery;
        objectArray[4] = Items.field_151129_at;
        return objectArray;
    }

    @Override
    public int getID() {
        return 65;
    }

    private boolean spawnStar(ItemStack spellStack, EntityLivingBase caster, Entity target, World world, double x, double y, double z) {
        List rocks = world.func_72872_a(EntityThrownRock.class, AxisAlignedBB.func_72330_a((double)(x - 10.0), (double)(y - 10.0), (double)(z - 10.0), (double)(x + 10.0), (double)(y + 10.0), (double)(z + 10.0)));
        int damageMultitplier = SpellUtils.instance.getModifiedInt_Mul(15, spellStack, caster, target, world, 0, SpellModifiers.DAMAGE);
        for (EntityThrownRock rock : rocks) {
            if (!rock.getIsShootingStar()) continue;
            return false;
        }
        if (!world.field_72995_K) {
            EntityThrownRock star = new EntityThrownRock(world);
            star.func_70107_b(x, world.func_72940_L(), z);
            star.setShootingStar(2 * damageMultitplier);
            star.setThrowingEntity(caster);
            star.setSpellStack(spellStack.func_77946_l());
            world.func_72838_d((Entity)star);
        }
        return true;
    }

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return this.spawnStar(stack, caster, (Entity)caster, world, impactX, impactY + 50.0, impactZ);
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        return this.spawnStar(stack, caster, target, world, target.field_70165_t, target.field_70163_u + 50.0, target.field_70161_v);
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 400.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return 120.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.ARCANE);
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.05f;
    }
}

