/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities;

import am2.AMCore;
import am2.api.blocks.IKeystoneLockable;
import am2.api.power.PowerTypes;
import am2.api.spell.component.interfaces.ISkillTreeEntry;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.component.interfaces.ISpellModifier;
import am2.api.spell.component.interfaces.ISpellPart;
import am2.api.spell.component.interfaces.ISpellShape;
import am2.blocks.tileentities.TileEntityAMPower;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleHoldPosition;
import am2.power.PowerNodeRegistry;
import am2.spell.SkillManager;
import am2.spell.SpellUtils;
import am2.spell.components.Summon;
import am2.spell.shapes.Binding;
import am2.utility.InventoryUtilities;
import am2.utility.RecipeUtilities;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityArcaneDeconstructor
extends TileEntityAMPower
implements IInventory,
ISidedInventory,
IKeystoneLockable {
    private int particleCounter;
    private static final float DECONSTRUCTION_POWER_COST = 1.25f;
    private static final int DECONSTRUCTION_TIME = 200;
    private int current_deconstruction_time = 0;
    private static final PowerTypes[] validPowerTypes = new PowerTypes[]{PowerTypes.DARK};
    @SideOnly(value=Side.CLIENT)
    AMParticle radiant;
    private ItemStack[] inventory = new ItemStack[this.func_70302_i_()];
    private ItemStack[] deconstructionRecipe;

    public TileEntityArcaneDeconstructor() {
        super(500);
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }

    @Override
    public int getChargeRate() {
        return 250;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            if (this.particleCounter == 0 || this.particleCounter++ > 1000) {
                this.particleCounter = 1;
                this.radiant = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_145850_b, "radiant", (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 0.5f, (float)this.field_145849_e + 0.5f));
                if (this.radiant != null) {
                    this.radiant.setMaxAge(1000);
                    this.radiant.setRGBColorF(0.1f, 0.1f, 0.1f);
                    this.radiant.setParticleScale(0.1f);
                    this.radiant.AddParticleController(new ParticleHoldPosition(this.radiant, 1000, 1, false));
                }
            }
        } else if (!this.isActive()) {
            if (this.inventory[0] != null) {
                this.current_deconstruction_time = 1;
            }
        } else if (this.inventory[0] == null) {
            this.current_deconstruction_time = 0;
            this.deconstructionRecipe = null;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (PowerNodeRegistry.For(this.field_145850_b).checkPower(this, PowerTypes.DARK, 1.25f)) {
            if (this.deconstructionRecipe == null) {
                if (!this.getDeconstructionRecipe()) {
                    this.transferOrEjectItem(this.inventory[0]);
                    this.func_70299_a(0, null);
                }
            } else {
                if (this.current_deconstruction_time++ >= 200) {
                    if (this.getDeconstructionRecipe()) {
                        for (ItemStack stack : this.deconstructionRecipe) {
                            this.transferOrEjectItem(stack);
                        }
                    }
                    this.deconstructionRecipe = null;
                    this.func_70298_a(0, 1);
                    this.current_deconstruction_time = 0;
                }
                if (this.current_deconstruction_time % 10 == 0) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
            PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerTypes.DARK, 1.25f);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean getDeconstructionRecipe() {
        ItemStack checkStack = this.func_70301_a(0);
        ArrayList<ItemStack> recipeItems = new ArrayList<ItemStack>();
        if (checkStack == null) {
            return false;
        }
        if (checkStack.func_77973_b() == ItemsCommonProxy.spell) {
            ItemStack stack;
            int numStages = SpellUtils.instance.numStages(checkStack);
            for (int i = 0; i < numStages; ++i) {
                ISpellModifier[] modifiers;
                ISpellComponent[] iSpellComponentArray;
                ISpellShape shape = SpellUtils.instance.getShapeForStage(checkStack, i);
                Object[] componentParts = shape.getRecipeItems();
                if (componentParts != null) {
                    for (Object o : componentParts) {
                        ItemStack stack2 = this.objectToItemStack(o);
                        if (stack2 == null) continue;
                        if (stack2.func_77973_b() == ItemsCommonProxy.bindingCatalyst) {
                            stack2.func_77964_b(((Binding)SkillManager.instance.getSkill("Binding")).getBindingType(checkStack));
                        }
                        recipeItems.add(stack2.func_77946_l());
                    }
                }
                for (ISpellComponent component : iSpellComponentArray = SpellUtils.instance.getComponentsForStage(checkStack, i)) {
                    componentParts = component.getRecipeItems();
                    if (componentParts == null) continue;
                    for (Object o : componentParts) {
                        ItemStack stack3 = this.objectToItemStack(o);
                        if (stack3 == null) continue;
                        if (stack3.func_77973_b() == ItemsCommonProxy.crystalPhylactery) {
                            ItemsCommonProxy.crystalPhylactery.setSpawnClass(stack3, ((Summon)SkillManager.instance.getSkill("Summon")).getSummonType(checkStack));
                            ItemsCommonProxy.crystalPhylactery.addFill(stack3, 100.0f);
                        }
                        recipeItems.add(stack3.func_77946_l());
                    }
                }
                for (ISpellModifier modifier : modifiers = SpellUtils.instance.getModifiersForStage(checkStack, i)) {
                    componentParts = modifier.getRecipeItems();
                    if (componentParts == null) continue;
                    for (Object o : componentParts) {
                        stack = this.objectToItemStack(o);
                        if (stack == null) continue;
                        recipeItems.add(stack.func_77946_l());
                    }
                }
            }
            int numShapeGroups = SpellUtils.instance.numShapeGroups(checkStack);
            for (int i = 0; i < numShapeGroups; ++i) {
                int[] parts;
                for (int partID : parts = SpellUtils.instance.getShapeGroupParts(checkStack, i)) {
                    Object[] componentParts;
                    ISkillTreeEntry entry = SkillManager.instance.getSkill(partID);
                    if (entry == null || !(entry instanceof ISpellPart) || (componentParts = ((ISpellPart)entry).getRecipeItems()) == null) continue;
                    for (Object o : componentParts) {
                        stack = this.objectToItemStack(o);
                        if (stack == null) continue;
                        if (stack.func_77973_b() == ItemsCommonProxy.bindingCatalyst) {
                            stack.func_77964_b(((Binding)SkillManager.instance.getSkill("Binding")).getBindingType(checkStack));
                        }
                        recipeItems.add(stack.func_77946_l());
                    }
                }
            }
            this.deconstructionRecipe = recipeItems.toArray(new ItemStack[recipeItems.size()]);
            return true;
        }
        IRecipe recipe = RecipeUtilities.getRecipeFor(checkStack);
        if (recipe == null) {
            return false;
        }
        Object[] recipeParts = RecipeUtilities.getRecipeItems(recipe);
        if (recipeParts != null && checkStack != null && recipe.func_77571_b() != null) {
            void var7_18;
            if (recipe.func_77571_b().func_77973_b() == checkStack.func_77973_b() && recipe.func_77571_b().func_77960_j() == checkStack.func_77960_j() && recipe.func_77571_b().field_77994_a > 1) {
                return false;
            }
            Object[] objectArray = recipeParts;
            int n = objectArray.length;
            boolean bl = false;
            while (var7_18 < n) {
                Object o = objectArray[var7_18];
                ItemStack stack = this.objectToItemStack(o);
                if (stack != null && !stack.func_77973_b().hasContainerItem(stack)) {
                    stack.field_77994_a = 1;
                    recipeItems.add(stack.func_77946_l());
                }
                ++var7_18;
            }
        }
        this.deconstructionRecipe = recipeItems.toArray(new ItemStack[recipeItems.size()]);
        return true;
    }

    private ItemStack objectToItemStack(Object o) {
        ItemStack output = null;
        if (o instanceof ItemStack) {
            output = (ItemStack)o;
        } else if (o instanceof Item) {
            output = new ItemStack((Item)o);
        } else if (o instanceof Block) {
            output = new ItemStack((Block)o);
        } else if (o instanceof ArrayList) {
            output = this.objectToItemStack(((ArrayList)o).get(0));
        }
        if (output != null && output.field_77994_a == 0) {
            output.field_77994_a = 1;
        }
        return output;
    }

    private void transferOrEjectItem(ItemStack stack) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean eject = false;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    TileEntity te;
                    if (i == 0 && j == 0 && k == 0 || (te = this.field_145850_b.func_147438_o(this.field_145851_c + i, this.field_145848_d + j, this.field_145849_e + k)) == null || !(te instanceof IInventory)) continue;
                    for (int side = 0; side < 6; ++side) {
                        if (!InventoryUtilities.mergeIntoInventory((IInventory)te, stack, stack.field_77994_a, side)) continue;
                        return;
                    }
                }
            }
        }
        EntityItem item = new EntityItem(this.field_145850_b);
        item.func_70107_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5);
        item.func_92058_a(stack);
        this.field_145850_b.func_72838_d((Entity)item);
    }

    public boolean isActive() {
        return this.current_deconstruction_time > 0;
    }

    public int func_70302_i_() {
        return 16;
    }

    public ItemStack func_70301_a(int var1) {
        if (var1 >= this.inventory.length) {
            return null;
        }
        return this.inventory[var1];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventory[i] != null) {
            if (this.inventory[i].field_77994_a <= j) {
                ItemStack itemstack = this.inventory[i];
                this.inventory[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.inventory[i].func_77979_a(j);
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.inventory[i] != null) {
            ItemStack itemstack = this.inventory[i];
            this.inventory[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "ArcaneDeconstructor";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i <= 9;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return i == 0;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i >= 1 && i <= 9;
    }

    @Override
    public ItemStack[] getRunesInKey() {
        return new ItemStack[]{this.inventory[13], this.inventory[14], this.inventory[15]};
    }

    @Override
    public boolean keystoneMustBeHeld() {
        return false;
    }

    @Override
    public boolean keystoneMustBeInActionBar() {
        return false;
    }

    @Override
    public PowerTypes[] getValidPowerTypes() {
        return validPowerTypes;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("DeconstructorInventory", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c(tag);
            if (byte0 < 0 || byte0 >= this.inventory.length) continue;
            this.inventory[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.current_deconstruction_time = nbttagcompound.func_74762_e("DeconstructionTime");
        if (this.current_deconstruction_time > 0) {
            this.getDeconstructionRecipe();
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a(tag, (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("DeconstructorInventory", (NBTBase)nbttaglist);
        nbttagcompound.func_74768_a("DeconstructionTime", this.current_deconstruction_time);
    }

    public int getProgressScaled(int i) {
        return this.current_deconstruction_time * i / 200;
    }
}

