/*
 * Decompiled with CFR 0.152.
 */
package ru.fewizz.idextender;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import ru.fewizz.idextender.IEConfig;

public class Hooks {
    public static byte[] getBlockData(ExtendedBlockStorage ebs) {
        short[] data = Hooks.get(ebs);
        byte[] ret = new byte[data.length * 2];
        ByteBuffer.wrap(ret).asShortBuffer().put(data);
        return ret;
    }

    public static void setBlockData(ExtendedBlockStorage ebs, byte[] data, int offset) {
        ShortBuffer.wrap(Hooks.get(ebs)).put(ByteBuffer.wrap(data, offset, 8192).asShortBuffer());
    }

    public static void writeChunkToNbt(NBTTagCompound nbt, ExtendedBlockStorage ebs) {
        nbt.func_74773_a("Blocks16", Hooks.getBlockData(ebs));
        if (IEConfig.postNeidWorldsSupport) {
            short[] data = Hooks.get(ebs);
            byte[] lsbData = new byte[data.length];
            byte[] msbData = null;
            for (int i = 0; i < data.length; ++i) {
                int id = data[i] & 0xFFFF;
                if (id <= 255) {
                    lsbData[i] = (byte)id;
                    continue;
                }
                if (id > 4095) continue;
                if (msbData == null) {
                    msbData = new byte[data.length / 2];
                }
                lsbData[i] = (byte)id;
                if (i % 2 == 0) {
                    int n = i / 2;
                    msbData[n] = (byte)(msbData[n] | id >>> 8 & 0xF);
                    continue;
                }
                int n = i / 2;
                msbData[n] = (byte)(msbData[n] | id >>> 4 & 0xF0);
            }
            nbt.func_74773_a("Blocks", lsbData);
            if (msbData != null) {
                nbt.func_74773_a("Add", msbData);
            }
        }
    }

    public static void readChunkFromNbt(ExtendedBlockStorage ebs, NBTTagCompound nbt) {
        if (nbt.func_74764_b("Blocks16")) {
            Hooks.setBlockData(ebs, nbt.func_74770_j("Blocks16"), 0);
        } else if (nbt.func_74764_b("Blocks")) {
            short[] out = Hooks.get(ebs);
            byte[] lsbData = nbt.func_74770_j("Blocks");
            if (nbt.func_74764_b("Add")) {
                byte[] msbData = nbt.func_74770_j("Add");
                for (int i = 0; i < out.length; i += 2) {
                    byte msPart = msbData[i / 2];
                    out[i] = (short)(lsbData[i] & 0xFF | (msPart & 0xF) << 8);
                    out[i + 1] = (short)(lsbData[i + 1] & 0xFF | (msPart & 0xF0) << 4);
                }
            } else {
                for (int i = 0; i < out.length; ++i) {
                    out[i] = (short)(lsbData[i] & 0xFF);
                }
            }
        } else assert (false);
    }

    public static int getBlockId(ExtendedBlockStorage ebs, int x, int y, int z) {
        return Hooks.get(ebs)[y << 8 | z << 4 | x] & 0xFFFF;
    }

    public static Block getBlock(ExtendedBlockStorage ebs, int x, int y, int z) {
        return Block.func_149729_e((int)Hooks.getBlockId(ebs, x, y, z));
    }

    public static void setBlockId(ExtendedBlockStorage ebs, int x, int y, int z, int id) {
        Hooks.get((ExtendedBlockStorage)ebs)[y << 8 | z << 4 | x] = (short)id;
    }

    public static short[] create16BArray() {
        return new short[4096];
    }

    public static short[] get(ExtendedBlockStorage ebs) {
        return null;
    }

    public static void setTickRefCount(ExtendedBlockStorage ebs, int value) {
    }

    public static void setBlockRefCount(ExtendedBlockStorage ebs, int value) {
    }

    public static void removeInvalidBlocksHook(ExtendedBlockStorage ebs) {
        short[] blkIds = Hooks.get(ebs);
        int cntNonEmpty = 0;
        int cntTicking = 0;
        for (int off = 0; off < blkIds.length; ++off) {
            int id = blkIds[off] & 0xFFFF;
            if (id <= 0) continue;
            Block block = (Block)Block.field_149771_c.func_148754_a(id);
            if (block == null) {
                if (!IEConfig.removeInvalidBlocks) continue;
                blkIds[off] = 0;
                continue;
            }
            if (block == Blocks.field_150350_a) continue;
            ++cntNonEmpty;
            if (!block.func_149653_t()) continue;
            ++cntTicking;
        }
        Hooks.setBlockRefCount(ebs, cntNonEmpty);
        Hooks.setTickRefCount(ebs, cntTicking);
    }

    public static int getIdFromBlockWithCheck(Block block, Block oldBlock) {
        int id = Block.func_149682_b((Block)block);
        if (IEConfig.catchUnregisteredBlocks && id == -1) {
            throw new IllegalArgumentException("Block " + block + " is not registered. <-- Say about this to the author of this mod, or you can try to enable \"RemoveInvalidBlocks\" option in NEID config.");
        }
        if (id < 0 || id > Short.MAX_VALUE) {
            if (id == -1) {
                return Block.func_149682_b((Block)oldBlock);
            }
            throw new IllegalArgumentException("id out of range: " + id);
        }
        return id;
    }
}

