/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.network;

import com.rwtema.funkylocomotion.network.MessageClearTile;
import com.rwtema.funkylocomotion.network.MessageObstruction;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import framesapi.BlockPos;
import java.util.WeakHashMap;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class FLNetwork {
    public static SimpleNetworkWrapper net;
    private static final WeakHashMap<World, PlayerManager> cache;

    public static void init() {
        net = new SimpleNetworkWrapper("FLoco");
        net.registerMessage(MessageClearTile.Handler.class, MessageClearTile.class, 0, Side.SERVER);
        net.registerMessage(MessageClearTile.Handler.class, MessageClearTile.class, 0, Side.CLIENT);
        net.registerMessage(MessageObstruction.Handler.class, MessageObstruction.class, 1, Side.SERVER);
        net.registerMessage(MessageObstruction.Handler.class, MessageObstruction.class, 1, Side.CLIENT);
    }

    public static void sendToAllWatchingChunk(World world, int x, int y, int z, IMessage message) {
        PlayerManager.PlayerInstance watcher = FLNetwork.getChunkWatcher(world, x, z);
        if (watcher != null) {
            watcher.func_151251_a(net.getPacketFrom(message));
        }
    }

    private static PlayerManager getPlayerManager(World world) {
        if (!cache.containsKey(world)) {
            if (!(world instanceof WorldServer)) {
                cache.put(world, null);
            } else {
                cache.put(world, ((WorldServer)world).func_73040_p());
            }
        }
        return cache.get(world);
    }

    public static void updateChunk(Chunk chunk) {
        World world = chunk.field_76637_e;
        PlayerManager.PlayerInstance watcher = FLNetwork.getChunkWatcher(chunk, world);
        if (watcher != null) {
            watcher.func_73254_a();
        }
    }

    public static PlayerManager.PlayerInstance getChunkWatcher(Chunk chunk) {
        return FLNetwork.getChunkWatcher(chunk, chunk.field_76637_e);
    }

    public static PlayerManager.PlayerInstance getChunkWatcher(Chunk chunk, World world) {
        PlayerManager playerManager = FLNetwork.getPlayerManager(world);
        return playerManager != null ? playerManager.func_72690_a(chunk.field_76635_g, chunk.field_76647_h, false) : null;
    }

    public static PlayerManager.PlayerInstance getChunkWatcher(World world, BlockPos pos) {
        return FLNetwork.getChunkWatcher(world, pos.x, pos.z);
    }

    public static PlayerManager.PlayerInstance getChunkWatcher(World world, int x, int z) {
        PlayerManager playerManager = FLNetwork.getPlayerManager(world);
        return playerManager != null ? playerManager.func_72690_a(x >> 4, z >> 4, false) : null;
    }

    static {
        cache = new WeakHashMap();
    }
}

