/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.blocks;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import com.rwtema.funkylocomotion.FunkyLocomotion;
import com.rwtema.funkylocomotion.blocks.TileBooster;
import com.rwtema.funkylocomotion.helper.BlockHelper;
import com.rwtema.funkylocomotion.movers.IMover;
import com.rwtema.funkylocomotion.movers.MoveManager;
import com.rwtema.funkylocomotion.particles.ObstructionHelper;
import com.rwtema.funkylocomotion.proxydelegates.ProxyRegistry;
import framesapi.BlockPos;
import framesapi.IStickyBlock;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TilePusher
extends TileEntity
implements IEnergyHandler,
IMover {
    public static int maxTiles = 256;
    public static int powerPerTile = 1000;
    public final EnergyStorage energy = new EnergyStorage(maxTiles * powerPerTile);
    public boolean powered;
    public static final int[] moveTime = new int[]{20, 10, 7, 5, 4, 3};

    public boolean canUpdate() {
        return false;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.energy.readFromNBT(tag);
        this.powered = tag.func_74767_n("Powered");
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.energy.writeToNBT(tag);
        tag.func_74757_a("powered", this.powered);
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldBlock != newBlock;
    }

    public List<BlockPos> getBlocks(World world, BlockPos home, ForgeDirection dir, boolean push) {
        BlockPos advance = home.advance(dir);
        if (push) {
            if (BlockHelper.canStick(world, advance, dir.getOpposite())) {
                return this.getBlocks(world, home, advance, dir);
            }
        } else {
            if (!world.func_147437_c(advance.x, advance.y, advance.z)) {
                return null;
            }
            if (BlockHelper.canStick(world, advance = advance.advance(dir), dir.getOpposite())) {
                return this.getBlocks(world, home, advance, dir.getOpposite());
            }
        }
        return null;
    }

    public List<BlockPos> getBlocks(World world, BlockPos home, BlockPos start, ForgeDirection moveDir) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        HashSet<BlockPos> posSet = new HashSet<BlockPos>();
        ArrayList<BlockPos> toIterate = new ArrayList<BlockPos>();
        HashSet<BlockPos> toIterateSet = new HashSet<BlockPos>();
        toIterate.add(start);
        toIterateSet.add(start);
        for (int i = 0; i < toIterate.size(); ++i) {
            BlockPos pos = (BlockPos)toIterate.get(i);
            posList.add(pos);
            posSet.add(pos);
            Block b = BlockHelper.getBlock(world, pos);
            IStickyBlock stickyBlock = ProxyRegistry.getInterface(b, IStickyBlock.class);
            if (stickyBlock == null) continue;
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                BlockPos newPos;
                if (!stickyBlock.isStickySide(world, pos.x, pos.y, pos.z, side) || home.equals(newPos = pos.advance(side)) || toIterateSet.contains(newPos) || !BlockHelper.canStick(world, newPos, side.getOpposite())) continue;
                toIterate.add(newPos);
                toIterateSet.add(newPos);
            }
        }
        boolean fail = false;
        for (BlockPos pos : posList) {
            BlockPos adv = pos.advance(moveDir);
            if (posSet.contains(adv) || BlockHelper.canReplace(world, adv)) continue;
            if (!ObstructionHelper.sendObstructionPacket(world, pos, moveDir)) {
                return null;
            }
            fail = true;
        }
        return fail ? null : posList;
    }

    @Override
    public void startMoving() {
        boolean push;
        int meta = this.func_145832_p();
        ForgeDirection dir = ForgeDirection.getOrientation((int)(meta % 6)).getOpposite();
        boolean bl = push = meta < 6;
        if (dir == ForgeDirection.UNKNOWN) {
            return;
        }
        BlockPos pos = new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        List<BlockPos> posList = this.getBlocks(this.field_145850_b, pos, dir, push);
        if (posList != null) {
            int energy = posList.size() * powerPerTile;
            if (this.energy.extractEnergy(energy, true) != energy) {
                return;
            }
            ArrayList<TileBooster> boosters = new ArrayList<TileBooster>(6);
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile;
                BlockPos p;
                if (d == dir || BlockHelper.getBlock(this.field_145850_b, p = pos.advance(d)) != FunkyLocomotion.booster || ForgeDirection.getOrientation((int)(BlockHelper.getMeta(this.field_145850_b, p) % 6)) != d || !((tile = BlockHelper.getTile(this.field_145850_b, p)) instanceof TileBooster)) continue;
                TileBooster booster = (TileBooster)tile;
                if (booster.energy.extractEnergy(energy, true) != energy) {
                    return;
                }
                boosters.add(booster);
            }
            if (!boosters.isEmpty()) {
                for (TileBooster booster : boosters) {
                    booster.energy.extractEnergy(energy, false);
                }
            }
            this.energy.extractEnergy(energy, false);
            MoveManager.startMoving(this.field_145850_b, posList, this.getDirection(), moveTime[boosters.size()]);
        }
    }

    @Override
    public boolean stillExists() {
        return !this.field_145846_f && this.field_145850_b != null && this.field_145850_b.func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    public void onChunkUnload() {
        this.field_145846_f = true;
    }

    public ForgeDirection getDirection() {
        int meta = this.func_145832_p();
        ForgeDirection dir = ForgeDirection.getOrientation((int)(meta % 6)).getOpposite();
        boolean push = meta < 6;
        return push ? dir : dir.getOpposite();
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energy.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energy.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energy.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }
}

