/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.util.inventory;

import com.mordenkainen.equivalentenergistics.util.CommonUtils;
import com.mordenkainen.equivalentenergistics.util.inventory.InventoryAdapter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public final class InvUtils {
    private InvUtils() {
    }

    public static List<ItemStack> getInvAsList(IInventory inv) {
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack item = inv.func_70301_a(slot);
            if (item == null) continue;
            output.add(item);
        }
        return output;
    }

    public static boolean isFull(IInventory inv) {
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack stackInSlot = inv.func_70301_a(slot);
            if (stackInSlot != null && stackInSlot.field_77994_a == stackInSlot.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(IInventory inv) {
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack stackInSlot = inv.func_70301_a(slot);
            if (stackInSlot == null) continue;
            return false;
        }
        return true;
    }

    public static int extractWithCount(ForgeDirection side, IInventory dest, IInventory src, int count) {
        int leftToMove = count;
        ISidedInventory srcSidedIv = InventoryAdapter.getAdapter(src);
        block0: for (int i = 0; i < dest.func_70302_i_() && leftToMove > 0; ++i) {
            ItemStack destStack = dest.func_70301_a(i);
            if (destStack != null && (!destStack.func_77985_e() || destStack.field_77994_a >= destStack.func_77976_d())) continue;
            for (int slot : srcSidedIv.func_94128_d(side.ordinal())) {
                ItemStack srcStack = srcSidedIv.func_70301_a(slot);
                if (srcStack == null || !CommonUtils.willItemsStack(destStack, srcStack) || !srcSidedIv.func_102008_b(slot, srcStack, side.getOpposite().ordinal())) continue;
                int toMove = 0;
                if (destStack == null) {
                    toMove = Math.min(leftToMove, srcStack.field_77994_a);
                    dest.func_70299_a(i, new ItemStack(srcStack.func_77973_b(), toMove, srcStack.func_77960_j()));
                } else {
                    toMove = Math.min(leftToMove, Math.min(srcStack.field_77994_a, destStack.func_77976_d() - destStack.field_77994_a));
                    destStack.field_77994_a += toMove;
                }
                srcStack.field_77994_a -= toMove;
                if (srcStack.field_77994_a <= 0) {
                    srcSidedIv.func_70299_a(slot, null);
                }
                if ((leftToMove -= toMove) <= 0) continue block0;
            }
        }
        return count - leftToMove;
    }

    public static int ejectStack(ItemStack stack, IInventory destInv, ForgeDirection side, int maxItems) {
        int remainingItems = maxItems;
        ItemStack sourceStack = stack.func_77946_l();
        ISidedInventory inv = InventoryAdapter.getAdapter(destInv);
        for (int slot : inv.func_94128_d(side.ordinal())) {
            if (inv.func_102007_a(slot, sourceStack, side.ordinal())) {
                int toMove;
                ItemStack destStack = inv.func_70301_a(slot);
                if (destStack == null) {
                    toMove = Math.min(sourceStack.field_77994_a, remainingItems);
                    destStack = sourceStack.func_77946_l();
                    destStack.field_77994_a = toMove;
                    sourceStack.field_77994_a -= toMove;
                    remainingItems -= toMove;
                    inv.func_70299_a(slot, destStack);
                } else if (CommonUtils.isSameItem(destStack, sourceStack)) {
                    toMove = Math.min(Math.min(sourceStack.field_77994_a, destStack.func_77976_d() - destStack.field_77994_a), remainingItems);
                    destStack.field_77994_a += toMove;
                    sourceStack.field_77994_a -= toMove;
                    remainingItems -= toMove;
                    inv.func_70299_a(slot, destStack);
                }
            }
            if (remainingItems <= 0 || sourceStack.field_77994_a <= 0) break;
        }
        return maxItems - remainingItems;
    }
}

