/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.util;

import com.mordenkainen.equivalentenergistics.EquivalentEnergistics;
import com.mordenkainen.equivalentenergistics.core.config.ConfigManager;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class CommonUtils {
    private CommonUtils() {
    }

    public static boolean destroyAndDrop(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block != null && block.func_149712_f(world, x, y, z) >= 0.0f) {
            if (!world.field_72995_K) {
                block.func_149749_a(world, x, y, z, block, world.func_72805_g(x, y, z));
                ArrayList drops = block.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0);
                for (ItemStack stack : drops) {
                    CommonUtils.spawnEntItem(world, x, y, z, stack);
                }
            }
            world.func_147468_f(x, y, z);
            return true;
        }
        return false;
    }

    public static void spawnEntItem(World world, double x, double y, double z, ItemStack item) {
        if (world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots && item != null && item.field_77994_a > 0) {
            float rx = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float ry = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float rz = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, x + (double)rx, y + (double)ry, z + (double)rz, new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            entityItem.field_70159_w = world.field_73012_v.nextGaussian() * (double)0.05f;
            entityItem.field_70181_x = world.field_73012_v.nextGaussian() * (double)0.05f + 0.2000000029802322;
            entityItem.field_70179_y = world.field_73012_v.nextGaussian() * (double)0.05f;
            world.func_72838_d((Entity)entityItem);
        }
    }

    public static <T> T getTE(Class<T> type, IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        return (T)(type.isInstance(tile) ? tile : null);
    }

    public static String formatEMC(double emc) {
        double displayValue;
        String[] preFixes = new String[]{"K", "M", "B", "T", "P", "T", "P", "E", "Z", "Y"};
        String level = "";
        int offset = 0;
        for (displayValue = emc; displayValue > 1000.0 && offset < preFixes.length; displayValue /= 1000.0) {
            level = preFixes[offset++];
        }
        DecimalFormat formatter = new DecimalFormat("#.###");
        return formatter.format(displayValue) + ' ' + level;
    }

    public static ItemStack filterForEmpty(ItemStack stack) {
        return stack.field_77994_a <= 0 ? null : stack;
    }

    public static boolean willItemsStack(ItemStack dest, ItemStack src) {
        if (dest == null && src != null) {
            return true;
        }
        return CommonUtils.isSameItem(dest, src);
    }

    public static boolean isSameItem(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77960_j() == stack2.func_77960_j() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static void debugLog(String message) {
        if (ConfigManager.debug) {
            EquivalentEnergistics.logger.debug(message);
        }
    }

    public static void debugLog(String message, Throwable t) {
        if (ConfigManager.debug) {
            EquivalentEnergistics.logger.debug(message, t);
        }
    }
}

