/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.items;

import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import com.mordenkainen.equivalentenergistics.EquivalentEnergistics;
import com.mordenkainen.equivalentenergistics.core.config.IConfigurable;
import com.mordenkainen.equivalentenergistics.core.textures.TextureEnum;
import com.mordenkainen.equivalentenergistics.integration.ae2.cells.HandlerEMCCellCreative;
import com.mordenkainen.equivalentenergistics.items.ItemEMCCellBase;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.config.Configuration;

public class ItemEMCCellCreative
extends ItemEMCCellBase
implements IConfigurable {
    private static final String GROUP = "Storage Cells";
    public static double capacity = 1.6384E10;

    public ItemEMCCellCreative() {
        super(1);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.epic;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return TextureEnum.EMCCELLCREATIVE.getTexture();
    }

    @Optional.Method(modid="appliedenergistics2")
    public IMEInventoryHandler getCellInventory(ItemStack stack, ISaveProvider host, StorageChannel channel) {
        if (channel == StorageChannel.ITEMS && this.isCell(stack)) {
            return new HandlerEMCCellCreative(host);
        }
        return null;
    }

    @Optional.Method(modid="appliedenergistics2")
    public int getStatusForCell(ItemStack is, IMEInventory handler) {
        return 1;
    }

    @Optional.Method(modid="appliedenergistics2")
    public double cellIdleDrain(ItemStack is, IMEInventory handler) {
        return 0.0;
    }

    @Override
    public void loadConfig(Configuration config) {
        try {
            capacity = Double.valueOf(config.get(GROUP, "Creative_Capacity", String.format("%.0f", capacity)).getString());
        }
        catch (NumberFormatException e) {
            EquivalentEnergistics.logger.warn("Creative Storage Cell Creative_Capacity configured for invalid value! Default will be used!");
        }
    }
}

