/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.integration.ae2.cells;

import appeng.api.storage.IMEInventory;
import appeng.api.storage.ISaveProvider;
import com.mordenkainen.equivalentenergistics.integration.ae2.cells.HandlerEMCCellBase;
import com.mordenkainen.equivalentenergistics.util.EMCPool;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class HandlerEMCCell
extends HandlerEMCCellBase {
    private static final String EMC_TAG = "emc";
    private final NBTTagCompound cellData;
    private final EMCPool pool = new EMCPool();

    public HandlerEMCCell(ItemStack storageStack, ISaveProvider saveProvider, double capacity) {
        super(saveProvider);
        if (!storageStack.func_77942_o()) {
            storageStack.func_77982_d(new NBTTagCompound());
        }
        this.pool.setMaxEMC(capacity);
        this.cellData = storageStack.func_77978_p();
        if (this.cellData.func_74764_b(EMC_TAG)) {
            this.pool.setCurrentEMC(this.cellData.func_74763_f(EMC_TAG));
        }
    }

    @Override
    public int getCellStatus() {
        if (this.pool.getCurrentEMC() >= this.pool.getMaxEMC()) {
            return 3;
        }
        if (this.pool.getCurrentEMC() >= this.pool.getMaxEMC() * 0.75) {
            return 2;
        }
        return 1;
    }

    @Override
    public double getCurrentEMC() {
        return this.pool.getCurrentEMC();
    }

    @Override
    public void setCurrentEMC(double currentEMC) {
    }

    @Override
    public double getMaxEMC() {
        return this.pool.getMaxEMC();
    }

    @Override
    public void setMaxEMC(double maxEMC) {
    }

    @Override
    public double getAvail() {
        return this.pool.getAvail();
    }

    @Override
    public boolean isFull() {
        return this.pool.isFull();
    }

    @Override
    public boolean isEmpty() {
        return this.pool.isEmpty();
    }

    @Override
    public double addEMC(double emc) {
        int oldStatus = this.getCellStatus();
        double added = this.pool.addEMC(emc);
        if (added > 0.0) {
            this.updateEMC();
            if (oldStatus != this.getCellStatus()) {
                this.updateProvider();
            }
        }
        return added;
    }

    @Override
    public double extractEMC(double emc) {
        int oldStatus = this.getCellStatus();
        double extracted = this.pool.extractEMC(emc);
        if (extracted > 0.0) {
            this.updateEMC();
            if (oldStatus != this.getCellStatus()) {
                this.updateProvider();
            }
        }
        return extracted;
    }

    private void updateEMC() {
        this.cellData.func_74780_a(EMC_TAG, this.pool.getCurrentEMC());
        if (this.saveProvider != null) {
            this.saveProvider.saveChanges((IMEInventory)this);
        }
    }

    private void updateProvider() {
        if (this.saveProvider instanceof TileEntity) {
            TileEntity tile = (TileEntity)this.saveProvider;
            tile.func_145831_w().func_147471_g(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        }
    }
}

