/*
 * Decompiled with CFR 0.152.
 */
package com.mordenkainen.equivalentenergistics.integration.ae2.cache.storage;

import appeng.api.config.Actionable;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.storage.ICellProvider;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import com.mordenkainen.equivalentenergistics.integration.ae2.cache.storage.EMCStorageGrid;
import com.mordenkainen.equivalentenergistics.integration.ae2.cells.HandlerEMCCellBase;
import com.mordenkainen.equivalentenergistics.util.CommonUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class EMCGridCellHandler {
    private static Field intHandler;
    private static Field extHandler;
    private final EMCStorageGrid hostGrid;
    private final List<ICellProvider> driveBays = new ArrayList<ICellProvider>();

    public EMCGridCellHandler(EMCStorageGrid hostGrid) {
        this.hostGrid = hostGrid;
    }

    public void addNode(IGridNode gridNode, IGridHost machine) {
        if (machine instanceof ICellProvider) {
            this.driveBays.add((ICellProvider)machine);
        }
    }

    public void cellUpdate(MENetworkCellArrayUpdate cellUpdate) {
        double newEMC = 0.0;
        double newMax = 0.0;
        for (ICellProvider provider : this.driveBays) {
            List cells = provider.getCellArray(StorageChannel.ITEMS);
            for (IMEInventoryHandler cell : cells) {
                HandlerEMCCellBase handler = this.getHandler((IMEInventoryHandler<IAEItemStack>)cell);
                if (handler == null) continue;
                newEMC += handler.getCurrentEMC();
                newMax += handler.getMaxEMC();
            }
        }
        this.updatePool(newMax, newEMC);
    }

    public void removeNode(IGridNode gridNode, IGridHost machine) {
        if (machine instanceof ICellProvider && this.driveBays.remove((ICellProvider)machine)) {
            double newEMC = this.hostGrid.getCurrentEMC();
            double newMax = this.hostGrid.getMaxEMC();
            List cells = ((ICellProvider)machine).getCellArray(StorageChannel.ITEMS);
            for (IMEInventoryHandler cell : cells) {
                HandlerEMCCellBase handler = this.getHandler((IMEInventoryHandler<IAEItemStack>)cell);
                if (handler == null) continue;
                newEMC -= handler.getCurrentEMC();
                newMax -= handler.getMaxEMC();
            }
            this.updatePool(newMax, newEMC);
        }
    }

    public double injectEMC(double emc, Actionable mode) {
        double toAdd = Math.min(emc, this.hostGrid.getAvail());
        if (mode != Actionable.MODULATE) {
            return toAdd;
        }
        double added = 0.0;
        block0: for (ICellProvider provider : this.driveBays) {
            List cells = provider.getCellArray(StorageChannel.ITEMS);
            for (IMEInventoryHandler cell : cells) {
                HandlerEMCCellBase handler = this.getHandler((IMEInventoryHandler<IAEItemStack>)cell);
                if (handler == null) continue;
                added += handler.addEMC(toAdd - added);
                this.hostGrid.markDirty();
                if (added != toAdd) continue;
                continue block0;
            }
        }
        this.hostGrid.addEMC(added);
        return added;
    }

    public double extractEMC(double emc, Actionable mode) {
        double toExtract = Math.min(emc, this.hostGrid.getCurrentEMC());
        if (mode != Actionable.MODULATE) {
            return toExtract;
        }
        double extracted = 0.0;
        block0: for (ICellProvider provider : this.driveBays) {
            List cells = provider.getCellArray(StorageChannel.ITEMS);
            for (IMEInventoryHandler cell : cells) {
                HandlerEMCCellBase handler = this.getHandler((IMEInventoryHandler<IAEItemStack>)cell);
                if (handler == null) continue;
                extracted += handler.extractEMC(toExtract - extracted);
                this.hostGrid.markDirty();
                if (extracted != toExtract) continue;
                continue block0;
            }
        }
        this.hostGrid.extractEMC(extracted);
        return extracted;
    }

    private HandlerEMCCellBase getHandler(IMEInventoryHandler<IAEItemStack> cell) {
        if (cell instanceof HandlerEMCCellBase) {
            return (HandlerEMCCellBase)cell;
        }
        if (cell == null || intHandler == null && !EMCGridCellHandler.reflectFields()) {
            return null;
        }
        IMEInventoryHandler realHandler = null;
        try {
            String className = cell.getClass().getSimpleName();
            if ("DriveWatcher".equals(className)) {
                realHandler = (IMEInventoryHandler)intHandler.get(cell);
            } else if ("ChestMonitorHandler".equals(className)) {
                IMEInventoryHandler monHandler = (IMEInventoryHandler)extHandler.get(cell);
                realHandler = (IMEInventoryHandler)intHandler.get(monHandler);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            CommonUtils.debugLog("Failed to reflect into AE", e);
        }
        if (realHandler instanceof HandlerEMCCellBase) {
            return (HandlerEMCCellBase)realHandler;
        }
        return null;
    }

    private void updatePool(double newMax, double newCurrent) {
        if (newMax != this.hostGrid.getMaxEMC() || newCurrent != this.hostGrid.getCurrentEMC()) {
            this.hostGrid.setMaxEMC(newMax);
            this.hostGrid.setCurrentEMC(newCurrent);
            this.hostGrid.markDirty();
        }
    }

    private static boolean reflectFields() {
        try {
            Class<?> clazz = Class.forName("appeng.me.storage.MEInventoryHandler");
            intHandler = clazz.getDeclaredField("internal");
            intHandler.setAccessible(true);
            clazz = Class.forName("appeng.api.storage.MEMonitorHandler");
            extHandler = clazz.getDeclaredField("internalHandler");
            extHandler.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException | SecurityException e) {
            CommonUtils.debugLog("Failed to reflect into AE", e);
            return false;
        }
        return true;
    }
}

